/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.user;

import com.google.gson.JsonObject;
import com.nimbusds.jwt.SignedJWT;
import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import dev.waterdog.waterdogpe.network.protocol.user.HandshakeUtils;
import dev.waterdog.waterdogpe.network.protocol.user.Platform;
import dev.waterdog.waterdogpe.network.protocol.user.PlayerRewriteUtils;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.util.Collections;
import java.util.UUID;
import org.cloudburstmc.protocol.bedrock.data.auth.AuthType;
import org.cloudburstmc.protocol.bedrock.data.auth.CertificateChainPayload;
import org.cloudburstmc.protocol.bedrock.packet.ClientCacheStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.LoginPacket;
import org.cloudburstmc.protocol.bedrock.packet.RequestChunkRadiusPacket;

public class LoginData {
    private final String displayName;
    private final UUID uuid;
    private final String xuid;
    private final boolean xboxAuthed;
    private final SocketAddress address;
    private final ProtocolVersion protocol;
    private final String joinHostname;
    private final Platform devicePlatform;
    private final String deviceModel;
    private final String deviceId;
    private final KeyPair keyPair;
    private final JsonObject clientData;
    @Deprecated
    private final JsonObject extraData;
    private LoginPacket loginPacket;
    private RequestChunkRadiusPacket chunkRadius;
    private ClientCacheStatusPacket cachePacket;

    public LoginPacket rebuildLoginPacket() {
        SignedJWT signedClientData = HandshakeUtils.createExtraData(this.keyPair, this.extraData);
        SignedJWT signedExtraData = HandshakeUtils.encodeJWT(this.keyPair, this.clientData);
        LoginPacket loginPacket = new LoginPacket();
        loginPacket.setAuthPayload(new CertificateChainPayload(Collections.singletonList(signedClientData.serialize()), AuthType.SELF_SIGNED));
        loginPacket.setClientJwt(signedExtraData.serialize());
        loginPacket.setProtocolVersion(this.protocol.getProtocol());
        this.loginPacket = loginPacket;
        return this.loginPacket;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getXuid() {
        return this.xuid;
    }

    public boolean isXboxAuthed() {
        return this.xboxAuthed;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public ProtocolVersion getProtocol() {
        return this.protocol;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public JsonObject getClientData() {
        return this.clientData;
    }

    @Deprecated
    public JsonObject getExtraData() {
        return this.extraData;
    }

    public String getJoinHostname() {
        return this.joinHostname;
    }

    public Platform getDevicePlatform() {
        return this.devicePlatform;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public LoginPacket getLoginPacket() {
        if (this.loginPacket == null) {
            this.rebuildLoginPacket();
        }
        return this.loginPacket;
    }

    public RequestChunkRadiusPacket getChunkRadius() {
        return this.chunkRadius;
    }

    public void setChunkRadius(RequestChunkRadiusPacket chunkRadius) {
        this.chunkRadius = chunkRadius;
    }

    public ClientCacheStatusPacket getCachePacket() {
        return this.cachePacket;
    }

    public void setCachePacket(ClientCacheStatusPacket cachePacket) {
        this.cachePacket = cachePacket;
    }

    private static Platform $default$devicePlatform() {
        return Platform.UNKNOWN;
    }

    private static String $default$deviceModel() {
        return null;
    }

    private static String $default$deviceId() {
        return null;
    }

    private static RequestChunkRadiusPacket $default$chunkRadius() {
        return PlayerRewriteUtils.defaultChunkRadius;
    }

    private static ClientCacheStatusPacket $default$cachePacket() {
        return PlayerRewriteUtils.defaultCachePacket;
    }

    LoginData(String displayName, UUID uuid, String xuid, boolean xboxAuthed, SocketAddress address, ProtocolVersion protocol, String joinHostname, Platform devicePlatform, String deviceModel, String deviceId, KeyPair keyPair, JsonObject clientData, JsonObject extraData, LoginPacket loginPacket, RequestChunkRadiusPacket chunkRadius, ClientCacheStatusPacket cachePacket) {
        this.displayName = displayName;
        this.uuid = uuid;
        this.xuid = xuid;
        this.xboxAuthed = xboxAuthed;
        this.address = address;
        this.protocol = protocol;
        this.joinHostname = joinHostname;
        this.devicePlatform = devicePlatform;
        this.deviceModel = deviceModel;
        this.deviceId = deviceId;
        this.keyPair = keyPair;
        this.clientData = clientData;
        this.extraData = extraData;
        this.loginPacket = loginPacket;
        this.chunkRadius = chunkRadius;
        this.cachePacket = cachePacket;
    }

    public static LoginDataBuilder builder() {
        return new LoginDataBuilder();
    }

    public static class LoginDataBuilder {
        private String displayName;
        private UUID uuid;
        private String xuid;
        private boolean xboxAuthed;
        private SocketAddress address;
        private ProtocolVersion protocol;
        private String joinHostname;
        private boolean devicePlatform$set;
        private Platform devicePlatform$value;
        private boolean deviceModel$set;
        private String deviceModel$value;
        private boolean deviceId$set;
        private String deviceId$value;
        private KeyPair keyPair;
        private JsonObject clientData;
        private JsonObject extraData;
        private LoginPacket loginPacket;
        private boolean chunkRadius$set;
        private RequestChunkRadiusPacket chunkRadius$value;
        private boolean cachePacket$set;
        private ClientCacheStatusPacket cachePacket$value;

        LoginDataBuilder() {
        }

        public LoginDataBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public LoginDataBuilder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public LoginDataBuilder xuid(String xuid) {
            this.xuid = xuid;
            return this;
        }

        public LoginDataBuilder xboxAuthed(boolean xboxAuthed) {
            this.xboxAuthed = xboxAuthed;
            return this;
        }

        public LoginDataBuilder address(SocketAddress address) {
            this.address = address;
            return this;
        }

        public LoginDataBuilder protocol(ProtocolVersion protocol) {
            this.protocol = protocol;
            return this;
        }

        public LoginDataBuilder joinHostname(String joinHostname) {
            this.joinHostname = joinHostname;
            return this;
        }

        public LoginDataBuilder devicePlatform(Platform devicePlatform) {
            this.devicePlatform$value = devicePlatform;
            this.devicePlatform$set = true;
            return this;
        }

        public LoginDataBuilder deviceModel(String deviceModel) {
            this.deviceModel$value = deviceModel;
            this.deviceModel$set = true;
            return this;
        }

        public LoginDataBuilder deviceId(String deviceId) {
            this.deviceId$value = deviceId;
            this.deviceId$set = true;
            return this;
        }

        public LoginDataBuilder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public LoginDataBuilder clientData(JsonObject clientData) {
            this.clientData = clientData;
            return this;
        }

        @Deprecated
        public LoginDataBuilder extraData(JsonObject extraData) {
            this.extraData = extraData;
            return this;
        }

        public LoginDataBuilder loginPacket(LoginPacket loginPacket) {
            this.loginPacket = loginPacket;
            return this;
        }

        public LoginDataBuilder chunkRadius(RequestChunkRadiusPacket chunkRadius) {
            this.chunkRadius$value = chunkRadius;
            this.chunkRadius$set = true;
            return this;
        }

        public LoginDataBuilder cachePacket(ClientCacheStatusPacket cachePacket) {
            this.cachePacket$value = cachePacket;
            this.cachePacket$set = true;
            return this;
        }

        public LoginData build() {
            Platform devicePlatform$value = this.devicePlatform$value;
            if (!this.devicePlatform$set) {
                devicePlatform$value = LoginData.$default$devicePlatform();
            }
            String deviceModel$value = this.deviceModel$value;
            if (!this.deviceModel$set) {
                deviceModel$value = LoginData.$default$deviceModel();
            }
            String deviceId$value = this.deviceId$value;
            if (!this.deviceId$set) {
                deviceId$value = LoginData.$default$deviceId();
            }
            RequestChunkRadiusPacket chunkRadius$value = this.chunkRadius$value;
            if (!this.chunkRadius$set) {
                chunkRadius$value = LoginData.$default$chunkRadius();
            }
            ClientCacheStatusPacket cachePacket$value = this.cachePacket$value;
            if (!this.cachePacket$set) {
                cachePacket$value = LoginData.$default$cachePacket();
            }
            return new LoginData(this.displayName, this.uuid, this.xuid, this.xboxAuthed, this.address, this.protocol, this.joinHostname, devicePlatform$value, deviceModel$value, deviceId$value, this.keyPair, this.clientData, this.extraData, this.loginPacket, chunkRadius$value, cachePacket$value);
        }

        public String toString() {
            return "LoginData.LoginDataBuilder(displayName=" + this.displayName + ", uuid=" + this.uuid + ", xuid=" + this.xuid + ", xboxAuthed=" + this.xboxAuthed + ", address=" + this.address + ", protocol=" + this.protocol + ", joinHostname=" + this.joinHostname + ", devicePlatform$value=" + this.devicePlatform$value + ", deviceModel$value=" + this.deviceModel$value + ", deviceId$value=" + this.deviceId$value + ", keyPair=" + this.keyPair + ", clientData=" + this.clientData + ", extraData=" + this.extraData + ", loginPacket=" + this.loginPacket + ", chunkRadius$value=" + this.chunkRadius$value + ", cachePacket$value=" + this.cachePacket$value + ")";
        }
    }
}

