/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.rewrite.types;

import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import dev.waterdog.waterdogpe.network.protocol.rewrite.types.BlockPaletteRewrite;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ShortLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import org.apache.commons.lang3.tuple.Pair;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;

public class BlockPalette {
    private static final Int2ObjectMap<BlockPalette> paletteCache = new Int2ObjectOpenHashMap<BlockPalette>();
    private final Object2ShortMap<BlockPair> entryToId = new Object2ShortLinkedOpenHashMap<BlockPair>();
    private final Short2ObjectMap<BlockPair> idToEntry = new Short2ObjectLinkedOpenHashMap<BlockPair>();

    public BlockPalette(NbtList<NbtMap> paletteData, ProtocolVersion protocol) {
        short id = 0;
        for (NbtMap item : paletteData) {
            NbtMap block = item.getCompound("block");
            short s = id;
            id = (short)(id + 1);
            this.addEntry(s, block.getString("name"), block.getCompound("states"));
        }
    }

    public static BlockPalette getPalette(NbtList<NbtMap> paletteData, ProtocolVersion protocol) {
        int hashId = paletteData.hashCode();
        if (paletteCache.containsKey(hashId)) {
            return (BlockPalette)paletteCache.get(hashId);
        }
        BlockPalette palette = new BlockPalette(paletteData, protocol);
        paletteCache.put(hashId, palette);
        return palette;
    }

    public BlockPaletteRewrite createRewrite(BlockPalette upstreamPalette) {
        if (this == upstreamPalette) {
            return BlockPaletteRewrite.BLOCK_EQUAL;
        }
        return new BlockPaletteRewrite(upstreamPalette, this);
    }

    private void addEntry(short id, String name, Object data) {
        BlockPair pair = new BlockPair(name, data);
        this.entryToId.put(pair, id);
        this.idToEntry.put(id, pair);
    }

    public int getId(BlockPair entry) {
        return this.entryToId.getShort(entry) & 0xFFFF;
    }

    public BlockPair getEntry(int id) {
        return (BlockPair)this.idToEntry.get((short)id);
    }

    public static final class BlockPair
    extends Pair<String, Object> {
        private final String key;
        private final Object data;
        private final int hash;

        public BlockPair(String name, Object data) {
            this.key = name;
            this.data = data;
            this.hash = super.hashCode();
        }

        @Override
        public String getLeft() {
            return this.key;
        }

        @Override
        public Object getRight() {
            return this.data;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.hash;
        }
    }
}

