/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.rewrite;

import dev.waterdog.waterdogpe.network.protocol.user.PlayerRewriteUtils;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.AddItemEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.AddPaintingPacket;
import org.cloudburstmc.protocol.bedrock.packet.AddPlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BossEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.cloudburstmc.protocol.bedrock.packet.RemoveEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.RemoveObjectivePacket;
import org.cloudburstmc.protocol.bedrock.packet.SetDisplayObjectivePacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityLinkPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetScorePacket;
import org.cloudburstmc.protocol.common.PacketSignal;

public class EntityTracker
implements BedrockPacketHandler {
    private final ProxiedPlayer player;

    public EntityTracker(ProxiedPlayer player) {
        this.player = player;
    }

    public PacketSignal trackEntity(BedrockPacket packet) {
        return this.handlePacket(packet);
    }

    @Override
    public PacketSignal handle(AddPlayerPacket packet) {
        this.player.getEntities().add(packet.getRuntimeEntityId());
        return PacketSignal.UNHANDLED;
    }

    @Override
    public PacketSignal handle(AddEntityPacket packet) {
        this.player.getEntities().add(packet.getRuntimeEntityId());
        for (EntityLinkData entityLink : packet.getEntityLinks()) {
            this.handleEntityLink(entityLink);
        }
        return PacketSignal.UNHANDLED;
    }

    @Override
    public PacketSignal handle(AddItemEntityPacket packet) {
        this.player.getEntities().add(packet.getRuntimeEntityId());
        return PacketSignal.UNHANDLED;
    }

    @Override
    public PacketSignal handle(AddPaintingPacket packet) {
        this.player.getEntities().add(packet.getRuntimeEntityId());
        return PacketSignal.UNHANDLED;
    }

    @Override
    public PacketSignal handle(RemoveEntityPacket packet) {
        this.player.getEntities().remove(packet.getUniqueEntityId());
        return PacketSignal.UNHANDLED;
    }

    @Override
    public PacketSignal handle(PlayerListPacket packet) {
        List<PlayerListPacket.Entry> entries = packet.getEntries();
        for (PlayerListPacket.Entry entry : entries) {
            if (packet.getAction() == PlayerListPacket.Action.ADD) {
                this.player.getPlayers().add(entry.getUuid());
                continue;
            }
            if (packet.getAction() != PlayerListPacket.Action.REMOVE) continue;
            this.player.getPlayers().remove(entry.getUuid());
        }
        return PacketSignal.UNHANDLED;
    }

    @Override
    public PacketSignal handle(SetEntityLinkPacket packet) {
        this.handleEntityLink(packet.getEntityLink());
        return PacketSignal.UNHANDLED;
    }

    private void handleEntityLink(EntityLinkData entityLink) {
        if (entityLink.getType() == EntityLinkData.Type.REMOVE) {
            this.player.getEntityLinks().remove(entityLink.getFrom());
        } else {
            this.player.getEntityLinks().put(entityLink.getFrom(), entityLink.getTo());
        }
    }

    @Override
    public PacketSignal handle(SetEntityDataPacket packet) {
        if (packet.getRuntimeEntityId() == this.player.getRewriteData().getOriginalEntityId()) {
            boolean immobile = PlayerRewriteUtils.checkForImmobileFlag(packet.getMetadata());
            this.player.getRewriteData().setImmobileFlag(immobile);
        }
        return PacketSignal.UNHANDLED;
    }

    @Override
    public final PacketSignal handle(SetDisplayObjectivePacket packet) {
        this.player.getScoreboards().add(packet.getObjectiveId());
        return PacketSignal.UNHANDLED;
    }

    @Override
    public final PacketSignal handle(RemoveObjectivePacket packet) {
        this.player.getScoreboards().remove(packet.getObjectiveId());
        return PacketSignal.UNHANDLED;
    }

    @Override
    public final PacketSignal handle(SetScorePacket packet) {
        switch (packet.getAction()) {
            case SET: {
                for (ScoreInfo info : packet.getInfos()) {
                    this.player.getScoreInfos().put(info.getScoreboardId(), info);
                }
                break;
            }
            case REMOVE: {
                for (ScoreInfo info : packet.getInfos()) {
                    this.player.getScoreInfos().remove(info.getScoreboardId());
                }
                break;
            }
        }
        return PacketSignal.UNHANDLED;
    }

    @Override
    public final PacketSignal handle(BossEventPacket packet) {
        switch (packet.getAction()) {
            case CREATE: {
                this.player.getBossbars().add(packet.getBossUniqueEntityId());
                break;
            }
            case REMOVE: {
                this.player.getBossbars().remove(packet.getBossUniqueEntityId());
            }
        }
        return PacketSignal.UNHANDLED;
    }
}

