/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.rewrite;

import dev.waterdog.waterdogpe.network.protocol.rewrite.types.BlockPaletteRewrite;
import dev.waterdog.waterdogpe.network.protocol.rewrite.types.RewriteData;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import org.cloudburstmc.protocol.bedrock.data.LevelEvent;
import org.cloudburstmc.protocol.bedrock.data.LevelEventType;
import org.cloudburstmc.protocol.bedrock.data.ParticleType;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.LevelChunkPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.cloudburstmc.protocol.common.util.VarInts;

public class BlockMap
implements BedrockPacketHandler {
    protected static final int nV8Blocks = 4096;
    protected final ProxiedPlayer player;
    protected final RewriteData rewrite;

    public BlockMap(ProxiedPlayer player) {
        this.player = player;
        this.rewrite = player.getRewriteData();
    }

    public BlockPaletteRewrite getPaletteRewrite() {
        return this.rewrite.getBlockPaletteRewrite();
    }

    public PacketSignal doRewrite(BedrockPacket packet) {
        return this.player.canRewrite() ? this.handlePacket(packet) : PacketSignal.UNHANDLED;
    }

    protected int translateId(int runtimeId) {
        return this.getPaletteRewrite().fromDownstream(runtimeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PacketSignal handle(LevelChunkPacket packet) {
        ByteBuf from = packet.getData();
        ByteBuf to = AbstractByteBufAllocator.DEFAULT.ioBuffer(from.readableBytes());
        try {
            boolean success = this.rewriteChunkData(from, to, packet.getSubChunksLength());
            if (success) {
                to.writeBytes(from);
                packet.setData(to.retain());
            }
            PacketSignal packetSignal = success ? PacketSignal.HANDLED : PacketSignal.UNHANDLED;
            return packetSignal;
        }
        finally {
            from.release();
            to.release();
        }
    }

    private boolean rewriteChunkData(ByteBuf from, ByteBuf to, int sections) {
        block4: for (int section = 0; section < sections; ++section) {
            short chunkVersion = from.readUnsignedByte();
            to.writeByte(chunkVersion);
            switch (chunkVersion) {
                case 0: 
                case 4: 
                case 139: {
                    to.writeBytes(from);
                    return true;
                }
                case 8: {
                    int storageCount = from.readUnsignedByte();
                    to.writeByte(storageCount);
                    for (int storage = 0; storage < storageCount; ++storage) {
                        short flags = from.readUnsignedByte();
                        int bitsPerBlock = flags >> 1;
                        int blocksPerWord = 32 / bitsPerBlock;
                        int nWords = (4096 + blocksPerWord - 1) / blocksPerWord;
                        to.writeByte(flags);
                        to.writeBytes(from, nWords * 4);
                        int nPaletteEntries = VarInts.readInt(from);
                        VarInts.writeInt(to, nPaletteEntries);
                        for (int i = 0; i < nPaletteEntries; ++i) {
                            int runtimeId = VarInts.readInt(from);
                            VarInts.writeInt(to, this.translateId(runtimeId));
                        }
                    }
                    continue block4;
                }
                default: {
                    this.player.getLogger().warning("PEBlockRewrite: Unknown subchunk format " + chunkVersion);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public PacketSignal handle(UpdateBlockPacket packet) {
        int runtimeId = packet.getDefinition().getRuntimeId();
        BlockDefinition definition = this.player.getRewriteData().getCodecHelper().getBlockDefinitions().getDefinition(this.translateId(runtimeId));
        packet.setDefinition(definition);
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(LevelEventPacket packet) {
        LevelEventType type = packet.getType();
        if (type != ParticleType.TERRAIN && type != LevelEvent.PARTICLE_DESTROY_BLOCK && type != LevelEvent.PARTICLE_CRACK_BLOCK) {
            return PacketSignal.UNHANDLED;
        }
        int data = packet.getData();
        int high = data & 0xFFFF0000;
        int blockID = this.translateId(data & 0xFFFF) & 0xFFFF;
        packet.setData(high | blockID);
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(LevelSoundEventPacket packet) {
        if (packet.getSound() != SoundEvent.PLACE) {
            return PacketSignal.UNHANDLED;
        }
        int runtimeId = packet.getExtraData();
        packet.setExtraData(this.translateId(runtimeId));
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(AddEntityPacket packet) {
        if (!packet.getIdentifier().equals("minecraft:falling_block")) {
            return PacketSignal.UNHANDLED;
        }
        EntityDataMap metaData = packet.getMetadata();
        int runtimeId = metaData.get(EntityDataTypes.VARIANT);
        metaData.put(EntityDataTypes.VARIANT, (Object)this.translateId(runtimeId));
        return PacketSignal.HANDLED;
    }
}

