/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.registry;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.ItemDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleBlockDefinition;
import org.cloudburstmc.protocol.bedrock.data.definitions.SimpleItemDefinition;
import org.cloudburstmc.protocol.common.Definition;
import org.cloudburstmc.protocol.common.DefinitionRegistry;

public class FakeDefinitionRegistry<D extends Definition>
implements DefinitionRegistry<D> {
    private final Int2ObjectMap<D> runtimeMap = new Int2ObjectOpenHashMap<D>();
    private final Int2ObjectFunction<D> factory;

    public static FakeDefinitionRegistry<BlockDefinition> createBlockRegistry() {
        return new FakeDefinitionRegistry<BlockDefinition>(rid -> new SimpleBlockDefinition("unknown", rid, null));
    }

    public static FakeDefinitionRegistry<ItemDefinition> createItemRegistry() {
        return new FakeDefinitionRegistry<ItemDefinition>(rid -> new SimpleItemDefinition("unknown", rid, false));
    }

    public FakeDefinitionRegistry(Int2ObjectFunction<D> factory) {
        this.factory = factory;
    }

    public D getDefinition(String identifier) {
        return null;
    }

    @Override
    public D getDefinition(int runtimeId) {
        Definition definition = (Definition)this.runtimeMap.get(runtimeId);
        if (definition == null) {
            definition = (Definition)this.factory.get(runtimeId);
            this.runtimeMap.put(runtimeId, (D)definition);
        }
        return (D)definition;
    }

    @Override
    public boolean isRegistered(D definition) {
        return this.runtimeMap.get(definition.getRuntimeId()) == definition;
    }
}

