/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.handler.upstream;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.WaterdogPE;
import dev.waterdog.waterdogpe.event.defaults.PlayerAuthenticatedEvent;
import dev.waterdog.waterdogpe.network.connection.codec.compression.CompressionType;
import dev.waterdog.waterdogpe.network.connection.peer.BedrockServerSession;
import dev.waterdog.waterdogpe.network.netease.NetEaseUtils;
import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import dev.waterdog.waterdogpe.network.protocol.user.HandshakeEntry;
import dev.waterdog.waterdogpe.network.protocol.user.HandshakeUtils;
import dev.waterdog.waterdogpe.network.protocol.user.LoginData;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import dev.waterdog.waterdogpe.security.SecurityManager;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.compat.BedrockCompat;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.ClientToServerHandshakePacket;
import org.cloudburstmc.protocol.bedrock.packet.LoginPacket;
import org.cloudburstmc.protocol.bedrock.packet.NetworkSettingsPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.RequestNetworkSettingsPacket;
import org.cloudburstmc.protocol.common.PacketSignal;

public class LoginUpstreamHandler
implements BedrockPacketHandler {
    private final ProxyServer proxy;
    private final BedrockServerSession session;
    private ProxiedPlayer player;
    private boolean loginInitialized;
    private CompressionType compression;

    public LoginUpstreamHandler(ProxyServer proxy, BedrockServerSession session) {
        this.proxy = proxy;
        this.session = session;
    }

    private void onLoginFailed(HandshakeEntry handshakeEntry, Throwable throwable, String disconnectReason) {
        String message = this.proxy.getSecurityManager().onLoginFailed(this.session.getSocketAddress(), handshakeEntry, throwable, disconnectReason);
        if (this.session.isConnected()) {
            this.session.disconnect(Objects.requireNonNullElse(message, "Login Failed"));
        }
    }

    private boolean attemptLogin() {
        if (this.loginInitialized) {
            return true;
        }
        this.loginInitialized = true;
        SecurityManager securityManager = this.proxy.getSecurityManager();
        if (!securityManager.onLoginAttempt(this.session.getSocketAddress())) {
            this.proxy.getLogger().debug("[{}] <-> Login denied", this.session.getSocketAddress());
            this.session.disconnect("Login denied");
            return false;
        }
        return true;
    }

    private ProtocolVersion checkVersion(int protocolVersion) {
        ProtocolVersion protocol = ProtocolVersion.get(protocolVersion);
        if (protocol != null) {
            return protocol;
        }
        PlayStatusPacket status = new PlayStatusPacket();
        status.setStatus(protocolVersion > WaterdogPE.version().latestProtocolVersion() ? PlayStatusPacket.Status.LOGIN_FAILED_SERVER_OLD : PlayStatusPacket.Status.LOGIN_FAILED_CLIENT_OLD);
        this.session.sendPacketImmediately(status);
        this.session.disconnect();
        this.proxy.getLogger().warning("[{}] <-> Upstream has disconnected due to incompatible protocol (protocol={})", this.session.getSocketAddress(), protocolVersion);
        return null;
    }

    @Override
    public PacketSignal handle(RequestNetworkSettingsPacket packet) {
        ProtocolVersion protocol;
        if (!this.attemptLogin() || (protocol = this.checkVersion(packet.getProtocolVersion())) == null) {
            return PacketSignal.HANDLED;
        }
        this.session.setCodec(protocol.getCodec());
        if (protocol.isBefore(ProtocolVersion.MINECRAFT_PE_1_19_30)) {
            this.session.disconnect("Illegal packet");
            this.proxy.getLogger().warning("[{}] <-> Upstream has requested network settings, but its version doesn't support it (protocol={})", this.session.getSocketAddress(), protocol.getProtocol());
            return PacketSignal.HANDLED;
        }
        this.compression = this.proxy.getConfiguration().getCompression();
        NetworkSettingsPacket settingsPacket = new NetworkSettingsPacket();
        settingsPacket.setCompressionThreshold(1);
        settingsPacket.setCompressionAlgorithm(this.compression.getBedrockAlgorithm());
        this.session.sendPacketImmediately(settingsPacket);
        if (!this.session.isSubClient()) {
            this.session.getPeer().setCompression(this.compression);
        }
        return PacketSignal.HANDLED;
    }

    private int getRaknetProtocol() {
        try {
            return this.session.getPeer().getRakVersion();
        }
        catch (Exception e) {
            this.proxy.getLogger().debug("\u65e0\u6cd5\u83b7\u53d6raknet\u534f\u8bae\u7248\u672c\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c11: {}", e.getMessage());
            return 11;
        }
    }

    @Override
    public PacketSignal handle(LoginPacket packet) {
        ProtocolVersion protocol;
        if (!this.attemptLogin() || (protocol = this.checkVersion(packet.getProtocolVersion())) == null) {
            return PacketSignal.HANDLED;
        }
        BedrockCodec codec = this.session.getCodec();
        if (codec == null || codec == BedrockCompat.CODEC) {
            this.session.getPeer().setProtocol(protocol);
        }
        int raknetProtocol = this.getRaknetProtocol();
        boolean isNetEaseMode = NetEaseUtils.isNetEaseClient(raknetProtocol, packet.getProtocolVersion());
        if (protocol.isAfterOrEqual(ProtocolVersion.MINECRAFT_PE_1_19_30) && this.compression == null) {
            this.proxy.getLogger().warning("[{}] <-> Upstream has not requested network settings (protocol={})", this.session.getSocketAddress(), protocol.getProtocol());
            this.session.disconnect("Wrong login flow");
            return PacketSignal.HANDLED;
        }
        if (this.compression == null) {
            this.compression = CompressionType.ZLIB;
        }
        HandshakeEntry handshakeEntry = null;
        boolean strictAuth = this.proxy.getConfiguration().isOnlineMode();
        this.session.setLogging(WaterdogPE.version().debug());
        try {
            handshakeEntry = HandshakeUtils.processHandshake(this.session, packet, protocol, strictAuth, isNetEaseMode);
            if (!handshakeEntry.isXboxAuthed() && strictAuth) {
                this.onLoginFailed(handshakeEntry, null, "disconnectionScreen.notAuthenticated");
                this.proxy.getLogger().info("[{}|{}] <-> Upstream has disconnected due to failed XBOX authentication!", this.session.getSocketAddress(), handshakeEntry.getDisplayName());
                return PacketSignal.HANDLED;
            }
            if (protocol.equals((Object)ProtocolVersion.MINECRAFT_PE_1_19_60) && handshakeEntry.getClientData().has("GameVersion") && ProtocolVersion.MINECRAFT_PE_1_19_62.getMinecraftVersion().equals(handshakeEntry.getClientData().get("GameVersion").getAsString())) {
                protocol = ProtocolVersion.MINECRAFT_PE_1_19_62;
                handshakeEntry.setProtocol(protocol);
                this.session.getPeer().setProtocol(protocol);
            }
            this.proxy.getLogger().info("[{}|{}] <-> Upstream has connected (protocol={} version={})", this.session.getSocketAddress(), handshakeEntry.getDisplayName(), protocol.getProtocol(), protocol.getMinecraftVersion());
            LoginData loginData = handshakeEntry.buildData(this.session, this.proxy);
            PlayerAuthenticatedEvent loginEvent = new PlayerAuthenticatedEvent(ProxiedPlayer.class, loginData, (InetSocketAddress)this.session.getSocketAddress());
            this.proxy.getEventManager().callEvent(loginEvent);
            if (loginEvent.isCancelled()) {
                this.session.disconnect(loginEvent.getCancelReason());
                return PacketSignal.HANDLED;
            }
            this.player = loginEvent.getBaseClass().getConstructor(ProxyServer.class, BedrockServerSession.class, CompressionType.class, LoginData.class).newInstance(this.proxy, this.session, this.compression, loginData);
            if (!this.proxy.getPlayerManager().registerPlayer(this.player)) {
                return PacketSignal.HANDLED;
            }
            boolean shouldEnableEncryption = this.proxy.getConfiguration().isUpstreamEncryption();
            if (isNetEaseMode) {
                shouldEnableEncryption = false;
                this.proxy.getLogger().debug("[{}] <-> NetEase\u6a21\u5f0f\uff1a\u5173\u95ed\u52a0\u5bc6\u8fde\u63a5", this.session.getSocketAddress());
            }
            if (shouldEnableEncryption) {
                HandshakeUtils.processEncryption(this.session, handshakeEntry.getIdentityPublicKey());
            } else {
                this.finishConnection();
            }
        }
        catch (Exception e) {
            this.onLoginFailed(handshakeEntry, e, "Login failed: " + e.getMessage());
            this.proxy.getLogger().error("[{}] Unable to complete login", this.session.getSocketAddress(), e);
        }
        return PacketSignal.HANDLED;
    }

    @Override
    public PacketSignal handle(ClientToServerHandshakePacket packet) {
        this.finishConnection();
        return PacketSignal.HANDLED;
    }

    private void finishConnection() {
        PlayStatusPacket status = new PlayStatusPacket();
        status.setStatus(PlayStatusPacket.Status.LOGIN_SUCCESS);
        this.session.sendPacket(status);
        this.player.initPlayer();
    }
}

