/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.handler.upstream;

import dev.waterdog.waterdogpe.network.protocol.Signals;
import dev.waterdog.waterdogpe.network.protocol.handler.PluginPacketHandler;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import org.cloudburstmc.protocol.bedrock.PacketDirection;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.ClientCacheStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.PacketViolationWarningPacket;
import org.cloudburstmc.protocol.common.PacketSignal;

public abstract class AbstractUpstreamHandler
implements BedrockPacketHandler {
    protected final ProxiedPlayer player;

    public AbstractUpstreamHandler(ProxiedPlayer player) {
        this.player = player;
    }

    @Override
    public PacketSignal handlePacket(BedrockPacket packet) {
        PacketSignal signal = BedrockPacketHandler.super.handlePacket(packet);
        if (this.player.getPluginPacketHandlers().size() > 0) {
            for (PluginPacketHandler handler : this.player.getPluginPacketHandlers()) {
                signal = Signals.mergeSignals(signal, handler.handlePacket(packet, PacketDirection.SERVER_BOUND));
            }
        }
        return signal;
    }

    @Override
    public PacketSignal handle(ClientCacheStatusPacket packet) {
        this.player.getLoginData().setCachePacket(packet);
        return this.cancel();
    }

    @Override
    public final PacketSignal handle(PacketViolationWarningPacket packet) {
        this.player.getLogger().warning("Received violation from " + this.player.getName() + ": " + packet.toString());
        return this.cancel();
    }

    protected PacketSignal cancel() {
        if (this.player.hasUpstreamBridge()) {
            return Signals.CANCEL;
        }
        return PacketSignal.HANDLED;
    }
}

