/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.handler.downstream;

import com.nimbusds.jwt.SignedJWT;
import dev.waterdog.waterdogpe.event.defaults.ServerTransferEvent;
import dev.waterdog.waterdogpe.network.connection.client.ClientConnection;
import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import dev.waterdog.waterdogpe.network.protocol.Signals;
import dev.waterdog.waterdogpe.network.protocol.handler.TransferCallback;
import dev.waterdog.waterdogpe.network.protocol.handler.downstream.AbstractDownstreamHandler;
import dev.waterdog.waterdogpe.network.protocol.rewrite.types.BlockPalette;
import dev.waterdog.waterdogpe.network.protocol.rewrite.types.RewriteData;
import dev.waterdog.waterdogpe.network.protocol.user.HandshakeUtils;
import dev.waterdog.waterdogpe.network.protocol.user.PlayerRewriteUtils;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import dev.waterdog.waterdogpe.utils.types.TranslationContainer;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.net.URI;
import java.security.interfaces.ECPublicKey;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.cloudburstmc.protocol.bedrock.packet.BiomeDefinitionListPacket;
import org.cloudburstmc.protocol.bedrock.packet.ClientToServerHandshakePacket;
import org.cloudburstmc.protocol.bedrock.packet.DisconnectPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayStatusPacket;
import org.cloudburstmc.protocol.bedrock.packet.ResourcePackClientResponsePacket;
import org.cloudburstmc.protocol.bedrock.packet.ResourcePackStackPacket;
import org.cloudburstmc.protocol.bedrock.packet.ResourcePacksInfoPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerToClientHandshakePacket;
import org.cloudburstmc.protocol.bedrock.packet.StartGamePacket;
import org.cloudburstmc.protocol.bedrock.util.EncryptionUtils;
import org.cloudburstmc.protocol.common.PacketSignal;

public class SwitchDownstreamHandler
extends AbstractDownstreamHandler {
    private static final Logger log = LogManager.getLogger(SwitchDownstreamHandler.class);

    public SwitchDownstreamHandler(ProxiedPlayer player, ClientConnection connection) {
        super(player, connection);
    }

    @Override
    public final PacketSignal handle(ServerToClientHandshakePacket packet) {
        try {
            SignedJWT saltJwt = SignedJWT.parse(packet.getJwt());
            URI x5u = saltJwt.getHeader().getX509CertURL();
            ECPublicKey serverKey = HandshakeUtils.generateKey(x5u.toASCIIString());
            SecretKey key = EncryptionUtils.getSecretKey(this.player.getLoginData().getKeyPair().getPrivate(), serverKey, Base64.getDecoder().decode(saltJwt.getJWTClaimsSet().getStringClaim("salt")));
            this.connection.enableEncryption(key);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to enable encryption", e);
        }
        ClientToServerHandshakePacket clientToServerHandshake = new ClientToServerHandshakePacket();
        this.connection.sendPacket(clientToServerHandshake);
        return Signals.CANCEL;
    }

    @Override
    public final PacketSignal handle(ResourcePacksInfoPacket packet) {
        ResourcePackClientResponsePacket response = new ResourcePackClientResponsePacket();
        response.setStatus(ResourcePackClientResponsePacket.Status.HAVE_ALL_PACKS);
        this.connection.sendPacket(response);
        return Signals.CANCEL;
    }

    @Override
    public final PacketSignal handle(ResourcePackStackPacket packet) {
        ResourcePackClientResponsePacket response = new ResourcePackClientResponsePacket();
        response.setStatus(ResourcePackClientResponsePacket.Status.COMPLETED);
        this.connection.sendPacket(response);
        return Signals.CANCEL;
    }

    @Override
    public PacketSignal handle(PlayStatusPacket packet) {
        return this.onPlayStatus(packet, message -> {
            this.connection.disconnect();
            this.player.sendMessage(new TranslationContainer("waterdog.downstream.transfer.failed", this.connection.getServerInfo().getServerName(), (String)message));
        }, this.connection);
    }

    @Override
    public final PacketSignal handle(StartGamePacket packet) {
        boolean fastTransfer;
        RewriteData rewriteData = this.player.getRewriteData();
        rewriteData.setOriginalEntityId(packet.getRuntimeEntityId());
        rewriteData.setGameRules(packet.getGamerules());
        rewriteData.setSpawnPosition(packet.getPlayerPosition());
        rewriteData.setRotation(packet.getRotation());
        if (this.player.getProtocol().isBeforeOrEqual(ProtocolVersion.MINECRAFT_PE_1_16_20)) {
            BlockPalette palette = BlockPalette.getPalette(packet.getBlockPalette(), this.player.getProtocol());
            rewriteData.setBlockPaletteRewrite(palette.createRewrite(rewriteData.getBlockPalette()));
        } else {
            rewriteData.setBlockProperties(packet.getBlockProperties());
        }
        if (!this.player.isConnected()) {
            this.connection.disconnect();
            this.player.disconnect("transfer disconnected");
            return Signals.CANCEL;
        }
        if (rewriteData.getTransferCallback() != null && rewriteData.getTransferCallback().getPhase() != TransferCallback.TransferPhase.RESET) {
            this.connection.disconnect();
            String serverName = this.connection.getServerInfo().getServerName();
            this.player.sendMessage(new TranslationContainer("waterdog.downstream.connecting", serverName));
            log.warn("[{}] Aborted server transfer to {} because player is already being transferred!", (Object)this.player.getName(), (Object)serverName);
            return Signals.CANCEL;
        }
        ClientConnection oldConnection = this.player.getDownstreamConnection();
        oldConnection.getServerInfo().removeConnection(oldConnection);
        oldConnection.disconnect();
        this.player.setDownstreamConnection(this.connection);
        this.connection.getServerInfo().addConnection(this.connection);
        this.player.setAcceptPlayStatus(true);
        ServerTransferEvent event = new ServerTransferEvent(this.player, oldConnection.getServerInfo(), this.connection.getServerInfo());
        this.player.getProxy().getEventManager().callEvent(event);
        LongSet blobs = this.player.getChunkBlobs();
        if (this.player.getProtocol().isBefore(ProtocolVersion.MINECRAFT_PE_1_18_30) && this.player.getLoginData().getCachePacket().isSupported() && !blobs.isEmpty()) {
            PlayerRewriteUtils.injectChunkCacheBlobs(this.player.getConnection(), blobs);
        }
        this.player.getChunkBlobs().clear();
        Long2LongMap entityLinks = this.player.getEntityLinks();
        for (Long2LongMap.Entry entry : entityLinks.long2LongEntrySet()) {
            PlayerRewriteUtils.injectRemoveEntityLink(this.player.getConnection(), entry.getLongKey(), entry.getLongValue());
        }
        entityLinks.clear();
        LongSet bossbars = this.player.getBossbars();
        LongIterator longIterator = bossbars.iterator();
        while (longIterator.hasNext()) {
            long bossbarId = (Long)longIterator.next();
            PlayerRewriteUtils.injectRemoveBossbar(this.player.getConnection(), bossbarId);
        }
        bossbars.clear();
        Collection<UUID> collection = this.player.getPlayers();
        PlayerRewriteUtils.injectRemoveAllPlayers(this.player.getConnection(), collection);
        collection.clear();
        LongSet entities = this.player.getEntities();
        LongIterator longIterator2 = entities.iterator();
        while (longIterator2.hasNext()) {
            long entityId = (Long)longIterator2.next();
            PlayerRewriteUtils.injectRemoveEntity(this.player.getConnection(), entityId);
        }
        entities.clear();
        Long2ObjectMap<ScoreInfo> scoreInfos = this.player.getScoreInfos();
        PlayerRewriteUtils.injectRemoveScoreInfos(this.player.getConnection(), scoreInfos);
        scoreInfos.clear();
        ObjectSet<String> scoreboards = this.player.getScoreboards();
        for (String scoreboard : scoreboards) {
            PlayerRewriteUtils.injectRemoveObjective(this.player.getConnection(), scoreboard);
        }
        scoreboards.clear();
        PlayerRewriteUtils.injectRemoveAllEffects(this.player.getConnection(), rewriteData.getEntityId(), this.player.getProtocol());
        PlayerRewriteUtils.injectClearWeather(this.player.getConnection());
        PlayerRewriteUtils.injectGameMode(this.player.getConnection(), packet.getPlayerGameType());
        PlayerRewriteUtils.injectSetDifficulty(this.player.getConnection(), packet.getDifficulty());
        PlayerRewriteUtils.injectGameRules(this.player.getConnection(), packet.getGamerules());
        this.connection.sendPacket(this.player.getLoginData().getChunkRadius());
        int newDimension = PlayerRewriteUtils.determineDimensionId(rewriteData.getDimension(), packet.getDimensionId());
        TransferCallback transferCallback = new TransferCallback(this.player, this.connection, oldConnection.getServerInfo(), packet.getDimensionId());
        rewriteData.setDimension(newDimension);
        rewriteData.setTransferCallback(transferCallback);
        boolean bl = fastTransfer = event.isTransferScreenAllowed() && newDimension != packet.getDimensionId();
        if (fastTransfer) {
            Vector3f fakePosition = packet.getPlayerPosition().add(2000.0f, 0.0f, 2000.0f);
            PlayerRewriteUtils.injectPosition(this.player.getConnection(), fakePosition, packet.getRotation(), rewriteData.getEntityId());
            this.player.getConnection().setTransferQueueActive(true);
            PlayerRewriteUtils.injectDimensionChange(this.player.getConnection(), newDimension, fakePosition, rewriteData.getEntityId(), this.player.getProtocol(), true);
            this.player.getProxy().getScheduler().scheduleDelayed(() -> {
                PlayStatusPacket statusPacket = new PlayStatusPacket();
                statusPacket.setStatus(PlayStatusPacket.Status.PLAYER_SPAWN);
                this.player.getConnection().sendPacketImmediately(statusPacket);
            }, 40);
        } else if (newDimension == packet.getDimensionId()) {
            PlayerRewriteUtils.injectPosition(this.player.getConnection(), packet.getPlayerPosition(), packet.getRotation(), rewriteData.getEntityId());
            PlayerRewriteUtils.injectDimensionChange(this.player.getConnection(), newDimension, packet.getPlayerPosition(), rewriteData.getEntityId(), this.player.getProtocol(), false);
            transferCallback.onDimChangeSuccess();
        } else {
            PlayerRewriteUtils.injectPosition(this.player.getConnection(), packet.getPlayerPosition(), packet.getRotation(), rewriteData.getEntityId());
            rewriteData.setDimension(packet.getDimensionId());
            transferCallback.onDimChangeSuccess();
            transferCallback.onDimChangeSuccess();
        }
        return Signals.CANCEL;
    }

    @Override
    public PacketSignal handle(BiomeDefinitionListPacket packet) {
        boolean isNetease = this.player.isNeteaseClient;
        if (isNetease) {
            this.player.getLogger().debug("[Netease] Blocking BiomeDefinitionListPacket (ID: 122) from being sent to client during server switch");
            return Signals.CANCEL;
        }
        return super.handle(packet);
    }

    @Override
    public PacketSignal handle(DisconnectPacket packet) {
        TransferCallback transferCallback = this.player.getRewriteData().getTransferCallback();
        if (transferCallback != null) {
            transferCallback.onTransferFailed();
            return Signals.CANCEL;
        }
        this.connection.disconnect();
        this.player.sendMessage(new TranslationContainer("waterdog.downstream.transfer.failed", this.connection.getServerInfo().getServerName(), packet.getKickMessage()));
        return Signals.CANCEL;
    }
}

