/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.protocol.handler;

import dev.waterdog.waterdogpe.network.connection.ProxiedConnection;
import dev.waterdog.waterdogpe.network.protocol.Signals;
import dev.waterdog.waterdogpe.network.protocol.handler.ProxyPacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.util.ListIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.protocol.bedrock.PacketDirection;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.cloudburstmc.protocol.common.util.Preconditions;

public class ProxyBatchBridge
implements BedrockPacketHandler {
    private static final Logger log = LogManager.getLogger(ProxyBatchBridge.class);
    private final BedrockCodec codec;
    private final BedrockCodecHelper helper;
    private ProxyPacketHandler handler;
    private boolean forceEncode;

    public ProxyBatchBridge(BedrockCodec codec, BedrockCodecHelper helper, ProxyPacketHandler handler) {
        this.codec = codec;
        this.helper = helper;
        this.setHandler(handler);
    }

    public void onBedrockBatch(ProxiedConnection source, BedrockBatchWrapper batch) {
        ListIterator<BedrockPacketWrapper> iterator = batch.getPackets().listIterator();
        while (iterator.hasNext()) {
            BedrockPacketWrapper wrapper = iterator.next();
            if (wrapper.getPacket() == null) {
                this.decodePacket(wrapper, source.getPacketDirection());
            }
            PacketSignal signal = this.handlePacket(wrapper.getPacket());
            if (this.isForceEncode() || signal == PacketSignal.HANDLED) {
                ReferenceCountUtil.release(wrapper.getPacketBuffer());
                wrapper.setPacketBuffer(null);
                batch.modify();
                continue;
            }
            if (signal != Signals.CANCEL) continue;
            iterator.remove();
            wrapper.release();
            batch.modify();
        }
        if (!batch.getPackets().isEmpty()) {
            this.sendProxiedBatch(batch);
        }
    }

    @Override
    public PacketSignal handlePacket(BedrockPacket packet) {
        try {
            PacketSignal signal = this.handler.handlePacket(packet);
            PacketSignal rewriteSignal = this.handler.doPacketRewrite(packet);
            this.handler.getRewriteMaps().getEntityTracker().trackEntity(packet);
            return Signals.mergeSignals(signal, rewriteSignal);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while handling " + packet.getPacketType(), e);
        }
    }

    private void decodePacket(BedrockPacketWrapper wrapper, PacketDirection direction) {
        ByteBuf msg = wrapper.getPacketBuffer().retainedSlice();
        try {
            msg.skipBytes(wrapper.getHeaderLength());
            wrapper.setPacket(this.codec.tryDecode(this.helper, msg, wrapper.getPacketId(), direction.getInbound()));
        }
        catch (Throwable t) {
            String errorMessage = t.getMessage();
            if (errorMessage != null && errorMessage.contains("commands=[]")) {
                log.warn("Failed to decode packet: {}", (Object)errorMessage);
            } else {
                log.warn("Failed to decode packet", t);
            }
            throw t;
        }
        finally {
            msg.release();
        }
    }

    public void sendProxiedBatch(BedrockBatchWrapper batch) {
        this.handler.sendProxiedBatch(batch);
    }

    public void setHandler(ProxyPacketHandler handler) {
        Preconditions.checkNotNull(handler, "Handler can not be null");
        this.handler = handler;
    }

    public BedrockCodec getCodec() {
        return this.codec;
    }

    public BedrockCodecHelper getHelper() {
        return this.helper;
    }

    public ProxyPacketHandler getHandler() {
        return this.handler;
    }

    public boolean isForceEncode() {
        return this.forceEncode;
    }

    public void setForceEncode(boolean forceEncode) {
        this.forceEncode = forceEncode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyBatchBridge)) {
            return false;
        }
        ProxyBatchBridge other = (ProxyBatchBridge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isForceEncode() != other.isForceEncode()) {
            return false;
        }
        BedrockCodec this$codec = this.getCodec();
        BedrockCodec other$codec = other.getCodec();
        if (this$codec == null ? other$codec != null : !this$codec.equals(other$codec)) {
            return false;
        }
        BedrockCodecHelper this$helper = this.getHelper();
        BedrockCodecHelper other$helper = other.getHelper();
        if (this$helper == null ? other$helper != null : !this$helper.equals(other$helper)) {
            return false;
        }
        ProxyPacketHandler this$handler = this.getHandler();
        ProxyPacketHandler other$handler = other.getHandler();
        return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyBatchBridge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceEncode() ? 79 : 97);
        BedrockCodec $codec = this.getCodec();
        result = result * 59 + ($codec == null ? 43 : $codec.hashCode());
        BedrockCodecHelper $helper = this.getHelper();
        result = result * 59 + ($helper == null ? 43 : $helper.hashCode());
        ProxyPacketHandler $handler = this.getHandler();
        result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
        return result;
    }

    public String toString() {
        return "ProxyBatchBridge(codec=" + this.getCodec() + ", helper=" + this.getHelper() + ", handler=" + this.getHandler() + ", forceEncode=" + this.isForceEncode() + ")";
    }
}

