/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.netease.codec;

import dev.waterdog.waterdogpe.network.connection.codec.compression.CompressionType;
import dev.waterdog.waterdogpe.network.connection.codec.compression.ProxiedCompressionCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionStrategy;

public class NetEaseCompressionCodec
extends ProxiedCompressionCodec {
    private static final Logger log = LogManager.getLogger(NetEaseCompressionCodec.class);
    private static final int MAX_DECOMPRESSION_SIZE = 0x300000;

    public NetEaseCompressionCodec(CompressionStrategy strategy, boolean prefixed) {
        super(strategy, prefixed);
        log.debug("Netease\u538b\u7f29\u7f16\u89e3\u7801\u5668\u5df2\u521b\u5efa\uff0c\u524d\u7f00\u542f\u7528: {}", (Object)prefixed);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, BedrockBatchWrapper msg, List<Object> out) throws Exception {
        ByteBuf uncompressed = msg.getUncompressed();
        if (uncompressed == null) {
            throw new IllegalStateException("Batch was not encoded before");
        }
        if (uncompressed.readableBytes() == 0) {
            log.warn("[{}] \u8f93\u5165\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u7f16\u7801", (Object)ctx.channel().remoteAddress());
            return;
        }
        try {
            byte secondByte = uncompressed.getByte(1);
            int secondValue = secondByte & 0xFF;
            if (secondValue == 143) {
                ByteBuf finalData = ctx.alloc().directBuffer(uncompressed.readableBytes() + 1);
                finalData.writeByte(254);
                finalData.writeBytes(uncompressed, uncompressed.readerIndex(), uncompressed.readableBytes());
                out.add(finalData.retain());
                finalData.release();
            } else {
                try {
                    ByteBuf compressedData = this.compressWithZlibRaw(ctx, uncompressed);
                    ByteBuf finalData = ctx.alloc().directBuffer(compressedData.readableBytes() + 2);
                    finalData.writeByte(254);
                    finalData.writeByte(0);
                    finalData.writeBytes(compressedData);
                    out.add(finalData.retain());
                    finalData.release();
                    compressedData.release();
                }
                catch (Exception e) {
                    ByteBuf finalData = ctx.alloc().directBuffer(uncompressed.readableBytes() + 1);
                    finalData.writeByte(254);
                    finalData.writeBytes(uncompressed, uncompressed.readerIndex(), uncompressed.readableBytes());
                    out.add(finalData.retain());
                    finalData.release();
                }
            }
        }
        catch (Exception e) {
            log.error("[{}] NetEase\u7f16\u7801\u5931\u8d25: {}", (Object)ctx.channel().remoteAddress(), (Object)e.getMessage(), (Object)e);
            throw e;
        }
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, BedrockBatchWrapper msg, List<Object> out) throws Exception {
        byte firstByte;
        ByteBuf compressed = msg.getCompressed();
        if (compressed == null || !compressed.isReadable()) {
            log.debug("[{}] \u8df3\u8fc7\u7a7a\u7684\u538b\u7f29\u6570\u636e\u5305", (Object)ctx.channel().remoteAddress());
            return;
        }
        if (compressed.readableBytes() >= 1 && ((firstByte = compressed.getByte(0)) & 0xFF) == 255) {
            ByteBuf batchPayload;
            compressed = batchPayload = compressed.slice(1, compressed.readableBytes() - 1);
        }
        try {
            PacketCompressionAlgorithm algorithm;
            if (compressed.readableBytes() > 0x300000) {
                throw new IllegalStateException("Compressed data too large: " + compressed.readableBytes());
            }
            ByteBuf decompressed = null;
            if (compressed.readableBytes() == 0) {
                decompressed = ctx.alloc().directBuffer(0);
                algorithm = PacketCompressionAlgorithm.NONE;
            } else {
                byte header = compressed.getByte(0);
                int headerValue = header & 0xFF;
                ByteBuf dataToProcess = headerValue == 0 ? compressed.slice(1, compressed.readableBytes() - 1) : compressed.slice();
                try {
                    decompressed = this.decompressWithZlibRaw(ctx, dataToProcess);
                    algorithm = PacketCompressionAlgorithm.ZLIB;
                }
                catch (Exception e) {
                    try {
                        decompressed = this.decompressWithZlib(ctx, dataToProcess);
                        algorithm = PacketCompressionAlgorithm.ZLIB;
                    }
                    catch (Exception ex) {
                        decompressed = this.decompressWithNone(ctx, compressed);
                        algorithm = PacketCompressionAlgorithm.NONE;
                    }
                }
            }
            msg.setAlgorithm(algorithm);
            msg.setUncompressed(decompressed);
            this.onDecompressed(ctx, msg);
            out.add(msg.retain());
        }
        catch (Exception e) {
            log.error("[{}] NetEase\u89e3\u7801\u5931\u8d25\uff0c\u6570\u636e\u5927\u5c0f: {} bytes", (Object)ctx.channel().remoteAddress(), (Object)compressed.readableBytes(), (Object)e);
            throw e;
        }
    }

    private ByteBuf decompressWithNone(ChannelHandlerContext ctx, ByteBuf compressedData) {
        ByteBuf result = ctx.alloc().directBuffer(compressedData.readableBytes());
        compressedData.markReaderIndex();
        result.writeBytes(compressedData);
        compressedData.resetReaderIndex();
        return result;
    }

    private ByteBuf decompressWithZlib(ChannelHandlerContext ctx, ByteBuf compressedData) throws DataFormatException {
        return this._decompressWithZlib(ctx, compressedData, false);
    }

    private ByteBuf decompressWithZlibRaw(ChannelHandlerContext ctx, ByteBuf compressedData) throws DataFormatException {
        return this._decompressWithZlib(ctx, compressedData, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf _decompressWithZlib(ChannelHandlerContext ctx, ByteBuf compressedData, boolean isRaw) throws DataFormatException {
        Inflater inflater = isRaw ? new Inflater(true) : new Inflater();
        try {
            byte[] compressedBytes = new byte[compressedData.readableBytes()];
            compressedData.markReaderIndex();
            compressedData.readBytes(compressedBytes);
            compressedData.resetReaderIndex();
            inflater.setInput(compressedBytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                if (count == 0) {
                    if (!inflater.needsInput()) break;
                    throw new DataFormatException("ZLIB: \u6570\u636e\u4e0d\u5b8c\u6574");
                }
                outputStream.write(buffer, 0, count);
                if (outputStream.size() <= 0x300000) continue;
                throw new DataFormatException("ZLIB: \u89e3\u538b\u540e\u6570\u636e\u8fc7\u5927");
            }
            byte[] decompressedBytes = outputStream.toByteArray();
            ByteBuf result = ctx.alloc().directBuffer(decompressedBytes.length);
            result.writeBytes(decompressedBytes);
            ByteBuf byteBuf = result;
            return byteBuf;
        }
        finally {
            inflater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf compressWithZlibRaw(ChannelHandlerContext ctx, ByteBuf data) throws Exception {
        if (data.readableBytes() == 0) {
            log.debug("[{}] \u8f93\u5165\u6570\u636e\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u7684\u538b\u7f29\u7ed3\u679c", (Object)ctx.channel().remoteAddress());
            return ctx.alloc().directBuffer(0);
        }
        Deflater deflater = new Deflater(-1, true);
        try {
            byte[] input = new byte[data.readableBytes()];
            data.markReaderIndex();
            data.readBytes(input);
            data.resetReaderIndex();
            deflater.setInput(input);
            deflater.finish();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                if (count <= 0) continue;
                outputStream.write(buffer, 0, count);
            }
            byte[] compressedBytes = outputStream.toByteArray();
            if (compressedBytes.length == 0 && input.length > 0) {
                ByteBuf result = ctx.alloc().directBuffer(input.length);
                result.writeBytes(input);
                ByteBuf byteBuf = result;
                return byteBuf;
            }
            ByteBuf result = ctx.alloc().directBuffer(compressedBytes.length);
            result.writeBytes(compressedBytes);
            ByteBuf byteBuf = result;
            return byteBuf;
        }
        finally {
            deflater.end();
        }
    }

    @Override
    protected byte getCompressionHeader0(CompressionAlgorithm algorithm) {
        CompressionType type;
        if (algorithm instanceof CompressionType && (type = (CompressionType)algorithm).getHeaderId() >= 0) {
            return type.getHeaderId();
        }
        return super.getCompressionHeader0(algorithm);
    }

    @Override
    protected CompressionAlgorithm getCompressionAlgorithm0(byte header) {
        CompressionType type = CompressionType.fromHeaderId(header);
        if (type != null) {
            return type;
        }
        return super.getCompressionAlgorithm0(header);
    }
}

