/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.peer;

import dev.waterdog.waterdogpe.network.connection.codec.compression.CompressionType;
import dev.waterdog.waterdogpe.network.connection.codec.compression.ProxiedCompressionCodec;
import dev.waterdog.waterdogpe.network.connection.codec.packet.BedrockPacketCodec;
import dev.waterdog.waterdogpe.network.connection.peer.BedrockServerSession;
import dev.waterdog.waterdogpe.network.netease.NetEaseUtils;
import dev.waterdog.waterdogpe.network.netease.codec.NetEaseCompressionCodec;
import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.netty.handler.codec.raknet.common.RakSessionCodec;
import org.cloudburstmc.protocol.bedrock.BedrockPeer;
import org.cloudburstmc.protocol.bedrock.BedrockSession;
import org.cloudburstmc.protocol.bedrock.BedrockSessionFactory;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.v428.Bedrock_v428;
import org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionStrategy;
import org.cloudburstmc.protocol.bedrock.netty.codec.encryption.BedrockEncryptionDecoder;
import org.cloudburstmc.protocol.bedrock.netty.codec.encryption.BedrockEncryptionEncoder;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.util.EncryptionUtils;

public class ProxiedBedrockPeer
extends BedrockPeer {
    private static final Logger log = LogManager.getLogger(ProxiedBedrockPeer.class);
    private BedrockServerSession firstSession;
    private CompressionStrategy compressionStrategy;
    private ProtocolVersion version = ProtocolVersion.oldest();

    public ProxiedBedrockPeer(Channel channel, BedrockSessionFactory factory) {
        super(channel, factory);
    }

    private void onBedrockBatch(BedrockBatchWrapper batch) {
        try {
            if (this.firstSession == null) {
                for (BedrockPacketWrapper wrapper : batch.getPackets()) {
                    try {
                        BedrockServerSession session = this.getSession(wrapper.getTargetSubClientId());
                        session.onPacket(wrapper);
                    }
                    catch (Exception e) {
                        log.error("[{}] \u5206\u53d1\u6570\u636e\u5305\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u5b50\u5ba2\u6237\u7aefID: {}", (Object)this.getSocketAddress(), (Object)wrapper.getTargetSubClientId(), (Object)e);
                    }
                }
            } else {
                this.firstSession.onBedrockBatch(batch);
            }
        }
        catch (Exception e) {
            log.error("[{}] \u5904\u7406BedrockBatch\u65f6\u53d1\u751f\u5f02\u5e38", (Object)this.getSocketAddress(), (Object)e);
            throw e;
        }
    }

    private BedrockServerSession getSession(int sessionId) {
        BedrockServerSession session = (BedrockServerSession)this.sessions.computeIfAbsent(sessionId, this::onSessionCreated);
        if (this.firstSession == null) {
            this.firstSession = session;
        }
        return session;
    }

    @Override
    protected BedrockServerSession onSessionCreated(int sessionId) {
        BedrockServerSession session = (BedrockServerSession)super.onSessionCreated(sessionId);
        if (this.firstSession == null) {
            this.firstSession = session;
        }
        return session;
    }

    @Override
    protected void removeSession(BedrockSession session) {
        if (this.firstSession == session) {
            this.firstSession = null;
        }
        super.removeSession(session);
    }

    @Override
    protected void onTick() {
        if (!this.closed.get() && !this.packetQueue.isEmpty()) {
            BedrockPacketWrapper packet;
            BedrockBatchWrapper batch = BedrockBatchWrapper.newInstance();
            while ((packet = (BedrockPacketWrapper)this.packetQueue.poll()) != null) {
                batch.getPackets().add(packet);
            }
            this.channel.writeAndFlush(batch);
        }
    }

    public void sendPacket(BedrockBatchWrapper wrapper) {
        if (this.channel.eventLoop().inEventLoop()) {
            this.sendPacket0(wrapper);
        } else {
            this.channel.eventLoop().execute(() -> this.sendPacket0(wrapper));
        }
    }

    private void sendPacket0(BedrockBatchWrapper wrapper) {
        if (!(wrapper.getAlgorithm() instanceof PacketCompressionAlgorithm)) {
            wrapper.setCompressed(null);
        } else if (this.version.isBefore(ProtocolVersion.MINECRAFT_PE_1_20_60) && (this.compressionStrategy == null || !Objects.equals(wrapper.getAlgorithm(), this.compressionStrategy.getDefaultCompression().getAlgorithm()))) {
            wrapper.setCompressed(null);
        }
        this.onTick();
        this.getChannel().writeAndFlush(wrapper);
    }

    @Override
    public void sendPacketImmediately(int senderClientId, int targetClientId, BedrockPacket packet) {
        this.sendPacket(senderClientId, targetClientId, packet);
        if (this.channel.eventLoop().inEventLoop()) {
            this.onTick();
        } else {
            this.channel.eventLoop().execute(this::onTick);
        }
    }

    @Override
    public BedrockCodec getCodec() {
        return this.getChannel().pipeline().get(BedrockPacketCodec.class).getCodec();
    }

    @Override
    public BedrockCodecHelper getCodecHelper() {
        return this.getChannel().pipeline().get(BedrockPacketCodec.class).getHelper();
    }

    @Override
    @Deprecated
    public void setCodec(BedrockCodec codec) {
        Objects.requireNonNull(codec, "codec");
        this.getChannel().pipeline().get(BedrockPacketCodec.class).setCodecHelper(codec, codec.createHelper());
        this.version = ProtocolVersion.get(codec.getProtocolVersion());
    }

    public void setProtocol(ProtocolVersion protocol) {
        Objects.requireNonNull(protocol, "protocol");
        this.version = protocol;
        this.getChannel().pipeline().get(BedrockPacketCodec.class).setCodecHelper(protocol.getCodec(), protocol.getCodec().createHelper());
    }

    @Override
    public void enableEncryption(SecretKey secretKey) {
        Objects.requireNonNull(secretKey, "secretKey");
        if (!secretKey.getAlgorithm().equals("AES")) {
            throw new IllegalArgumentException("Invalid key algorithm");
        }
        if (this.channel.pipeline().get(BedrockEncryptionEncoder.class) != null || this.channel.pipeline().get(BedrockEncryptionDecoder.class) != null) {
            throw new IllegalStateException("Encryption is already enabled");
        }
        int protocolVersion = this.getCodec().getProtocolVersion();
        boolean useCtr = protocolVersion >= Bedrock_v428.CODEC.getProtocolVersion();
        this.channel.pipeline().addAfter("frame-id-codec", "bedrock-encryption-encoder", new BedrockEncryptionEncoder(secretKey, EncryptionUtils.createCipher(useCtr, true, secretKey)));
        this.channel.pipeline().addAfter("frame-id-codec", "bedrock-encryption-decoder", new BedrockEncryptionDecoder(secretKey, EncryptionUtils.createCipher(useCtr, false, secretKey)));
        log.info("[ProxiedBedrockPeer] Encryption enabled for {}", (Object)this.getSocketAddress());
    }

    public void setCompression(CompressionAlgorithm algorithm) {
        CompressionType type;
        if (algorithm instanceof CompressionType && (type = (CompressionType)algorithm).getBedrockAlgorithm() != null) {
            CompressionStrategy currentStrategy;
            this.setCompression(type.getBedrockAlgorithm());
            boolean isNetease = NetEaseUtils.isNetEaseClient(this.getRakVersion(), this.getCodec().getProtocolVersion());
            if (isNetease && (currentStrategy = this.compressionStrategy) != null) {
                this.channel.pipeline().replace("compression-codec", "compression-codec", (ChannelHandler)new NetEaseCompressionCodec(currentStrategy, true));
                log.debug("[{}] \u66ff\u6362\u6807\u51c6\u538b\u7f29\u7f16\u89e3\u7801\u5668\u4e3aNetease\u7248\u672c\uff0c\u5f3a\u5236\u542f\u7528\u524d\u7f00", (Object)this.getSocketAddress());
            }
            return;
        }
        throw new IllegalArgumentException("Unsupported compression algorithm: " + algorithm);
    }

    @Override
    public void setCompression(CompressionStrategy strategy) {
        boolean needsPrefix = this.getCodec().getProtocolVersion() >= ProtocolVersion.MINECRAFT_PE_1_20_60.getProtocol();
        ChannelHandler handler = this.channel.pipeline().get("compression-codec");
        if (handler == null) {
            this.channel.pipeline().addAfter("frame-id-codec", "compression-codec", new ProxiedCompressionCodec(strategy, needsPrefix));
        } else {
            this.channel.pipeline().replace("compression-codec", "compression-codec", (ChannelHandler)new ProxiedCompressionCodec(strategy, needsPrefix));
        }
        this.compressionStrategy = strategy;
    }

    public void disconnect(String reason) {
        this.sessions.values().forEach(session -> session.disconnect(reason));
        this.channel.eventLoop().schedule(() -> this.channel.close(), 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int getRakVersion() {
        return this.channel.config().getOption(RakChannelOption.RAK_PROTOCOL_VERSION);
    }

    @Override
    public CompressionStrategy getCompressionStrategy() {
        return this.compressionStrategy;
    }

    public boolean isSplitScreen() {
        return this.sessions.size() > 1;
    }

    public long getPing() {
        Channel channel = this.channel;
        if (channel instanceof RakChannel) {
            RakChannel rakChannel = (RakChannel)channel;
            return rakChannel.rakPipeline().get(RakSessionCodec.class).getPing();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (msg instanceof BedrockBatchWrapper) {
                this.onBedrockBatch((BedrockBatchWrapper)msg);
            } else {
                super.channelRead(ctx, ReferenceCountUtil.retain(msg));
            }
        }
        catch (Exception e) {
            log.error("{} Exception caught in bedrock connection", (Object)ctx.channel().remoteAddress(), (Object)e);
            this.disconnect("Internal error");
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("{} Exception caught in bedrock connection", (Object)ctx.channel().remoteAddress(), (Object)cause);
        this.disconnect("Internal error");
    }
}

