/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.peer;

import dev.waterdog.waterdogpe.network.connection.ProxiedConnection;
import dev.waterdog.waterdogpe.network.connection.codec.batch.BatchFlags;
import dev.waterdog.waterdogpe.network.connection.codec.server.PacketQueueHandler;
import dev.waterdog.waterdogpe.network.connection.peer.ProxiedBedrockPeer;
import dev.waterdog.waterdogpe.network.protocol.Signals;
import dev.waterdog.waterdogpe.network.protocol.handler.ProxyBatchBridge;
import dev.waterdog.waterdogpe.network.protocol.handler.ProxyPacketHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.protocol.bedrock.BedrockSession;
import org.cloudburstmc.protocol.bedrock.PacketDirection;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.DisconnectPacket;
import org.cloudburstmc.protocol.common.PacketSignal;

public class BedrockServerSession
extends BedrockSession
implements ProxiedConnection {
    private static final Logger log = LogManager.getLogger(BedrockServerSession.class);

    public BedrockServerSession(ProxiedBedrockPeer peer, int subClientId) {
        super(peer, subClientId);
    }

    @Override
    protected void onPacket(BedrockPacketWrapper packet) {
        BedrockPacketHandler bedrockPacketHandler = this.packetHandler;
        if (bedrockPacketHandler instanceof ProxyBatchBridge) {
            ProxyBatchBridge bridge = (ProxyBatchBridge)bedrockPacketHandler;
            PacketSignal signal = bridge.handlePacket(packet.getPacket());
            if (signal != Signals.CANCEL) {
                bridge.sendProxiedBatch(BedrockBatchWrapper.create(0, packet.getPacket()));
            }
        } else if (this.packetHandler != null) {
            this.getPacketHandler().handlePacket(packet.getPacket());
        } else {
            log.warn("[{}] Unhandled packet {}", (Object)this.getSocketAddress(), (Object)packet);
        }
    }

    protected void onBedrockBatch(BedrockBatchWrapper batch) {
        BedrockPacketHandler bedrockPacketHandler = this.packetHandler;
        if (bedrockPacketHandler instanceof ProxyBatchBridge) {
            ProxyBatchBridge bridge = (ProxyBatchBridge)bedrockPacketHandler;
            bridge.onBedrockBatch(this, batch);
        } else {
            batch.getPackets().forEach(this::onPacket);
        }
    }

    @Override
    public void sendPacket(BedrockBatchWrapper batch) {
        this.getPeer().sendPacket(batch);
    }

    @Override
    public void sendPacketImmediately(BedrockPacket packet) {
        BedrockBatchWrapper batch = BedrockBatchWrapper.create(this.subClientId, packet);
        batch.setFlag(BatchFlags.SKIP_QUEUE);
        this.getPeer().sendPacket(batch);
    }

    @Override
    public void disconnect(String reason, boolean hideReason) {
        this.checkForClosed();
        DisconnectPacket packet = new DisconnectPacket();
        if (reason == null || hideReason) {
            packet.setMessageSkipped(true);
            reason = "disconnect.disconnected";
        }
        packet.setKickMessage(reason);
        this.sendPacketImmediately(packet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTransferQueueActive(boolean enable) {
        if (!this.getPeer().isConnected()) {
            throw new IllegalStateException("Connection was already closed");
        }
        ChannelPipeline pipeline = this.getPeer().getChannel().pipeline();
        if (enable) {
            if (pipeline.get("packet-queue-handler") != null) throw new IllegalStateException("Transfer queue for " + this.getSocketAddress() + " is already active");
            pipeline.addBefore("bedrock-peer", "packet-queue-handler", new PacketQueueHandler(this));
            return;
        } else {
            if (pipeline.get("packet-queue-handler") == null) return;
            pipeline.remove("packet-queue-handler");
        }
    }

    @Override
    public void setPacketHandler(BedrockPacketHandler handler) {
        if (handler instanceof ProxyPacketHandler) {
            ProxyPacketHandler packetHandler = (ProxyPacketHandler)handler;
            BedrockPacketHandler bedrockPacketHandler = this.packetHandler;
            if (bedrockPacketHandler instanceof ProxyBatchBridge) {
                ProxyBatchBridge bridge = (ProxyBatchBridge)bedrockPacketHandler;
                bridge.setHandler(packetHandler);
            } else {
                super.setPacketHandler(new ProxyBatchBridge(this.getPeer().getCodec(), this.getPeer().getCodecHelper(), packetHandler));
            }
        } else {
            super.setPacketHandler(handler);
        }
    }

    @Override
    public BedrockPacketHandler getPacketHandler() {
        BedrockPacketHandler bedrockPacketHandler = this.packetHandler;
        if (bedrockPacketHandler instanceof ProxyBatchBridge) {
            ProxyBatchBridge bridge = (ProxyBatchBridge)bedrockPacketHandler;
            return bridge.getHandler();
        }
        return this.packetHandler;
    }

    public void addDisconnectListener(Consumer<String> listener) {
        this.getPeer().getChannel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> listener.accept(this.getDisconnectReason())));
    }

    @Override
    public int getSubClientId() {
        return this.subClientId;
    }

    @Override
    public ProxiedBedrockPeer getPeer() {
        return (ProxiedBedrockPeer)super.getPeer();
    }

    @Override
    public long getPing() {
        return this.getPeer().getPing();
    }

    @Override
    public PacketDirection getPacketDirection() {
        return PacketDirection.CLIENT_BOUND;
    }
}

