/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.handler;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.network.connection.handler.IReconnectHandler;
import dev.waterdog.waterdogpe.network.connection.handler.ReconnectReason;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import java.util.Collection;
import java.util.Iterator;

public class RoundRobinReconnectHandler
implements IReconnectHandler {
    private RoundRobinIterator<String> iterator;

    @Override
    public ServerInfo getFallbackServer(ProxiedPlayer player, ServerInfo oldServer, ReconnectReason reason, String kickMessage) {
        ProxyServer proxy = ProxyServer.getInstance();
        if (proxy.getConfiguration().getPriorities().size() < 2) {
            throw new IllegalStateException("RoundRobinReconnectHandler required at least two priority servers set");
        }
        if (this.iterator == null) {
            this.iterator = new RoundRobinIterator<String>(proxy.getConfiguration().getPriorities());
        }
        while (this.iterator.hasNext()) {
            String server = this.iterator.next();
            if (oldServer != null && server.equals(oldServer.getServerName())) continue;
            return proxy.getServerInfo(server);
        }
        return null;
    }

    private static class RoundRobinIterator<E>
    implements Iterator<E> {
        private final Collection<E> collection;
        private Iterator<E> iterator;

        public RoundRobinIterator(Collection<E> collection) {
            this.collection = collection;
            this.iterator = this.collection.iterator();
        }

        @Override
        public synchronized boolean hasNext() {
            return !this.collection.isEmpty();
        }

        @Override
        public synchronized E next() {
            if (!this.iterator.hasNext()) {
                this.iterator = this.collection.iterator();
            }
            return this.iterator.next();
        }
    }
}

