/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.server;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.network.NetworkMetrics;
import dev.waterdog.waterdogpe.security.SecurityManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;

public class ServerDatagramHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "server-datagram-handler";
    private final SecurityManager manager;

    public ServerDatagramHandler(SecurityManager securityManager) {
        this.manager = securityManager;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        DatagramPacket packet;
        if (msg instanceof DatagramPacket && this.manager.isAddressBlocked(((InetSocketAddress)(packet = (DatagramPacket)msg).sender()).getAddress())) {
            NetworkMetrics metrics = ProxyServer.getInstance().getNetworkMetrics();
            if (metrics != null) {
                metrics.droppedBytes(((ByteBuf)packet.content()).readableBytes());
            }
            packet.release();
            return;
        }
        ctx.fireChannelRead(msg);
    }
}

