/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.server;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.event.defaults.ProxyPingEvent;
import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import dev.waterdog.waterdogpe.utils.config.proxy.ProxyConfig;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.netty.channel.raknet.RakPing;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;

public class RakNetPingHandler
extends SimpleChannelInboundHandler<RakPing> {
    private static final Logger log = LogManager.getLogger(RakNetPingHandler.class);
    public static final String NAME = "rak-ping-handler";
    private final ProxyServer proxy;

    public RakNetPingHandler(ProxyServer proxy) {
        this.proxy = proxy;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, RakPing rakPing) throws Exception {
        ProxyConfig config = this.proxy.getConfiguration();
        ProxyPingEvent event = new ProxyPingEvent(config.getMotd(), "WaterdogPE Proxy", "Survival", "MCPE", ProtocolVersion.latest().getMinecraftVersion(), this.proxy.getPlayerManager().getPlayers().values(), config.getMaxPlayerCount(), rakPing.getSender());
        this.proxy.getEventManager().callEvent(event);
        long guid = ctx.channel().config().getOption(RakChannelOption.RAK_GUID);
        StringJoiner joiner = new StringJoiner(";");
        joiner.add("MCPE");
        joiner.add(event.getMotd().replace(";", "\\;"));
        joiner.add(Integer.toString(ProtocolVersion.latest().getProtocol()));
        joiner.add(event.getVersion());
        joiner.add(Integer.toString(event.getPlayerCount()));
        joiner.add(Integer.toString(event.getMaximumPlayerCount()));
        joiner.add(Long.toUnsignedString(guid));
        joiner.add(event.getSubMotd());
        joiner.add(event.getGameType());
        joiner.add("1");
        ctx.writeAndFlush(rakPing.reply(guid, Unpooled.wrappedBuffer(joiner.toString().getBytes(StandardCharsets.UTF_8))));
    }
}

