/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.server;

import dev.waterdog.waterdogpe.network.NetworkMetrics;
import dev.waterdog.waterdogpe.network.connection.codec.batch.BatchFlags;
import dev.waterdog.waterdogpe.network.connection.peer.BedrockServerSession;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;

public class PacketQueueHandler
extends ChannelDuplexHandler {
    private static final Logger log = LogManager.getLogger(PacketQueueHandler.class);
    public static final String NAME = "packet-queue-handler";
    private static final int MAX_BATCHES = 256;
    private static final int MAX_PACKETS = 8000;
    private final BedrockServerSession session;
    private int packetCounter = 0;
    private final Queue<BedrockBatchWrapper> queue = PlatformDependent.newMpscQueue(256);
    private volatile boolean finished;

    public PacketQueueHandler(BedrockServerSession session) {
        this.session = session;
    }

    private void finish(ChannelHandlerContext ctx, boolean send) {
        BedrockBatchWrapper batch;
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (ctx.pipeline().get(NAME) == this) {
            ctx.pipeline().remove(this);
        }
        while ((batch = this.queue.poll()) != null) {
            if (send) {
                ctx.write(batch);
                continue;
            }
            batch.release();
        }
        if (send) {
            ctx.flush();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.finish(ctx, false);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.finish(ctx, ctx.channel().isActive());
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        BedrockBatchWrapper batch;
        if (this.finished || !(msg instanceof BedrockBatchWrapper) || (batch = (BedrockBatchWrapper)msg).hasFlag(BatchFlags.SKIP_QUEUE)) {
            ctx.write(msg, promise);
            return;
        }
        if (this.queue.offer(batch) && this.packetCounter < 8000) {
            this.packetCounter += batch.getPackets().size();
        } else {
            log.warn("[{}] has reached maximum transfer queue capacity: batches={} packets={}", (Object)this.session.getSocketAddress(), (Object)this.queue.size(), (Object)this.packetCounter);
            this.finish(ctx, false);
            this.session.disconnect("Transfer queue got too large");
            NetworkMetrics metrics = ctx.channel().attr(NetworkMetrics.ATTRIBUTE).get();
            if (metrics != null) {
                metrics.packetQueueTooLarge();
            }
        }
    }
}

