/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.packet;

import dev.waterdog.waterdogpe.network.NetworkMetrics;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.protocol.bedrock.PacketDirection;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.compat.BedrockCompat;
import org.cloudburstmc.protocol.bedrock.data.EncodingSettings;
import org.cloudburstmc.protocol.bedrock.data.PacketRecipient;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.UnknownPacket;

public abstract class BedrockPacketCodec
extends MessageToMessageCodec<BedrockBatchWrapper, BedrockBatchWrapper> {
    private static final Logger log = LogManager.getLogger(BedrockPacketCodec.class);
    public static final String NAME = "bedrock-packet-codec";
    private BedrockCodec codec = BedrockCompat.CODEC;
    private BedrockCodecHelper helper = this.codec.createHelper();
    private boolean alwaysDecode;
    private PacketRecipient inboundRecipient;

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        PacketDirection direction = ctx.channel().attr(PacketDirection.ATTRIBUTE).get();
        if (direction == PacketDirection.CLIENT_BOUND) {
            this.alwaysDecode = true;
        }
        this.inboundRecipient = direction.getInbound();
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, BedrockBatchWrapper msg, List<Object> out) throws Exception {
        if (msg.isModified() || msg.getUncompressed() == null) {
            int passedThrough = 0;
            int encodedPackets = 0;
            for (BedrockPacketWrapper packet : msg.getPackets()) {
                if (this.encode(ctx, packet)) {
                    ++passedThrough;
                    continue;
                }
                ++encodedPackets;
            }
            this.recordMetrics(ctx, passedThrough, encodedPackets);
        }
        out.add(msg.retain());
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, BedrockBatchWrapper msg, List<Object> out) throws Exception {
        for (BedrockPacketWrapper packet : msg.getPackets()) {
            this.decode(ctx, packet);
        }
        out.add(msg.retain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean encode(ChannelHandlerContext ctx, BedrockPacketWrapper wrapper) throws Exception {
        if (wrapper.getPacketBuffer() != null) {
            return true;
        }
        ByteBuf buf = ctx.alloc().buffer(128);
        try {
            BedrockPacket packet = wrapper.getPacket();
            wrapper.setPacketId(this.getPacketId(packet));
            this.encodeHeader(buf, wrapper);
            this.codec.tryEncode(this.helper, buf, packet);
            wrapper.setPacketBuffer(buf.retain());
        }
        catch (Throwable t) {
            log.error("Error encoding packet {}", (Object)wrapper.getPacket(), (Object)t);
        }
        finally {
            buf.release();
        }
        return false;
    }

    protected final void decode(ChannelHandlerContext ctx, BedrockPacketWrapper wrapper) throws Exception {
        if (wrapper.getPacketBuffer() == null) {
            throw new IllegalStateException("Packet has no encoded buffer");
        }
        ByteBuf msg = wrapper.getPacketBuffer().retainedSlice();
        try {
            int index = msg.readerIndex();
            this.decodeHeader(msg, wrapper);
            wrapper.setHeaderLength(msg.readerIndex() - index);
            if (this.alwaysDecode) {
                wrapper.setPacket(this.codec.tryDecode(this.helper, msg, wrapper.getPacketId(), this.inboundRecipient));
            }
        }
        catch (Throwable t) {
            log.error("Failed to decode packet", t);
            throw t;
        }
        finally {
            msg.release();
        }
    }

    public abstract void encodeHeader(ByteBuf var1, BedrockPacketWrapper var2);

    public abstract void decodeHeader(ByteBuf var1, BedrockPacketWrapper var2);

    private void recordMetrics(ChannelHandlerContext ctx, int passedThought, int encodedPackets) {
        NetworkMetrics metrics = ctx.channel().attr(NetworkMetrics.ATTRIBUTE).get();
        if (metrics == null) {
            return;
        }
        PacketDirection direction = ctx.channel().attr(PacketDirection.ATTRIBUTE).get();
        if (passedThought > 0) {
            metrics.passedThroughPackets(passedThought, direction);
        }
        if (encodedPackets > 0) {
            metrics.encodedPackets(passedThought, direction);
        }
    }

    public final int getPacketId(BedrockPacket packet) {
        if (packet instanceof UnknownPacket) {
            return ((UnknownPacket)packet).getPacketId();
        }
        return this.codec.getPacketDefinition(packet.getClass()).getId();
    }

    public final BedrockPacketCodec setCodecHelper(BedrockCodec codec, BedrockCodecHelper helper) {
        this.codec = Objects.requireNonNull(codec, "Codec cannot be null");
        this.helper = Objects.requireNonNull(helper, "Helper can not be null");
        switch (this.inboundRecipient) {
            case CLIENT: {
                this.helper.setEncodingSettings(EncodingSettings.UNLIMITED);
                break;
            }
            case SERVER: {
                this.helper.setEncodingSettings(EncodingSettings.SERVER);
            }
        }
        return this;
    }

    public BedrockCodec getCodec() {
        return this.codec;
    }

    public BedrockCodecHelper getHelper() {
        return this.helper;
    }

    public BedrockPacketCodec setAlwaysDecode(boolean alwaysDecode) {
        this.alwaysDecode = alwaysDecode;
        return this;
    }
}

