/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.initializer;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.network.connection.codec.batch.BedrockBatchDecoder;
import dev.waterdog.waterdogpe.network.connection.codec.batch.BedrockBatchEncoder;
import dev.waterdog.waterdogpe.network.connection.codec.batch.FrameIdCodec;
import dev.waterdog.waterdogpe.network.connection.codec.compression.CompressionType;
import dev.waterdog.waterdogpe.network.connection.codec.compression.ProxiedCompressionCodec;
import dev.waterdog.waterdogpe.network.connection.codec.packet.BedrockPacketCodec;
import dev.waterdog.waterdogpe.network.connection.codec.packet.BedrockPacketCodec_v1;
import dev.waterdog.waterdogpe.network.connection.codec.packet.BedrockPacketCodec_v2;
import dev.waterdog.waterdogpe.network.connection.codec.packet.BedrockPacketCodec_v3;
import dev.waterdog.waterdogpe.network.connection.peer.ProxiedBedrockPeer;
import dev.waterdog.waterdogpe.network.netease.NetEaseUtils;
import dev.waterdog.waterdogpe.network.netease.codec.NetEaseCompressionCodec;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.netty.channel.raknet.packet.RakMessage;
import org.cloudburstmc.protocol.bedrock.BedrockPeer;
import org.cloudburstmc.protocol.bedrock.BedrockSession;
import org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionStrategy;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.NoopCompression;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.SimpleCompressionStrategy;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.SnappyCompression;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.ZlibCompression;
import org.cloudburstmc.protocol.common.util.Zlib;

public abstract class ProxiedSessionInitializer<T extends BedrockSession>
extends ChannelInitializer<Channel> {
    private static final Logger log = LogManager.getLogger(ProxiedSessionInitializer.class);
    public static final FrameIdCodec<RakMessage> RAKNET_FRAME_CODEC = FrameIdCodec.RAK_CODEC.apply(254);
    public static final BedrockBatchDecoder BATCH_DECODER = new BedrockBatchDecoder();
    public static final CompressionStrategy ZLIB_RAW_STRATEGY = new SimpleCompressionStrategy(new ZlibCompression(Zlib.RAW));
    public static final CompressionStrategy ZLIB_STRATEGY = new SimpleCompressionStrategy(new ZlibCompression(Zlib.DEFAULT));
    public static final CompressionStrategy SNAPPY_STRATEGY = new SimpleCompressionStrategy(new SnappyCompression());
    public static final CompressionStrategy NOOP_STRATEGY = new SimpleCompressionStrategy(new NoopCompression());
    protected final ProxyServer proxy;

    @Override
    protected void initChannel(Channel channel) {
        int rakVersion = channel.config().getOption(RakChannelOption.RAK_PROTOCOL_VERSION);
        boolean isNetEaseClient = NetEaseUtils.isNetEaseClient(rakVersion);
        CompressionType configuredCompression = this.proxy.getConfiguration().getCompression();
        CompressionStrategy strategy = ProxiedSessionInitializer.getCompressionStrategy(configuredCompression, rakVersion, true);
        ProxiedCompressionCodec compressionCodec = isNetEaseClient ? new NetEaseCompressionCodec(strategy, true) : new ProxiedCompressionCodec(strategy, false);
        log.debug("[{}] \u9009\u62e9\u7684\u538b\u7f29\u7b56\u7565: {}, \u7f16\u89e3\u7801\u5668: {}", (Object)channel.remoteAddress(), (Object)strategy.getClass().getSimpleName(), (Object)compressionCodec.getClass().getSimpleName());
        channel.pipeline().addLast("frame-id-codec", RAKNET_FRAME_CODEC).addLast("compression-codec", (ChannelHandler)compressionCodec).addLast("bedrock-batch-decoder", (ChannelHandler)BATCH_DECODER).addLast("bedrock-batch-encoder", (ChannelHandler)new BedrockBatchEncoder()).addLast("bedrock-packet-codec", (ChannelHandler)ProxiedSessionInitializer.getPacketCodec(rakVersion)).addLast("bedrock-peer", (ChannelHandler)new ProxiedBedrockPeer(channel, this::createSession));
    }

    protected final T createSession(BedrockPeer peer, int subClientId) {
        T session = this.createSession0(peer, subClientId);
        this.initSession(session);
        return session;
    }

    protected abstract T createSession0(BedrockPeer var1, int var2);

    protected abstract void initSession(T var1);

    public static BedrockPacketCodec getPacketCodec(int rakVersion) {
        boolean isNetEaseClient = NetEaseUtils.isNetEaseClient(rakVersion);
        if (isNetEaseClient) {
            rakVersion = 9;
        }
        return switch (rakVersion) {
            case 7 -> new BedrockPacketCodec_v1();
            case 8 -> new BedrockPacketCodec_v2();
            case 9, 10, 11 -> new BedrockPacketCodec_v3();
            default -> throw new UnsupportedOperationException("Unsupported RakNet protocol version: " + rakVersion);
        };
    }

    public static CompressionStrategy getCompressionStrategy(CompressionAlgorithm algorithm, int rakVersion, boolean initial) {
        return switch (rakVersion) {
            case 7, 8, 9 -> ZLIB_STRATEGY;
            case 10 -> ZLIB_RAW_STRATEGY;
            case 11 -> {
                if (initial) {
                    yield NOOP_STRATEGY;
                }
                yield ProxiedSessionInitializer.getCompressionStrategy(algorithm);
            }
            default -> throw new UnsupportedOperationException("Unsupported RakNet protocol version: " + rakVersion);
        };
    }

    private static CompressionStrategy getCompressionStrategy(CompressionAlgorithm algorithm) {
        if (algorithm == PacketCompressionAlgorithm.ZLIB) {
            return ZLIB_RAW_STRATEGY;
        }
        if (algorithm == PacketCompressionAlgorithm.SNAPPY) {
            return SNAPPY_STRATEGY;
        }
        if (algorithm == PacketCompressionAlgorithm.NONE) {
            return NOOP_STRATEGY;
        }
        throw new UnsupportedOperationException("Unsupported compression algorithm: " + algorithm + " Maybe you want to use CompressionStrategy instead?");
    }

    public ProxiedSessionInitializer(ProxyServer proxy) {
        this.proxy = proxy;
    }
}

