/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.initializer;

import dev.waterdog.waterdogpe.network.NetworkMetrics;
import dev.waterdog.waterdogpe.network.connection.client.BedrockClientConnection;
import dev.waterdog.waterdogpe.network.connection.client.ClientConnection;
import dev.waterdog.waterdogpe.network.connection.codec.batch.BedrockBatchEncoder;
import dev.waterdog.waterdogpe.network.connection.codec.client.ClientEventHandler;
import dev.waterdog.waterdogpe.network.connection.codec.client.ClientPacketQueue;
import dev.waterdog.waterdogpe.network.connection.codec.compression.CompressionType;
import dev.waterdog.waterdogpe.network.connection.codec.compression.ProxiedCompressionCodec;
import dev.waterdog.waterdogpe.network.connection.codec.initializer.ProxiedSessionInitializer;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.Promise;
import org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelMetrics;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.protocol.bedrock.PacketDirection;

public class ProxiedClientSessionInitializer
extends ChannelInitializer<Channel> {
    private final ProxiedPlayer player;
    private final ServerInfo serverInfo;
    private final Promise<ClientConnection> promise;

    public ProxiedClientSessionInitializer(ProxiedPlayer player, ServerInfo serverInfo, Promise<ClientConnection> promise) {
        this.player = player;
        this.serverInfo = serverInfo;
        this.promise = promise;
    }

    @Override
    protected void initChannel(Channel channel) throws Exception {
        int rakVersion = this.player.getProtocol().getRaknetVersion();
        CompressionType compression = this.player.getProxy().getConfiguration().getCompression();
        channel.attr(PacketDirection.ATTRIBUTE).set(PacketDirection.SERVER_BOUND);
        NetworkMetrics metrics = this.player.getProxy().getNetworkMetrics();
        if (metrics != null) {
            channel.attr(NetworkMetrics.ATTRIBUTE).set(metrics);
        }
        if (metrics instanceof RakChannelMetrics) {
            RakChannelMetrics rakMetrics = (RakChannelMetrics)((Object)metrics);
            if (channel instanceof RakChannel) {
                channel.config().setOption(RakChannelOption.RAK_METRICS, rakMetrics);
            }
        }
        channel.pipeline().addLast("frame-id-codec", ProxiedSessionInitializer.RAKNET_FRAME_CODEC).addLast("compression-codec", (ChannelHandler)new ProxiedCompressionCodec(ProxiedSessionInitializer.getCompressionStrategy(compression, rakVersion, true), false)).addLast("bedrock-batch-decoder", (ChannelHandler)ProxiedSessionInitializer.BATCH_DECODER).addLast("bedrock-batch-encoder", (ChannelHandler)new BedrockBatchEncoder()).addLast("bedrock-packet-codec", (ChannelHandler)ProxiedSessionInitializer.getPacketCodec(rakVersion)).addLast("client-packet-queue", (ChannelHandler)new ClientPacketQueue());
        ClientConnection connection = this.createConnection(channel);
        if (connection instanceof ChannelHandler) {
            ChannelHandler handler = (ChannelHandler)((Object)connection);
            channel.pipeline().addLast("client-connection", handler);
        }
        if (connection.getPacketDirection() != PacketDirection.SERVER_BOUND) {
            throw new IllegalStateException("Client connection must have a server-bound packet direction");
        }
        channel.pipeline().addLast("client-event-handler", (ChannelHandler)new ClientEventHandler(this.player, connection)).addLast(new ChannelActiveHandler(connection, this.promise));
    }

    protected ClientConnection createConnection(Channel channel) {
        return new BedrockClientConnection(this.player, this.serverInfo, channel);
    }

    private static class ChannelActiveHandler
    extends ChannelInboundHandlerAdapter {
        private final ClientConnection connection;
        private final Promise<ClientConnection> promise;

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.promise.trySuccess(this.connection);
            ctx.channel().pipeline().remove(this);
        }

        public ChannelActiveHandler(ClientConnection connection, Promise<ClientConnection> promise) {
            this.connection = connection;
            this.promise = promise;
        }
    }
}

