/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.compression;

import dev.waterdog.waterdogpe.network.NetworkMetrics;
import dev.waterdog.waterdogpe.network.connection.codec.compression.CompressionType;
import io.netty.channel.ChannelHandlerContext;
import org.cloudburstmc.protocol.bedrock.PacketDirection;
import org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionCodec;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionStrategy;

public class ProxiedCompressionCodec
extends CompressionCodec {
    public ProxiedCompressionCodec(CompressionStrategy strategy, boolean prefixed) {
        super(strategy, prefixed);
    }

    @Override
    protected void onPassedThrough(ChannelHandlerContext ctx, BedrockBatchWrapper msg) {
        NetworkMetrics metrics = ctx.channel().attr(NetworkMetrics.ATTRIBUTE).get();
        PacketDirection direction = ctx.channel().attr(PacketDirection.ATTRIBUTE).get();
        if (metrics != null && direction != null) {
            metrics.passedThroughBytes(msg.getCompressed().readableBytes(), direction);
        }
    }

    @Override
    protected void onCompressed(ChannelHandlerContext ctx, BedrockBatchWrapper msg) {
        NetworkMetrics metrics = ctx.channel().attr(NetworkMetrics.ATTRIBUTE).get();
        PacketDirection direction = ctx.channel().attr(PacketDirection.ATTRIBUTE).get();
        if (metrics != null && direction != null) {
            metrics.compressedBytes(msg.getCompressed().readableBytes(), direction);
        }
    }

    @Override
    protected void onDecompressed(ChannelHandlerContext ctx, BedrockBatchWrapper msg) {
        NetworkMetrics metrics = ctx.channel().attr(NetworkMetrics.ATTRIBUTE).get();
        PacketDirection direction = ctx.channel().attr(PacketDirection.ATTRIBUTE).get();
        if (metrics != null && direction != null) {
            metrics.decompressedBytes(msg.getUncompressed().readableBytes(), direction);
        }
    }

    @Override
    protected byte getCompressionHeader0(CompressionAlgorithm algorithm) {
        CompressionType type;
        if (algorithm instanceof CompressionType && (type = (CompressionType)algorithm).getBedrockAlgorithm() == null) {
            return type.getHeaderId();
        }
        return super.getCompressionHeader0(algorithm);
    }

    @Override
    protected CompressionAlgorithm getCompressionAlgorithm0(byte header) {
        return CompressionType.fromHeaderId(header);
    }
}

