/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.compression;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.data.PacketCompressionAlgorithm;
import org.cloudburstmc.protocol.common.util.Preconditions;

public class CompressionType
implements Comparable<CompressionType>,
CompressionAlgorithm {
    private static final Map<String, CompressionType> types = new ConcurrentSkipListMap<String, CompressionType>(String.CASE_INSENSITIVE_ORDER);
    private static final Byte2ObjectMap<CompressionType> headerIds = new Byte2ObjectOpenHashMap<CompressionType>();
    public static final CompressionType NONE = CompressionType.builder().identifier("none").bedrockAlgorithm(PacketCompressionAlgorithm.NONE).register();
    public static final CompressionType ZLIB = CompressionType.builder().identifier("zlib").bedrockAlgorithm(PacketCompressionAlgorithm.ZLIB).register();
    public static final CompressionType SNAPPY = CompressionType.builder().identifier("snappy").bedrockAlgorithm(PacketCompressionAlgorithm.SNAPPY).register();
    private final String identifier;
    private final PacketCompressionAlgorithm bedrockAlgorithm;
    private final byte headerId;

    private CompressionType(String identifier, PacketCompressionAlgorithm bedrockAlgorithm, byte headerId) {
        this.identifier = identifier;
        this.bedrockAlgorithm = bedrockAlgorithm;
        this.headerId = headerId;
    }

    public static CompressionType fromString(String string) {
        Preconditions.checkNotNull(string, "CompressionAlgorithm name can not be null");
        Preconditions.checkArgument(!string.isEmpty(), "CompressionAlgorithm name can not be empty");
        return types.get(string);
    }

    public static CompressionType fromHeaderId(byte headerId) {
        return (CompressionType)headerIds.get(headerId);
    }

    public static CompressionType fromBedrockCompression(PacketCompressionAlgorithm algorithm) {
        return switch (algorithm) {
            case PacketCompressionAlgorithm.NONE -> NONE;
            case PacketCompressionAlgorithm.ZLIB -> ZLIB;
            case PacketCompressionAlgorithm.SNAPPY -> SNAPPY;
            default -> throw new UnsupportedOperationException("Unsupported compression " + algorithm);
        };
    }

    @Override
    public int compareTo(CompressionType o) {
        return this.identifier.compareTo(o.identifier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public PacketCompressionAlgorithm getBedrockAlgorithm() {
        return this.bedrockAlgorithm;
    }

    public byte getHeaderId() {
        return this.headerId;
    }

    public String toString() {
        return "CompressionType(identifier=" + this.getIdentifier() + ", bedrockAlgorithm=" + this.getBedrockAlgorithm() + ", headerId=" + this.getHeaderId() + ")";
    }

    public static class Builder {
        private String identifier;
        private PacketCompressionAlgorithm bedrockAlgorithm;
        private byte headerId = (byte)-1;

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder bedrockAlgorithm(PacketCompressionAlgorithm bedrockAlgorithm) {
            this.bedrockAlgorithm = bedrockAlgorithm;
            return this;
        }

        public Builder headerId(byte headerId) {
            this.headerId = headerId;
            return this;
        }

        public CompressionType register() {
            Preconditions.checkNotNull(this.identifier, "identifier");
            Preconditions.checkArgument(!types.containsKey(this.identifier), "CompressionAlgorithm " + this.identifier + " already exists");
            if (this.bedrockAlgorithm == null && this.headerId < 0) {
                throw new IllegalArgumentException("Compression header must be set");
            }
            CompressionType type = new CompressionType(this.identifier, this.bedrockAlgorithm, this.headerId);
            types.put(this.identifier, type);
            headerIds.put(this.headerId, type);
            return type;
        }
    }
}

