/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;

public class ClientPacketQueue
extends ChannelDuplexHandler {
    public static final String NAME = "client-packet-queue";
    private final Queue<BedrockPacketWrapper> packetQueue = PlatformDependent.newMpscQueue();
    private ScheduledFuture<?> tickFuture;

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.tickFuture = ctx.channel().eventLoop().scheduleAtFixedRate(() -> this.onTick(ctx), 50L, 50L, TimeUnit.MILLISECONDS);
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.tickFuture.cancel(false);
        this.tickFuture = null;
        super.channelInactive(ctx);
    }

    private void onTick(ChannelHandlerContext ctx) {
        if (!this.packetQueue.isEmpty()) {
            BedrockPacketWrapper packet;
            BedrockBatchWrapper batch = BedrockBatchWrapper.newInstance();
            while ((packet = this.packetQueue.poll()) != null) {
                batch.getPackets().add(packet);
            }
            ctx.writeAndFlush(batch);
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof BedrockPacket) {
            BedrockPacket packet = (BedrockPacket)msg;
            this.packetQueue.add(BedrockPacketWrapper.create(0, 0, 0, ReferenceCountUtil.retain(packet), null));
        } else if (msg instanceof BedrockPacketWrapper) {
            BedrockPacketWrapper packet = (BedrockPacketWrapper)msg;
            this.packetQueue.add(ReferenceCountUtil.retain(packet));
        } else if (msg instanceof BedrockBatchWrapper) {
            this.onTick(ctx);
            ctx.write(msg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }
}

