/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.codec.batch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.common.util.VarInts;

public class BedrockBatchEncoder
extends MessageToMessageEncoder<BedrockBatchWrapper> {
    public static final String NAME = "bedrock-batch-encoder";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, BedrockBatchWrapper msg, List<Object> out) {
        if (!(msg.isModified() || msg.getCompressed() == null && msg.getUncompressed() == null)) {
            out.add(msg.retain());
            return;
        }
        CompositeByteBuf buf = ctx.alloc().compositeDirectBuffer(msg.getPackets().size() * 2);
        try {
            for (BedrockPacketWrapper packet : msg.getPackets()) {
                ByteBuf message = packet.getPacketBuffer();
                if (message == null) {
                    throw new IllegalArgumentException("BedrockPacket is not encoded");
                }
                ByteBuf header = ctx.alloc().ioBuffer(5);
                VarInts.writeUnsignedInt(header, message.readableBytes());
                buf.addComponent(true, header);
                buf.addComponent(true, message.retainedSlice());
            }
            msg.setUncompressed(buf.retain());
        }
        finally {
            buf.release();
        }
        out.add(msg.retain());
    }
}

