/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network.connection.client;

import dev.waterdog.waterdogpe.network.connection.client.ClientConnection;
import dev.waterdog.waterdogpe.network.connection.codec.compression.CompressionType;
import dev.waterdog.waterdogpe.network.connection.codec.compression.ProxiedCompressionCodec;
import dev.waterdog.waterdogpe.network.connection.codec.initializer.ProxiedSessionInitializer;
import dev.waterdog.waterdogpe.network.connection.codec.packet.BedrockPacketCodec;
import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import dev.waterdog.waterdogpe.network.protocol.handler.ProxyBatchBridge;
import dev.waterdog.waterdogpe.network.protocol.handler.ProxyPacketHandler;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudburstmc.netty.channel.raknet.RakChannel;
import org.cloudburstmc.netty.handler.codec.raknet.common.RakSessionCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.v428.Bedrock_v428;
import org.cloudburstmc.protocol.bedrock.data.CompressionAlgorithm;
import org.cloudburstmc.protocol.bedrock.netty.BedrockBatchWrapper;
import org.cloudburstmc.protocol.bedrock.netty.BedrockPacketWrapper;
import org.cloudburstmc.protocol.bedrock.netty.codec.compression.CompressionStrategy;
import org.cloudburstmc.protocol.bedrock.netty.codec.encryption.BedrockEncryptionDecoder;
import org.cloudburstmc.protocol.bedrock.netty.codec.encryption.BedrockEncryptionEncoder;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.util.EncryptionUtils;

public class BedrockClientConnection
extends SimpleChannelInboundHandler<BedrockBatchWrapper>
implements ClientConnection {
    private static final Logger log = LogManager.getLogger(BedrockClientConnection.class);
    private final ProxiedPlayer player;
    private final ServerInfo serverInfo;
    private final Channel channel;
    private final List<Runnable> disconnectListeners = new ObjectArrayList<Runnable>();
    private BedrockPacketHandler packetHandler;
    private CompressionStrategy compressionStrategy;

    public BedrockClientConnection(ProxiedPlayer player, ServerInfo serverInfo, Channel channel) {
        this.player = player;
        this.serverInfo = serverInfo;
        this.channel = channel;
        if (player.getProtocol().isBefore(ProtocolVersion.MINECRAFT_PE_1_19_30)) {
            this.compressionStrategy = player.getConnection().getPeer().getRakVersion() < 10 ? ProxiedSessionInitializer.ZLIB_STRATEGY : ProxiedSessionInitializer.ZLIB_RAW_STRATEGY;
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.disconnectListeners.forEach(Runnable::run);
        super.channelInactive(ctx);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, BedrockBatchWrapper batch) {
        block10: {
            try {
                BedrockPacketHandler bedrockPacketHandler = this.packetHandler;
                if (bedrockPacketHandler instanceof ProxyBatchBridge) {
                    ProxyBatchBridge bridge = (ProxyBatchBridge)bedrockPacketHandler;
                    bridge.onBedrockBatch(this, batch);
                } else if (this.packetHandler != null) {
                    for (BedrockPacketWrapper packet : batch.getPackets()) {
                        try {
                            this.packetHandler.handlePacket(packet.getPacket());
                        }
                        catch (Exception e) {
                            log.warn("\u6570\u636e\u5305\u5904\u7406\u9519\u8bef: {} - \u5305\u7c7b\u578b: {}", (Object)e.getMessage(), (Object)packet.getPacket().getClass().getSimpleName());
                            if (!log.isDebugEnabled()) continue;
                            log.debug("\u6570\u636e\u5305\u5904\u7406\u8be6\u7ec6\u9519\u8bef\u4fe1\u606f:", (Throwable)e);
                        }
                    }
                } else {
                    log.warn("Received unhandled packets for " + this.getSocketAddress());
                }
            }
            catch (Exception e) {
                String errorMessage = e.getMessage();
                if (errorMessage != null && !errorMessage.contains("commands=[]")) {
                    log.error("\u6279\u5904\u7406\u5305\u5904\u7406\u53d1\u751f\u4e25\u91cd\u9519\u8bef: {}", (Object)e.getMessage());
                }
                if (!log.isDebugEnabled()) break block10;
                log.debug("\u6279\u5904\u7406\u5305\u9519\u8bef\u8be6\u7ec6\u4fe1\u606f:", (Throwable)e);
            }
        }
    }

    @Override
    public void sendPacket(BedrockBatchWrapper wrapper) {
        if (this.player.getProtocol().isBefore(ProtocolVersion.MINECRAFT_PE_1_20_60) && !Objects.equals(wrapper.getAlgorithm(), this.compressionStrategy.getDefaultCompression().getAlgorithm())) {
            wrapper.setCompressed(null);
        }
        this.channel.writeAndFlush(wrapper);
    }

    @Override
    public void sendPacket(BedrockPacket packet) {
        this.channel.writeAndFlush(packet);
    }

    @Override
    public void sendPacketImmediately(BedrockPacket packet) {
        this.channel.writeAndFlush(BedrockBatchWrapper.create(this.getSubClientId(), packet));
    }

    @Override
    public void setCompression(CompressionAlgorithm algorithm) {
        CompressionType type;
        CompressionStrategy strategy = algorithm instanceof CompressionType && (type = (CompressionType)algorithm).getBedrockAlgorithm() != null ? ProxiedSessionInitializer.getCompressionStrategy(type.getBedrockAlgorithm(), this.player.getProtocol().getRaknetVersion(), false) : ProxiedSessionInitializer.getCompressionStrategy(algorithm, this.player.getProtocol().getRaknetVersion(), false);
        this.setCompressionStrategy(strategy);
    }

    @Override
    public void setCompressionStrategy(CompressionStrategy strategy) {
        boolean needsPrefix = this.player.getProtocol().isAfterOrEqual(ProtocolVersion.MINECRAFT_PE_1_20_60);
        ChannelHandler handler = this.channel.pipeline().get("compression-codec");
        if (handler == null) {
            this.channel.pipeline().addAfter("frame-id-codec", "compression-codec", new ProxiedCompressionCodec(strategy, needsPrefix));
        } else {
            this.channel.pipeline().replace("compression-codec", "compression-codec", (ChannelHandler)new ProxiedCompressionCodec(strategy, needsPrefix));
        }
        this.compressionStrategy = strategy;
    }

    @Override
    public void enableEncryption(SecretKey secretKey) {
        if (!secretKey.getAlgorithm().equals("AES")) {
            throw new IllegalArgumentException("Invalid key algorithm");
        }
        if (this.channel.pipeline().get(BedrockEncryptionEncoder.class) != null || this.channel.pipeline().get(BedrockEncryptionDecoder.class) != null) {
            throw new IllegalStateException("Encryption is already enabled");
        }
        int protocolVersion = this.getCodec().getProtocolVersion();
        boolean useCtr = protocolVersion >= Bedrock_v428.CODEC.getProtocolVersion();
        this.channel.pipeline().addAfter("frame-id-codec", "bedrock-encryption-encoder", new BedrockEncryptionEncoder(secretKey, EncryptionUtils.createCipher(useCtr, true, secretKey)));
        this.channel.pipeline().addAfter("frame-id-codec", "bedrock-encryption-decoder", new BedrockEncryptionDecoder(secretKey, EncryptionUtils.createCipher(useCtr, false, secretKey)));
        log.info("[BedrockClientConnection] Encryption enabled for {}", (Object)this.getSocketAddress());
    }

    @Override
    public void setCodecHelper(BedrockCodec codec, BedrockCodecHelper helper) {
        Objects.requireNonNull(codec, "codec");
        Objects.requireNonNull(helper, "helper");
        this.channel.pipeline().get(BedrockPacketCodec.class).setCodecHelper(codec, helper);
    }

    private BedrockCodec getCodec() {
        return this.channel.pipeline().get(BedrockPacketCodec.class).getCodec();
    }

    private BedrockCodecHelper getCodecHelper() {
        return this.channel.pipeline().get(BedrockPacketCodec.class).getHelper();
    }

    @Override
    public void disconnect() {
        this.channel.disconnect();
    }

    @Override
    public long getPing() {
        Channel channel = this.channel;
        if (channel instanceof RakChannel) {
            RakChannel rakChannel = (RakChannel)channel;
            return rakChannel.rakPipeline().get(RakSessionCodec.class).getPing();
        }
        return 0L;
    }

    @Override
    public ProxiedPlayer getPlayer() {
        return this.player;
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public boolean isConnected() {
        return this.channel.isOpen();
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public BedrockPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    @Override
    public void setPacketHandler(BedrockPacketHandler handler) {
        if (handler instanceof ProxyPacketHandler) {
            ProxyPacketHandler packetHandler = (ProxyPacketHandler)handler;
            BedrockPacketHandler bedrockPacketHandler = this.getPacketHandler();
            if (bedrockPacketHandler instanceof ProxyBatchBridge) {
                ProxyBatchBridge bridge = (ProxyBatchBridge)bedrockPacketHandler;
                bridge.setHandler(packetHandler);
            } else {
                this.packetHandler = new ProxyBatchBridge(this.getCodec(), this.getCodecHelper(), packetHandler);
            }
        } else {
            this.packetHandler = handler;
        }
    }

    @Override
    public void addDisconnectListener(Runnable listener) {
        this.disconnectListeners.add(listener);
    }

    public String toString() {
        return "BedrockClientConnection(player=" + this.player.getName() + ", serverInfo=" + this.serverInfo + ", address=" + this.channel.remoteAddress() + ")";
    }
}

