/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.network;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiFunction;

public class EventLoops {
    private static final ChannelType CHANNEL_TYPE;

    public static ChannelType getChannelType() {
        return CHANNEL_TYPE;
    }

    static {
        boolean disableNative = System.getProperties().contains("disableNativeEventLoop");
        CHANNEL_TYPE = !disableNative && Epoll.isAvailable() ? ChannelType.EPOLL : (!disableNative && KQueue.isAvailable() ? ChannelType.KQUEUE : ChannelType.NIO);
    }

    public static enum ChannelType {
        EPOLL(EpollDatagramChannel.class, EpollSocketChannel.class, EpollServerSocketChannel.class, EpollEventLoopGroup::new, Epoll.isAvailable()),
        KQUEUE(KQueueDatagramChannel.class, KQueueSocketChannel.class, KQueueServerSocketChannel.class, KQueueEventLoopGroup::new, KQueue.isAvailable()),
        NIO(NioDatagramChannel.class, NioSocketChannel.class, NioServerSocketChannel.class, NioEventLoopGroup::new, true);

        private final Class<? extends DatagramChannel> datagramChannel;
        private final Class<? extends SocketChannel> socketChannel;
        private final Class<? extends ServerSocketChannel> serverSocketChannel;
        private final BiFunction<Integer, ThreadFactory, EventLoopGroup> eventLoopGroupFactory;
        private final boolean available;

        public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
            return this.eventLoopGroupFactory.apply(threads, factory);
        }

        public Class<? extends DatagramChannel> getDatagramChannel() {
            return this.datagramChannel;
        }

        public Class<? extends SocketChannel> getSocketChannel() {
            return this.socketChannel;
        }

        public Class<? extends ServerSocketChannel> getServerSocketChannel() {
            return this.serverSocketChannel;
        }

        public BiFunction<Integer, ThreadFactory, EventLoopGroup> getEventLoopGroupFactory() {
            return this.eventLoopGroupFactory;
        }

        public boolean isAvailable() {
            return this.available;
        }

        private ChannelType(Class<? extends DatagramChannel> datagramChannel, Class<? extends SocketChannel> socketChannel, Class<? extends ServerSocketChannel> serverSocketChannel, BiFunction<Integer, ThreadFactory, EventLoopGroup> eventLoopGroupFactory, boolean available) {
            this.datagramChannel = datagramChannel;
            this.socketChannel = socketChannel;
            this.serverSocketChannel = serverSocketChannel;
            this.eventLoopGroupFactory = eventLoopGroupFactory;
            this.available = available;
        }
    }
}

