/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.logger;

import java.util.regex.Pattern;
import org.fusesource.jansi.Ansi;

public enum Color {
    BLACK('0', 0, Ansi.Color.BLACK),
    DARK_BLUE('1', 1, Ansi.Color.BLUE),
    DARK_GREEN('2', 2, Ansi.Color.GREEN),
    DARK_AQUA('3', 3, Ansi.Color.CYAN),
    DARK_RED('4', 4, Ansi.Color.RED),
    DARK_PURPLE('5', 5, Ansi.Color.MAGENTA),
    GOLD('6', 6, Ansi.Color.YELLOW),
    GRAY('7', 7, Ansi.Color.WHITE),
    DARK_GRAY('8', 8, Ansi.Color.BLACK, true),
    BLUE('9', 9, Ansi.Color.BLUE, true),
    GREEN('a', 10, Ansi.Color.GREEN, true),
    AQUA('b', 11, Ansi.Color.CYAN, true),
    RED('c', 12, Ansi.Color.RED, true),
    LIGHT_PURPLE('d', 13, Ansi.Color.MAGENTA, true),
    YELLOW('e', 14, Ansi.Color.YELLOW, true),
    WHITE('f', 15, Ansi.Color.WHITE, true),
    BOLD('l', 17, null, false, Ansi.Attribute.UNDERLINE_DOUBLE),
    STRIKETHROUGH('m', 18, null, false, Ansi.Attribute.STRIKETHROUGH_ON),
    UNDERLINE('n', 19, null, false, Ansi.Attribute.UNDERLINE),
    ITALIC('o', 20, null, false, Ansi.Attribute.ITALIC),
    RESET('r', 21, null, false, Ansi.Attribute.RESET);

    public static final char ESCAPE = '\u00a7';
    private static final Pattern CLEAN_PATTERN;
    private final char code;
    private final int intCode;
    private final Ansi.Color color;
    private final boolean bold;
    private final Ansi.Attribute attribute;
    private final String toString;

    private Color(char code, int intCode, Ansi.Color color) {
        this(code, intCode, color, false, null);
    }

    private Color(char code, int intCode, Ansi.Color color, boolean bold) {
        this(code, intCode, color, bold, null);
    }

    private Color(char code, int intCode, Ansi.Color color, boolean bold, Ansi.Attribute attribute) {
        this.code = code;
        this.intCode = intCode;
        this.color = color;
        this.bold = bold;
        this.attribute = attribute;
        this.toString = new String(new char[]{'\u00a7', code});
    }

    public static String clean(String input) {
        if (input == null) {
            return null;
        }
        return CLEAN_PATTERN.matcher(input).replaceAll("");
    }

    public String toString() {
        return this.toString;
    }

    public Ansi getAnsi() {
        Ansi ansi;
        Ansi ansi2 = ansi = this.attribute == null ? Ansi.ansi().a(Ansi.Attribute.RESET) : Ansi.ansi().a(this.attribute);
        if (this.color != null) {
            ansi = ansi.fg(this.color);
        }
        return this.bold ? ansi.bold() : ansi;
    }

    static {
        CLEAN_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    }
}

