/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.event;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.event.Event;
import dev.waterdog.waterdogpe.event.EventHandler;
import dev.waterdog.waterdogpe.event.EventPriority;
import dev.waterdog.waterdogpe.utils.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class EventManager {
    private final ProxyServer proxy;
    private final ExecutorService threadedExecutor;
    private final Object2ObjectOpenHashMap<Class<? extends Event>, EventHandler> handlerMap = new Object2ObjectOpenHashMap();

    public EventManager(ProxyServer proxy) {
        this.proxy = proxy;
        ThreadFactoryBuilder builder = ThreadFactoryBuilder.builder().format("WaterdogEvents Executor - #%d").build();
        int idleThreads = this.proxy.getConfiguration().getIdleThreads();
        this.threadedExecutor = new ThreadPoolExecutor(idleThreads, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), builder);
    }

    public <T extends Event> void subscribe(Class<T> event, Consumer<T> handler) {
        this.subscribe(event, handler, EventPriority.NORMAL);
    }

    public <T extends Event> void subscribe(Class<T> event, Consumer<T> handler, EventPriority priority) {
        EventHandler eventHandler = this.handlerMap.computeIfAbsent(event, e -> new EventHandler(event, this));
        eventHandler.subscribe(handler, priority);
    }

    public <T extends Event> CompletableFuture<T> callEvent(T event) {
        EventHandler eventHandler = this.handlerMap.computeIfAbsent(event.getClass(), e -> new EventHandler(event.getClass(), this));
        return eventHandler.handle(event);
    }

    public ExecutorService getThreadedExecutor() {
        return this.threadedExecutor;
    }
}

