/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.event;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.event.Event;
import dev.waterdog.waterdogpe.event.EventManager;
import dev.waterdog.waterdogpe.event.EventPriority;
import dev.waterdog.waterdogpe.utils.exceptions.EventException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class EventHandler {
    private final EventManager eventManager;
    private final Class<? extends Event> eventClass;
    private final Map<EventPriority, ArrayList<Consumer<Event>>> priority2handlers = new EnumMap<EventPriority, ArrayList<Consumer<Event>>>(EventPriority.class);

    public EventHandler(Class<? extends Event> eventClass, EventManager eventManager) {
        this.eventClass = eventClass;
        this.eventManager = eventManager;
    }

    public <T extends Event> CompletableFuture<T> handle(T event) {
        if (!this.eventClass.isInstance(event)) {
            throw new EventException("Tried to handle invalid event type!");
        }
        if (!event.isAsync()) {
            return this.handleSync(event);
        }
        CompletableFuture future = new CompletableFuture();
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            for (EventPriority priority : EventPriority.values()) {
                this.handlePriority(priority, event);
            }
            return event;
        }, this.eventManager.getThreadedExecutor()).thenAccept(futureEvent -> futureEvent.completeFuture(future))).whenComplete((ignore, error) -> {
            if (error != null && !future.isDone()) {
                future.completeExceptionally((Throwable)error);
                ProxyServer.getInstance().getLogger().error("Exception was thrown in event handler", (Throwable)error);
            }
        });
        return future;
    }

    private <T extends Event> CompletableFuture<T> handleSync(T event) {
        if (!((Event)event).isCompletable()) {
            for (EventPriority priority : EventPriority.values()) {
                this.handlePriority(priority, (Event)event);
            }
            return null;
        }
        try {
            for (EventPriority priority : EventPriority.values()) {
                this.handlePriority(priority, (Event)event);
            }
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        if (((Event)event).getCompletableFutures().isEmpty()) {
            return CompletableFuture.completedFuture(event);
        }
        CompletableFuture future = new CompletableFuture();
        ((Event)event).completeFuture(future);
        return future;
    }

    private void handlePriority(EventPriority priority, Event event) {
        ArrayList<Consumer<Event>> handlerList = this.priority2handlers.get((Object)priority);
        if (handlerList != null) {
            for (Consumer<Event> eventHandler : handlerList) {
                eventHandler.accept(event);
            }
        }
    }

    public void subscribe(Consumer<Event> handler, EventPriority priority) {
        List handlerList = this.priority2handlers.computeIfAbsent(priority, priority1 -> new ArrayList());
        if (!handlerList.contains(handler)) {
            handlerList.add(handler);
        }
    }
}

