/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.event;

import dev.waterdog.waterdogpe.event.AsyncEvent;
import dev.waterdog.waterdogpe.event.CancellableEvent;
import dev.waterdog.waterdogpe.event.CompletableEvent;
import dev.waterdog.waterdogpe.utils.exceptions.EventException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.cloudburstmc.protocol.common.util.Preconditions;

public abstract class Event {
    private final List<CompletableFuture<Void>> completableFuture = this.isCompletable() ? Collections.synchronizedList(new ObjectArrayList()) : null;
    private boolean cancelled = false;

    public boolean isCancelled() {
        if (!(this instanceof CancellableEvent)) {
            throw new EventException("Event is not Cancellable");
        }
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        if (!(this instanceof CancellableEvent)) {
            throw new EventException("Event is not Cancellable");
        }
        this.cancelled = cancelled;
    }

    public void setCancelled() {
        if (!(this instanceof CancellableEvent)) {
            throw new EventException("Event is not Cancellable");
        }
        this.cancelled = true;
    }

    public void addCompletableFuture(CompletableFuture<Void> future) {
        Preconditions.checkArgument(this.isCompletable(), "Can not add complete future to event which is not @CompletableEvent or @AsyncEvent!");
        this.completableFuture.add(future);
    }

    protected List<CompletableFuture<Void>> getCompletableFutures() {
        Preconditions.checkArgument(this.isCompletable(), "Event is not @CompletableEvent or @AsyncEvent!");
        return this.completableFuture;
    }

    protected <T extends Event> void completeFuture(CompletableFuture<T> future) {
        Preconditions.checkArgument(this.isCompletable(), "Event is not @CompletableEvent or @AsyncEvent!");
        if (this.completableFuture.isEmpty()) {
            future.complete(this);
            return;
        }
        CompletableFuture.allOf(this.completableFuture.toArray(new CompletableFuture[0])).whenComplete((ignore, error) -> {
            if (error == null) {
                future.complete(this);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
    }

    public boolean isAsync() {
        return this.getClass().isAnnotationPresent(AsyncEvent.class);
    }

    public boolean isCompletable() {
        return this.getClass().isAnnotationPresent(CompletableEvent.class) || this.isAsync();
    }
}

