/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.console;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.command.ConsoleCommandSender;
import dev.waterdog.waterdogpe.console.CommandCompleter;
import dev.waterdog.waterdogpe.console.ConsoleThread;
import net.minecrell.terminalconsole.SimpleTerminalConsole;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;

public class TerminalConsole
extends SimpleTerminalConsole {
    private final ProxyServer proxy;
    private final ConsoleThread consoleThread;

    public TerminalConsole(ProxyServer proxy) {
        this.proxy = proxy;
        this.consoleThread = new ConsoleThread(this);
    }

    @Override
    protected void runCommand(String command) {
        ConsoleCommandSender console = this.proxy.getConsoleSender();
        this.proxy.getScheduler().scheduleTask(() -> this.proxy.dispatchCommand(console, command), false);
    }

    @Override
    protected LineReader buildReader(LineReaderBuilder builder) {
        builder.completer(new CommandCompleter(this.proxy));
        builder.appName("WaterdogPE");
        builder.option(LineReader.Option.HISTORY_BEEP, false);
        builder.option(LineReader.Option.HISTORY_IGNORE_DUPS, true);
        builder.option(LineReader.Option.HISTORY_IGNORE_SPACE, true);
        return super.buildReader(builder);
    }

    @Override
    protected void shutdown() {
        ProxyServer.getInstance().shutdown();
    }

    @Override
    protected boolean isRunning() {
        return this.proxy.isRunning();
    }

    public ConsoleThread getConsoleThread() {
        return this.consoleThread;
    }
}

