/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.console;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.command.CommandMap;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class CommandCompleter
implements Completer {
    private final ProxyServer proxy;

    public CommandCompleter(ProxyServer proxy) {
        this.proxy = proxy;
    }

    @Override
    public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> candidates) {
        if (parsedLine.wordIndex() == 0) {
            if (parsedLine.word().isEmpty()) {
                this.addOptions(command -> candidates.add(new Candidate((String)command)));
                return;
            }
            ArrayList commands = new ArrayList();
            this.addOptions(commands::add);
            for (String command2 : commands) {
                if (!command2.startsWith(parsedLine.word())) continue;
                candidates.add(new Candidate(command2));
            }
            return;
        }
        if (parsedLine.wordIndex() > 1 && !parsedLine.word().isEmpty()) {
            String world = parsedLine.word();
            for (ProxiedPlayer player : this.proxy.getPlayers().values()) {
                if (!player.getName().toLowerCase().startsWith(world)) continue;
                candidates.add(new Candidate(player.getName()));
            }
        }
    }

    private void addOptions(Consumer<String> commandConsumer) {
        CommandMap commandMap = this.proxy.getCommandMap();
        for (String command : commandMap.getCommands().keySet()) {
            commandConsumer.accept(command);
        }
    }
}

