/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.command.defaults;

import dev.waterdog.waterdogpe.command.Command;
import dev.waterdog.waterdogpe.command.CommandSender;
import dev.waterdog.waterdogpe.command.CommandSettings;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import dev.waterdog.waterdogpe.utils.types.TextContainer;
import org.cloudburstmc.protocol.bedrock.data.command.CommandOverloadData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParam;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParamData;

public class ServerCommand
extends Command {
    public ServerCommand() {
        super("server", CommandSettings.builder().setDescription("waterdog.command.server.description").setUsageMessage("waterdog.command.server.usage").setPermission("waterdog.command.server.permission").build());
    }

    @Override
    public boolean onExecute(CommandSender sender, String alias, String[] args) {
        ProxiedPlayer player;
        if (args.length < 1 || !sender.isPlayer() && args.length < 2) {
            return false;
        }
        ServerInfo server = sender.getProxy().getServerInfo(args[0]);
        if (server == null) {
            sender.sendMessage("\u00a7cServer not found!");
            return true;
        }
        if (sender.isPlayer() && args.length < 2) {
            player = (ProxiedPlayer)sender;
        } else {
            if (!sender.hasPermission("waterdog.command.server.permission.other")) {
                sender.sendMessage(new TextContainer("\u00a7cYou don't have the permission to move other players."));
                return false;
            }
            player = sender.getProxy().getPlayer(args[1]);
            if (player == null) {
                sender.sendMessage("\u00a7cPlayer not found!");
                return true;
            }
            sender.sendMessage(new TextContainer("\u00a7aPlayer {%0} was sent to {%1} server!", player.getName(), server.getServerName()));
        }
        player.connect(server);
        return true;
    }

    @Override
    protected CommandOverloadData[] buildCommandOverloads() {
        CommandParamData server = new CommandParamData();
        server.setName("server");
        server.setOptional(false);
        server.setType(CommandParam.TEXT);
        CommandParamData player = new CommandParamData();
        player.setName("player");
        player.setOptional(true);
        player.setType(CommandParam.TARGET);
        return new CommandOverloadData[]{new CommandOverloadData(false, new CommandParamData[]{server, player})};
    }
}

