/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.command.defaults;

import dev.waterdog.waterdogpe.command.Command;
import dev.waterdog.waterdogpe.command.CommandSender;
import dev.waterdog.waterdogpe.command.CommandSettings;
import dev.waterdog.waterdogpe.network.serverinfo.ServerInfo;
import dev.waterdog.waterdogpe.player.ProxiedPlayer;
import dev.waterdog.waterdogpe.utils.types.TranslationContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringJoiner;

public class ListCommand
extends Command {
    public ListCommand() {
        super("wdlist", CommandSettings.builder().setDescription("waterdog.command.list.description").setUsageMessage("waterdog.command.list.usage").setPermission("waterdog.command.list.permission").build());
    }

    @Override
    public boolean onExecute(CommandSender sender, String alias, String[] args) {
        if (args.length >= 1) {
            ServerInfo serverInfo = sender.getProxy().getServerInfo(args[0]);
            sender.sendMessage(serverInfo == null ? "\u00a7cServer not found!" : this.buildServerList(serverInfo));
            return true;
        }
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>(sender.getProxy().getServers());
        servers.sort(Comparator.comparing(ServerInfo::getServerName));
        StringBuilder builder = new StringBuilder("\u00a7aShowing all servers:\n");
        for (ServerInfo serverInfo : servers) {
            builder.append(this.buildServerList(serverInfo)).append("\n\u00a7r");
        }
        builder.append("\u00a7rTotal online players: ").append(sender.getProxy().getPlayers().size());
        sender.sendMessage(builder.toString());
        return true;
    }

    private String buildServerList(ServerInfo serverInfo) {
        StringJoiner joiner = new StringJoiner(",");
        for (ProxiedPlayer player : serverInfo.getPlayers()) {
            joiner.add(player.getName());
        }
        return new TranslationContainer("waterdog.command.list.format", serverInfo.getServerName(), String.valueOf(serverInfo.getPlayers().size()), joiner.toString()).getTranslated();
    }
}

