/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.command.defaults;

import dev.waterdog.waterdogpe.command.Command;
import dev.waterdog.waterdogpe.command.CommandMap;
import dev.waterdog.waterdogpe.command.CommandSender;
import dev.waterdog.waterdogpe.command.CommandSettings;
import dev.waterdog.waterdogpe.utils.types.TranslationContainer;
import java.util.TreeMap;

public class HelpCommand
extends Command {
    public HelpCommand() {
        super("wdhelp", CommandSettings.builder().setDescription("waterdog.command.help.description").setUsageMessage("waterdog.command.help.usage").setPermission("waterdog.command.help.permission").build());
    }

    @Override
    public boolean onExecute(CommandSender sender, String alias, String[] args) {
        int pageNumber = 1;
        int pageHeight = 8;
        if (sender.isPlayer()) {
            if (args.length >= 1) {
                try {
                    pageNumber = Integer.parseInt(args[0]);
                    if (pageNumber < 1) {
                        pageNumber = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            pageHeight = Integer.MAX_VALUE;
        }
        CommandMap commandMap = sender.getProxy().getCommandMap();
        TreeMap<String, Command> commands = new TreeMap<String, Command>();
        for (Command command : commandMap.getCommands().values()) {
            if (!sender.hasPermission(command.getPermission())) continue;
            commands.put(command.getName(), command);
        }
        int pages = commands.size() % pageHeight == 0 ? commands.size() / pageHeight : commands.size() / pageHeight + 1;
        if ((pageNumber = Math.min(pageNumber, pages)) < 1) {
            pageNumber = 1;
        }
        sender.sendMessage(new TranslationContainer("waterdog.command.help.format", String.valueOf(pageNumber), String.valueOf(pages)));
        int i = 1;
        for (Command command : commands.values()) {
            if (i >= (pageNumber - 1) * pageHeight + 1 && i <= Math.min(commands.size(), pageNumber * pageHeight)) {
                sender.sendMessage("\u00a76" + commandMap.getCommandPrefix() + command.getName() + ": \u00a7r" + command.getDescription());
            }
            ++i;
        }
        return true;
    }
}

