/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe.command;

import dev.waterdog.waterdogpe.command.CommandSender;
import dev.waterdog.waterdogpe.command.CommandSettings;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.cloudburstmc.protocol.bedrock.data.command.CommandData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumConstraint;
import org.cloudburstmc.protocol.bedrock.data.command.CommandEnumData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandOverloadData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParam;
import org.cloudburstmc.protocol.bedrock.data.command.CommandParamData;
import org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;

public abstract class Command {
    private final String name;
    private final CommandSettings settings;
    private CommandData commandData;

    public Command(String name) {
        this(name, CommandSettings.empty());
    }

    public Command(String name, CommandSettings settings) {
        this.name = name;
        this.settings = settings;
    }

    public abstract boolean onExecute(CommandSender var1, String var2, String[] var3);

    public CommandSettings getSettings() {
        return this.settings;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.settings.getDescription();
    }

    public String getUsageMessage() {
        return this.settings.getUsageMessage();
    }

    public String getPermissionMessage() {
        return this.settings.getPermissionMessage();
    }

    public CommandData getCommandData() {
        if (this.commandData == null) {
            this.commandData = this.buildNetworkData();
        }
        return this.commandData;
    }

    public String getPermission() {
        return this.settings.getPermission();
    }

    public Set<String> getAliases() {
        return this.settings.getAliases();
    }

    private CommandData buildNetworkData() {
        LinkedHashMap<String, Set<CommandEnumConstraint>> aliases = new LinkedHashMap<String, Set<CommandEnumConstraint>>();
        aliases.put(this.name, EnumSet.of(CommandEnumConstraint.ALLOW_ALIASES));
        for (String alias : this.settings.getAliases()) {
            aliases.put(alias, EnumSet.of(CommandEnumConstraint.ALLOW_ALIASES));
        }
        CommandOverloadData[] overloads = this.buildCommandOverloads();
        return new CommandData(this.name, this.getDescription(), Collections.emptySet(), CommandPermission.ANY, new CommandEnumData(this.name + "_aliases", aliases, false), Collections.emptyList(), overloads);
    }

    protected CommandOverloadData[] buildCommandOverloads() {
        CommandParamData simpleData = new CommandParamData();
        simpleData.setName(this.name);
        simpleData.setOptional(true);
        simpleData.setType(CommandParam.TEXT);
        return new CommandOverloadData[]{new CommandOverloadData(false, new CommandParamData[]{simpleData})};
    }
}

