/*
 * Decompiled with CFR 0.152.
 */
package dev.waterdog.waterdogpe;

import dev.waterdog.waterdogpe.ProxyServer;
import dev.waterdog.waterdogpe.VersionInfo;
import dev.waterdog.waterdogpe.logger.MainLogger;
import dev.waterdog.waterdogpe.network.protocol.ProtocolVersion;
import io.netty.util.ResourceLeakDetector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class WaterdogPE {
    public static String DATA_PATH = System.getProperty("user.dir") + "/";
    public static final String PLUGIN_PATH = DATA_PATH + "plugins";
    private static final VersionInfo versionInfo = WaterdogPE.loadVersion();

    public static void main(String[] args) {
        Thread.currentThread().setName("WaterdogPE-main");
        System.out.println("Starting WaterdogPE....");
        System.setProperty("log4j.skipJansi", "false");
        MainLogger logger = MainLogger.getLogger();
        logger.info("\u00a7bStarting WaterDogPE proxy software!");
        logger.info("\u00a73Software Version: {}", versionInfo.baseVersion());
        logger.info("\u00a73Build Version: {}", versionInfo.buildVersion());
        logger.info("\u00a73Development Build: {}", versionInfo.debug());
        logger.info("\u00a73Software Authors: {}", versionInfo.author());
        logger.info("\u00a73Latest Supported Game Version: {}", ProtocolVersion.latest().getMinecraftVersion());
        int javaVersion = WaterdogPE.getJavaVersion();
        if (javaVersion < 17) {
            logger.error("Using unsupported Java version! Minimum supported version is Java 17, found Java " + javaVersion);
            return;
        }
        if (versionInfo.buildVersion().equals("#build") || versionInfo.branchName().equals("unknown")) {
            logger.warning("Custom build? Unofficial builds should be not run in production!");
        } else {
            logger.info("\u00a73Discovered branch \u00a7b{}\u00a73 commitId \u00a7b{}", versionInfo.branchName(), versionInfo.commitId());
        }
        if (versionInfo.debug()) {
            WaterdogPE.setLeakDetection(ResourceLeakDetector.Level.SIMPLE);
        } else {
            WaterdogPE.setLeakDetection(ResourceLeakDetector.Level.DISABLED);
        }
        logger.info("\u00a7eUsing memory leak detection level: {}", new Object[]{ResourceLeakDetector.getLevel()});
        if (!versionInfo.debug() && ResourceLeakDetector.getLevel().ordinal() > ResourceLeakDetector.Level.SIMPLE.ordinal()) {
            logger.warning("\u00a7eUsing higher memory leak detection levels in production environment can affect application stability and performance!");
        }
        try {
            new ProxyServer(logger, DATA_PATH, PLUGIN_PATH);
        }
        catch (Exception e) {
            logger.throwing(e);
            WaterdogPE.shutdownHook();
        }
    }

    protected static void shutdownHook() {
        LogManager.shutdown();
        Runtime.getRuntime().halt(0);
    }

    private static VersionInfo loadVersion() {
        InputStream inputStream = WaterdogPE.class.getClassLoader().getResourceAsStream("git.properties");
        if (inputStream == null) {
            return VersionInfo.unknown();
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            return VersionInfo.unknown();
        }
        String branchName = properties.getProperty("git.branch", "unknown");
        String commitId = properties.getProperty("git.commit.id.abbrev", "unknown");
        boolean debug = !branchName.equals("release");
        return new VersionInfo(branchName, commitId, debug);
    }

    public static void setLoggerLevel(Level level) {
        LoggerContext context = (LoggerContext)LogManager.getContext(false);
        Configuration log4jConfig = context.getConfiguration();
        LoggerConfig loggerConfig = log4jConfig.getLoggerConfig("");
        loggerConfig.setLevel(level);
        context.updateLoggers();
    }

    public static VersionInfo version() {
        return versionInfo;
    }

    private static int getJavaVersion() {
        int index;
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            return Integer.parseInt(version.substring(2, 3));
        }
        Matcher versionMatcher = Pattern.compile("\\d+").matcher(version);
        if (versionMatcher.find()) {
            version = versionMatcher.group(0);
        }
        if ((index = version.indexOf(".")) != -1) {
            version = version.substring(0, index);
        }
        return Integer.parseInt(version);
    }

    private static void setLeakDetection(ResourceLeakDetector.Level level) {
        if (ResourceLeakDetector.getLevel().ordinal() < level.ordinal()) {
            ResourceLeakDetector.setLevel(level);
        }
    }
}

