library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

-- Created from ssremote.bin
-- On 2/21/2023

entity ssremote is
	port (
	addr: in std_logic_vector(11 downto 0);
	clk: in std_logic;
	din: in std_logic_vector(15 downto 0);
	dout: out std_logic_vector(15 downto 0);
	we: in std_logic);
end ssremote;

architecture syn of ssremote is
   type ram_type is array (0 to 4095) of std_logic_vector(15 downto 0);
   signal RAM : ram_type := 
   (
   x"0000", x"0000", x"0000", x"60E1", x"01FF", x"B07B", x"7020", x"7021",
   x"E0DB", x"C0C1", x"E0DE", x"500F", x"0000", x"0000", x"607B", x"7097",
   x"3016", x"01FF", x"B079", x"0100", x"B07A", x"101B", x"0100", x"B079",
   x"70DD", x"0300", x"B07A", x"7087", x"3020", x"0000", x"0000", x"6076",
   x"011F", x"A02F", x"3006", x"0000", x"0000", x"602F", x"2006", x"0000",
   x"0000", x"69FD", x"2006", x"0000", x"0000", x"605A", x"1006", x"B03C",
   x"615C", x"013F", x"A029", x"B0C5", x"B0C7", x"304E", x"B023", x"0000",
   x"7028", x"B022", x"B400", x"01FF", x"C8C5", x"0C01", x"2038", x"0000",
   x"0000", x"0101", x"B02F", x"7082", x"3050", x"70C7", x"C0C4", x"B0C7",
   x"7022", x"3050", x"0101", x"8881", x"0101", x"C883", x"01FF", x"1F00",
   x"0101", x"C8CE", x"C0C1", x"0101", x"C8DC", x"0100", x"D8DD", x"0100",
   x"B03D", x"1F00", x"6161", x"B023", x"70C8", x"306B", x"0101", x"B037",
   x"70C8", x"B0C5", x"7580", x"B022", x"B030", x"0D01", x"01FF", x"C8C5",
   x"2062", x"0000", x"0000", x"7082", x"3072", x"7022", x"B030", x"0101",
   x"C0C8", x"1073", x"70C8", x"3075", x"B031", x"1F00", x"0100", x"B087",
   x"B097", x"609B", x"1F00", x"0101", x"8897", x"6082", x"68EA", x"69C7",
   x"6BEF", x"1F00", x"0100", x"B060", x"B061", x"B062", x"B063", x"0100",
   x"B068", x"0111", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000",
   x"0104", x"B068", x"0111", x"B069", x"0000", x"B06D", x"0000", x"0000",
   x"0000", x"0000", x"1F00", x"0120", x"B060", x"0100", x"B061", x"0100",
   x"B062", x"0100", x"B063", x"0104", x"B068", x"0114", x"B069", x"0000",
   x"B06D", x"0000", x"0000", x"0000", x"0000", x"01FF", x"B060", x"B061",
   x"01FF", x"B062", x"0107", x"B063", x"0100", x"B068", x"0111", x"B069",
   x"0000", x"B06D", x"0000", x"0000", x"0000", x"0000", x"0112", x"B069",
   x"0000", x"B06D", x"0000", x"0000", x"0000", x"0000", x"01FF", x"B060",
   x"01F7", x"B061", x"0101", x"B062", x"0100", x"B063", x"0104", x"B068",
   x"0111", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000", x"0000",
   x"0112", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000", x"0000",
   x"1F00", x"60EA", x"69E2", x"60FD", x"6159", x"617B", x"68D0", x"6166",
   x"68E4", x"1F00", x"0100", x"B0C1", x"0101", x"B0C2", x"0102", x"B0C3",
   x"01FF", x"B0C4", x"0100", x"B0CE", x"01FF", x"B07B", x"0100", x"B079",
   x"0180", x"B0CF", x"01C1", x"B0DE", x"1F00", x"0100", x"B080", x"B081",
   x"01FF", x"B082", x"0100", x"B083", x"B084", x"B085", x"B086", x"B087",
   x"B088", x"B089", x"0100", x"B08A", x"0114", x"B08B", x"0100", x"B08C",
   x"B08D", x"B08E", x"B08F", x"0137", x"B090", x"0169", x"B091", x"0161",
   x"B092", x"0130", x"B093", x"0105", x"B094", x"0102", x"B095", x"0100",
   x"B096", x"B097", x"B098", x"B099", x"B09A", x"0101", x"B09A", x"0100",
   x"B09B", x"B09C", x"B09D", x"B09E", x"015A", x"B09F", x"017F", x"B0CD",
   x"01FC", x"0B00", x"0102", x"0B80", x"6C7A", x"0100", x"B0E6", x"0100",
   x"B0E7", x"011F", x"B0E8", x"6C39", x"70E1", x"B0D6", x"B700", x"70E2",
   x"B0D7", x"B701", x"70E3", x"B0D8", x"B702", x"70E4", x"B0D9", x"B703",
   x"6C7A", x"01BC", x"0B00", x"0107", x"0B80", x"0000", x"0000", x"0000",
   x"0110", x"B700", x"0100", x"B701", x"0102", x"B702", x"0100", x"B703",
   x"1F00", x"615C", x"6161", x"1F00", x"0100", x"0800", x"0101", x"0880",
   x"1F00", x"0180", x"0900", x"0101", x"0980", x"1F00", x"7040", x"B02A",
   x"B032", x"7041", x"B02B", x"B033", x"7042", x"B02C", x"B034", x"0100",
   x"B036", x"0101", x"B02F", x"B037", x"0140", x"B035", x"0108", x"B02D",
   x"708B", x"B02E", x"1F00", x"0180", x"B240", x"0102", x"B241", x"01C0",
   x"B242", x"0102", x"B243", x"0180", x"B244", x"0105", x"B245", x"01A0",
   x"B246", x"0105", x"B247", x"01C0", x"B248", x"0105", x"B249", x"01E0",
   x"B24A", x"0105", x"B24B", x"0100", x"B24C", x"0106", x"B24D", x"0120",
   x"B24E", x"0106", x"B24F", x"0140", x"B250", x"0106", x"B251", x"0160",
   x"B252", x"0106", x"B253", x"0188", x"B254", x"0106", x"B255", x"01B0",
   x"B256", x"0106", x"B257", x"01D8", x"B258", x"0106", x"B259", x"0100",
   x"B25A", x"0107", x"B25B", x"0128", x"B25C", x"0107", x"B25D", x"0150",
   x"B25E", x"0107", x"B25F", x"0178", x"B260", x"0107", x"B261", x"0100",
   x"B262", x"B263", x"0180", x"0B00", x"0105", x"0B80", x"0000", x"0000",
   x"0000", x"01A0", x"B700", x"0108", x"B701", x"0102", x"B702", x"0180",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01B8", x"B70C", x"0107", x"B70D", x"0162", x"B70E",
   x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"0145", x"B712",
   x"016E", x"B713", x"0163", x"B714", x"0130", x"B715", x"016D", x"B716",
   x"016F", x"B717", x"0164", x"B718", x"0165", x"B719", x"0100", x"B71A",
   x"0100", x"B71B", x"01A0", x"0B00", x"0105", x"0B80", x"0000", x"0000",
   x"0000", x"01A0", x"B700", x"0108", x"B701", x"0102", x"B702", x"0180",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"019B", x"B70C", x"0107", x"B70D", x"0162", x"B70E",
   x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"0145", x"B712",
   x"016E", x"B713", x"0163", x"B714", x"0131", x"B715", x"016D", x"B716",
   x"016F", x"B717", x"0164", x"B718", x"0165", x"B719", x"0100", x"B71A",
   x"0100", x"B71B", x"01C0", x"0B00", x"0105", x"0B80", x"0000", x"0000",
   x"0000", x"01A0", x"B700", x"0108", x"B701", x"0102", x"B702", x"0180",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01BA", x"B70C", x"0107", x"B70D", x"0162", x"B70E",
   x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"0145", x"B712",
   x"016E", x"B713", x"0163", x"B714", x"0132", x"B715", x"016D", x"B716",
   x"016F", x"B717", x"0164", x"B718", x"0165", x"B719", x"0100", x"B71A",
   x"0100", x"B71B", x"01E0", x"0B00", x"0105", x"0B80", x"0000", x"0000",
   x"0000", x"01A0", x"B700", x"0108", x"B701", x"0102", x"B702", x"0180",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01BB", x"B70C", x"0107", x"B70D", x"0162", x"B70E",
   x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"0145", x"B712",
   x"016E", x"B713", x"0163", x"B714", x"0133", x"B715", x"016D", x"B716",
   x"016F", x"B717", x"0164", x"B718", x"0165", x"B719", x"0100", x"B71A",
   x"0100", x"B71B", x"0100", x"0B00", x"0106", x"0B80", x"0000", x"0000",
   x"0000", x"01A0", x"B700", x"0110", x"B701", x"0102", x"B702", x"0180",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01BC", x"B70C", x"0107", x"B70D", x"0162", x"B70E",
   x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"0173", x"B712",
   x"0177", x"B713", x"0172", x"B714", x"0165", x"B715", x"0176", x"B716",
   x"0169", x"B717", x"0173", x"B718", x"0169", x"B719", x"016F", x"B71A",
   x"016E", x"B71B", x"0100", x"B71C", x"0100", x"B71D", x"0120", x"0B00",
   x"0106", x"0B80", x"0000", x"0000", x"0000", x"01A0", x"B700", x"0110",
   x"B701", x"0102", x"B702", x"0180", x"B703", x"0100", x"B704", x"B705",
   x"B706", x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01BE", x"B70C",
   x"0107", x"B70D", x"0162", x"B70E", x"0169", x"B70F", x"0174", x"B710",
   x"0100", x"B711", x"0168", x"B712", x"0177", x"B713", x"0172", x"B714",
   x"0165", x"B715", x"0176", x"B716", x"0169", x"B717", x"0173", x"B718",
   x"0169", x"B719", x"016F", x"B71A", x"016E", x"B71B", x"0100", x"B71C",
   x"0100", x"B71D", x"0140", x"0B00", x"0106", x"0B80", x"0000", x"0000",
   x"0000", x"01A0", x"B700", x"0120", x"B701", x"0104", x"B702", x"0180",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01FC", x"B70C", x"0102", x"B70D", x"0162", x"B70E",
   x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"016E", x"B712",
   x"0176", x"B713", x"0175", x"B714", x"016E", x"B715", x"0169", x"B716",
   x"0174", x"B717", x"016E", x"B718", x"0175", x"B719", x"016D", x"B71A",
   x"0162", x"B71B", x"0165", x"B71C", x"0172", x"B71D", x"0100", x"B71E",
   x"0100", x"B71F", x"0160", x"0B00", x"0106", x"0B80", x"0000", x"0000",
   x"0000", x"01A0", x"B700", x"0110", x"B701", x"0102", x"B702", x"0180",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01E0", x"B70C", x"0102", x"B70D", x"0175", x"B70E",
   x"0100", x"B70F", x"0169", x"B710", x"016E", x"B711", x"012D", x"B712",
   x"0130", x"B713", x"0130", x"B714", x"012D", x"B715", x"0132", x"B716",
   x"0133", x"B717", x"012D", x"B718", x"0173", x"B719", x"0161", x"B71A",
   x"016D", x"B71B", x"0170", x"B71C", x"016C", x"B71D", x"0165", x"B71E",
   x"012D", x"B71F", x"0174", x"B720", x"0169", x"B721", x"016D", x"B722",
   x"0165", x"B723", x"0100", x"B724", x"0188", x"0B00", x"0106", x"0B80",
   x"0000", x"0000", x"0000", x"01A0", x"B700", x"0110", x"B701", x"0102",
   x"B702", x"0180", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707",
   x"B708", x"B709", x"B70A", x"B70B", x"01E6", x"B70C", x"0102", x"B70D",
   x"0175", x"B70E", x"0100", x"B70F", x"0169", x"B710", x"016E", x"B711",
   x"012D", x"B712", x"0132", x"B713", x"0134", x"B714", x"012D", x"B715",
   x"0134", x"B716", x"0137", x"B717", x"012D", x"B718", x"0173", x"B719",
   x"0161", x"B71A", x"016D", x"B71B", x"0170", x"B71C", x"016C", x"B71D",
   x"0165", x"B71E", x"012D", x"B71F", x"0174", x"B720", x"0169", x"B721",
   x"016D", x"B722", x"0165", x"B723", x"0100", x"B724", x"01B0", x"0B00",
   x"0106", x"0B80", x"0000", x"0000", x"0000", x"01A0", x"B700", x"0108",
   x"B701", x"0102", x"B702", x"0180", x"B703", x"0100", x"B704", x"B705",
   x"B706", x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01E2", x"B70C",
   x"0102", x"B70D", x"0175", x"B70E", x"0100", x"B70F", x"0169", x"B710",
   x"016E", x"B711", x"012D", x"B712", x"0130", x"B713", x"0130", x"B714",
   x"012D", x"B715", x"0132", x"B716", x"0133", x"B717", x"012D", x"B718",
   x"0166", x"B719", x"0161", x"B71A", x"0173", x"B71B", x"0174", x"B71C",
   x"012D", x"B71D", x"0166", x"B71E", x"0169", x"B71F", x"016C", x"B720",
   x"0174", x"B721", x"0100", x"B722", x"01D8", x"0B00", x"0106", x"0B80",
   x"0000", x"0000", x"0000", x"01A0", x"B700", x"0108", x"B701", x"0102",
   x"B702", x"0180", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707",
   x"B708", x"B709", x"B70A", x"B70B", x"01E8", x"B70C", x"0102", x"B70D",
   x"0175", x"B70E", x"0100", x"B70F", x"0169", x"B710", x"016E", x"B711",
   x"012D", x"B712", x"0132", x"B713", x"0134", x"B714", x"012D", x"B715",
   x"0134", x"B716", x"0137", x"B717", x"012D", x"B718", x"0166", x"B719",
   x"0161", x"B71A", x"0173", x"B71B", x"0174", x"B71C", x"012D", x"B71D",
   x"0166", x"B71E", x"0169", x"B71F", x"016C", x"B720", x"0174", x"B721",
   x"0100", x"B722", x"0100", x"0B00", x"0107", x"0B80", x"0000", x"0000",
   x"0000", x"01A0", x"B700", x"0110", x"B701", x"0102", x"B702", x"0180",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01E4", x"B70C", x"0102", x"B70D", x"0175", x"B70E",
   x"0100", x"B70F", x"0169", x"B710", x"016E", x"B711", x"012D", x"B712",
   x"0130", x"B713", x"0130", x"B714", x"012D", x"B715", x"0132", x"B716",
   x"0133", x"B717", x"012D", x"B718", x"0173", x"B719", x"016C", x"B71A",
   x"016F", x"B71B", x"0177", x"B71C", x"012D", x"B71D", x"0166", x"B71E",
   x"0169", x"B71F", x"016C", x"B720", x"0174", x"B721", x"0100", x"B722",
   x"0128", x"0B00", x"0107", x"0B80", x"0000", x"0000", x"0000", x"01A0",
   x"B700", x"0110", x"B701", x"0102", x"B702", x"0180", x"B703", x"0100",
   x"B704", x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A", x"B70B",
   x"01EA", x"B70C", x"0102", x"B70D", x"0175", x"B70E", x"0100", x"B70F",
   x"0169", x"B710", x"016E", x"B711", x"012D", x"B712", x"0132", x"B713",
   x"0134", x"B714", x"012D", x"B715", x"0134", x"B716", x"0137", x"B717",
   x"012D", x"B718", x"0173", x"B719", x"016C", x"B71A", x"016F", x"B71B",
   x"0177", x"B71C", x"012D", x"B71D", x"0166", x"B71E", x"0169", x"B71F",
   x"016C", x"B720", x"0174", x"B721", x"0100", x"0150", x"0B00", x"0107",
   x"0B80", x"0000", x"0000", x"0000", x"01A0", x"B700", x"0120", x"B701",
   x"0102", x"B702", x"0180", x"B703", x"0100", x"B704", x"B705", x"B706",
   x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01EC", x"B70C", x"0102",
   x"B70D", x"0175", x"B70E", x"0100", x"B70F", x"0169", x"B710", x"016E",
   x"B711", x"012D", x"B712", x"0130", x"B713", x"0130", x"B714", x"012D",
   x"B715", x"0132", x"B716", x"0133", x"B717", x"012D", x"B718", x"0173",
   x"B719", x"016C", x"B71A", x"016F", x"B71B", x"0177", x"B71C", x"012D",
   x"B71D", x"016D", x"B71E", x"0161", x"B71F", x"0173", x"B720", x"016B",
   x"B721", x"0100", x"B722", x"0178", x"0B00", x"0107", x"0B80", x"0000",
   x"0000", x"0000", x"01A0", x"B700", x"0118", x"B701", x"0102", x"B702",
   x"0180", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708",
   x"B709", x"B70A", x"B70B", x"01F0", x"B70C", x"0102", x"B70D", x"0175",
   x"B70E", x"0100", x"B70F", x"0169", x"B710", x"016E", x"B711", x"012D",
   x"B712", x"0132", x"B713", x"0134", x"B714", x"012D", x"B715", x"0134",
   x"B716", x"0137", x"B717", x"012D", x"B718", x"0173", x"B719", x"016C",
   x"B71A", x"016F", x"B71B", x"0177", x"B71C", x"012D", x"B71D", x"016D",
   x"B71E", x"0161", x"B71F", x"0173", x"B720", x"016B", x"B721", x"0100",
   x"0180", x"B200", x"0102", x"B201", x"01C0", x"B202", x"0102", x"B203",
   x"0100", x"B204", x"0103", x"B205", x"0140", x"B206", x"0104", x"B207",
   x"0160", x"B208", x"0104", x"B209", x"0180", x"B20A", x"0104", x"B20B",
   x"01A0", x"B20C", x"0104", x"B20D", x"01C0", x"B20E", x"0103", x"B20F",
   x"01E0", x"B210", x"0103", x"B211", x"0100", x"B212", x"0104", x"B213",
   x"0120", x"B214", x"0104", x"B215", x"01A0", x"B216", x"0103", x"B217",
   x"0100", x"B218", x"B219", x"01B0", x"B280", x"0100", x"B281", x"0100",
   x"B282", x"0100", x"B283", x"0173", x"B284", x"0174", x"B285", x"0161",
   x"B286", x"016E", x"B287", x"0164", x"B288", x"0161", x"B289", x"0172",
   x"B28A", x"0164", x"B28B", x"0100", x"B28C", x"01B0", x"B2C0", x"0100",
   x"B2C1", x"0101", x"B2C2", x"0100", x"B2C3", x"0173", x"B2C4", x"0174",
   x"B2C5", x"0161", x"B2C6", x"016E", x"B2C7", x"0164", x"B2C8", x"0161",
   x"B2C9", x"0172", x"B2CA", x"0164", x"B2CB", x"0100", x"B2CC", x"0100",
   x"0B00", x"0103", x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0130",
   x"B701", x"0101", x"B702", x"0100", x"B703", x"0100", x"B704", x"B705",
   x"B706", x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01A0", x"B70C",
   x"0107", x"B70D", x"0162", x"B70E", x"0169", x"B70F", x"0174", x"B710",
   x"0100", x"B711", x"0149", x"B712", x"016E", x"B713", x"0100", x"B714",
   x"0120", x"0B00", x"0103", x"0B80", x"0000", x"0000", x"01A0", x"B700",
   x"0108", x"B701", x"0108", x"B702", x"0100", x"B703", x"0100", x"B704",
   x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01A8",
   x"B70C", x"0107", x"B70D", x"0163", x"B70E", x"016F", x"B70F", x"0175",
   x"B710", x"016E", x"B711", x"0174", x"B712", x"0100", x"B713", x"0165",
   x"B714", x"016E", x"B715", x"0163", x"B716", x"0130", x"B717", x"0100",
   x"B718", x"0140", x"0B00", x"0103", x"0B80", x"0000", x"0000", x"01A0",
   x"B700", x"0108", x"B701", x"0108", x"B702", x"0100", x"B703", x"0100",
   x"B704", x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A", x"B70B",
   x"01A9", x"B70C", x"0107", x"B70D", x"0163", x"B70E", x"016F", x"B70F",
   x"0175", x"B710", x"016E", x"B711", x"0174", x"B712", x"0100", x"B713",
   x"0145", x"B714", x"016E", x"B715", x"0163", x"B716", x"0131", x"B717",
   x"0100", x"B718", x"0160", x"0B00", x"0103", x"0B80", x"0000", x"0000",
   x"01A0", x"B700", x"0108", x"B701", x"0108", x"B702", x"0100", x"B703",
   x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A",
   x"B70B", x"01AA", x"B70C", x"0107", x"B70D", x"0163", x"B70E", x"016F",
   x"B70F", x"0175", x"B710", x"016E", x"B711", x"0174", x"B712", x"0100",
   x"B713", x"0145", x"B714", x"016E", x"B715", x"0163", x"B716", x"0132",
   x"B717", x"0100", x"B718", x"0180", x"0B00", x"0103", x"0B80", x"0000",
   x"0000", x"01A0", x"B700", x"0108", x"B701", x"0108", x"B702", x"0100",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01AB", x"B70C", x"0107", x"B70D", x"0163", x"B70E",
   x"016F", x"B70F", x"0175", x"B710", x"016E", x"B711", x"0174", x"B712",
   x"0100", x"B713", x"0145", x"B714", x"016E", x"B715", x"0163", x"B716",
   x"0133", x"B717", x"0100", x"B718", x"01A0", x"0B00", x"0103", x"0B80",
   x"0000", x"0000", x"01A0", x"B700", x"0118", x"B701", x"0101", x"B702",
   x"0180", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708",
   x"B709", x"B70A", x"B70B", x"01B4", x"B70C", x"0107", x"B70D", x"0162",
   x"B70E", x"0169", x"B70F", x"0174", x"B710", x"0100", x"B711", x"014F",
   x"B712", x"0175", x"B713", x"0174", x"B714", x"0100", x"B715", x"01C0",
   x"0B00", x"0103", x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0108",
   x"B701", x"0102", x"B702", x"0100", x"B703", x"0100", x"B704", x"B705",
   x"B706", x"B707", x"0133", x"B708", x"0133", x"B709", x"0153", x"B70A",
   x"0140", x"B70B", x"01AC", x"B70C", x"0107", x"B70D", x"0176", x"B70E",
   x"016F", x"B70F", x"016C", x"B710", x"0174", x"B711", x"0173", x"B712",
   x"0100", x"B713", x"0141", x"B714", x"016E", x"B715", x"0161", x"B716",
   x"016C", x"B717", x"016F", x"B718", x"0167", x"B719", x"0149", x"B71A",
   x"016E", x"B71B", x"0130", x"B71C", x"0100", x"B71D", x"01E0", x"0B00",
   x"0103", x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0108", x"B701",
   x"0102", x"B702", x"0100", x"B703", x"0100", x"B704", x"B705", x"B706",
   x"B707", x"0133", x"B708", x"0133", x"B709", x"0153", x"B70A", x"0140",
   x"B70B", x"01AE", x"B70C", x"0107", x"B70D", x"0176", x"B70E", x"016F",
   x"B70F", x"016C", x"B710", x"0174", x"B711", x"0173", x"B712", x"0100",
   x"B713", x"0141", x"B714", x"016E", x"B715", x"0161", x"B716", x"016C",
   x"B717", x"016F", x"B718", x"0167", x"B719", x"0149", x"B71A", x"016E",
   x"B71B", x"0131", x"B71C", x"0100", x"B71D", x"0100", x"0B00", x"0104",
   x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0108", x"B701", x"0102",
   x"B702", x"0100", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707",
   x"0133", x"B708", x"0133", x"B709", x"0153", x"B70A", x"0140", x"B70B",
   x"01B0", x"B70C", x"0107", x"B70D", x"0176", x"B70E", x"016F", x"B70F",
   x"016C", x"B710", x"0174", x"B711", x"0173", x"B712", x"0100", x"B713",
   x"0141", x"B714", x"016E", x"B715", x"0161", x"B716", x"016C", x"B717",
   x"016F", x"B718", x"0167", x"B719", x"0149", x"B71A", x"016E", x"B71B",
   x"0132", x"B71C", x"0100", x"B71D", x"0120", x"0B00", x"0104", x"0B80",
   x"0000", x"0000", x"01A0", x"B700", x"0108", x"B701", x"0102", x"B702",
   x"0100", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"0133",
   x"B708", x"0133", x"B709", x"0153", x"B70A", x"0140", x"B70B", x"01B2",
   x"B70C", x"0107", x"B70D", x"0176", x"B70E", x"016F", x"B70F", x"016C",
   x"B710", x"0174", x"B711", x"0173", x"B712", x"0100", x"B713", x"0141",
   x"B714", x"016E", x"B715", x"0161", x"B716", x"016C", x"B717", x"016F",
   x"B718", x"0167", x"B719", x"0149", x"B71A", x"016E", x"B71B", x"0133",
   x"B71C", x"0100", x"B71D", x"0140", x"0B00", x"0104", x"0B80", x"0000",
   x"0000", x"01A0", x"B700", x"0104", x"B701", x"0108", x"B702", x"0100",
   x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709",
   x"B70A", x"B70B", x"01A8", x"B70C", x"0107", x"B70D", x"0163", x"B70E",
   x"016F", x"B70F", x"0175", x"B710", x"016E", x"B711", x"0174", x"B712",
   x"0100", x"B713", x"0165", x"B714", x"016E", x"B715", x"0163", x"B716",
   x"0130", x"B717", x"0100", x"B718", x"0160", x"0B00", x"0104", x"0B80",
   x"0000", x"0000", x"01A0", x"B700", x"0104", x"B701", x"0108", x"B702",
   x"0100", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707", x"B708",
   x"B709", x"B70A", x"B70B", x"01A9", x"B70C", x"0107", x"B70D", x"0163",
   x"B70E", x"016F", x"B70F", x"0175", x"B710", x"016E", x"B711", x"0174",
   x"B712", x"0100", x"B713", x"0145", x"B714", x"016E", x"B715", x"0163",
   x"B716", x"0131", x"B717", x"0100", x"B718", x"0180", x"0B00", x"0104",
   x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0104", x"B701", x"0108",
   x"B702", x"0100", x"B703", x"0100", x"B704", x"B705", x"B706", x"B707",
   x"B708", x"B709", x"B70A", x"B70B", x"01AA", x"B70C", x"0107", x"B70D",
   x"0163", x"B70E", x"016F", x"B70F", x"0175", x"B710", x"016E", x"B711",
   x"0174", x"B712", x"0100", x"B713", x"0145", x"B714", x"016E", x"B715",
   x"0163", x"B716", x"0132", x"B717", x"0100", x"B718", x"01A0", x"0B00",
   x"0104", x"0B80", x"0000", x"0000", x"01A0", x"B700", x"0104", x"B701",
   x"0108", x"B702", x"0100", x"B703", x"0100", x"B704", x"B705", x"B706",
   x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01AB", x"B70C", x"0107",
   x"B70D", x"0163", x"B70E", x"016F", x"B70F", x"0175", x"B710", x"016E",
   x"B711", x"0174", x"B712", x"0100", x"B713", x"0145", x"B714", x"016E",
   x"B715", x"0163", x"B716", x"0133", x"B717", x"0100", x"B718", x"1F00",
   x"0100", x"E086", x"38D6", x"0101", x"E086", x"38E3", x"0100", x"B0D4",
   x"0102", x"B0D5", x"0140", x"B0D2", x"0102", x"B0D3", x"010D", x"B0D0",
   x"0103", x"B0D1", x"1F00", x"1F00", x"609B", x"68EA", x"690C", x"6929",
   x"69B4", x"1F00", x"0100", x"B060", x"B061", x"B062", x"B063", x"0100",
   x"B068", x"017D", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000",
   x"0000", x"0160", x"B060", x"0110", x"B061", x"0100", x"B062", x"0100",
   x"B063", x"0100", x"B068", x"017E", x"B069", x"0000", x"B06D", x"0000",
   x"0000", x"0000", x"0000", x"1F00", x"0134", x"B2E0", x"0100", x"B2E1",
   x"0134", x"B2E6", x"0100", x"B2E7", x"0104", x"B2E2", x"0104", x"B2E8",
   x"0128", x"B2E4", x"0100", x"B2E5", x"0128", x"B2EA", x"0100", x"B2EB",
   x"0100", x"B2EC", x"01FF", x"B2ED", x"B2EE", x"B2F0", x"B2F1", x"B2F2",
   x"1F00", x"0120", x"B0F4", x"01FF", x"C2E0", x"B0EF", x"01FF", x"D2E1",
   x"B0F0", x"70EF", x"69EB", x"88F4", x"70EF", x"69F8", x"B0EF", x"0103",
   x"A0F0", x"69EB", x"80EF", x"B0F5", x"013F", x"A2E2", x"B0F1", x"72E4",
   x"69EB", x"80F1", x"B0F6", x"72E4", x"69F8", x"B0F2", x"72E5", x"69EB",
   x"80F2", x"B0F7", x"70F4", x"B060", x"70F5", x"B061", x"70F6", x"B062",
   x"70F7", x"B063", x"0100", x"B068", x"0180", x"B069", x"0000", x"B06D",
   x"0000", x"0000", x"0000", x"0000", x"72EC", x"B060", x"72ED", x"B061",
   x"72EE", x"B062", x"0100", x"B063", x"0100", x"B068", x"0181", x"B069",
   x"0000", x"B06D", x"0000", x"0000", x"0000", x"0000", x"0120", x"B0F8",
   x"01FF", x"C2E6", x"B0EF", x"01FF", x"D2E7", x"B0F0", x"70EF", x"69EB",
   x"88F8", x"70EF", x"69F8", x"B0EF", x"0103", x"A0F0", x"69EB", x"80EF",
   x"B0F9", x"013F", x"A2E8", x"B0F1", x"72EA", x"69EB", x"80F1", x"B0FA",
   x"72EA", x"69F8", x"B0F2", x"72EB", x"69EB", x"80F2", x"B0FB", x"70F8",
   x"B060", x"70F9", x"B061", x"70FA", x"B062", x"70FB", x"B063", x"0104",
   x"B068", x"0180", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000",
   x"0000", x"72F0", x"B060", x"72F1", x"B061", x"72F2", x"B062", x"0100",
   x"B063", x"0104", x"B068", x"0181", x"B069", x"0000", x"B06D", x"0000",
   x"0000", x"0000", x"0000", x"1F00", x"010F", x"B060", x"0180", x"B061",
   x"0100", x"B062", x"0100", x"B063", x"0100", x"B068", x"0190", x"B069",
   x"0000", x"B06D", x"0000", x"0000", x"0000", x"0000", x"1F00", x"01B8",
   x"0B00", x"0107", x"0B80", x"0100", x"0000", x"0000", x"B700", x"B701",
   x"B702", x"B703", x"1F00", x"6C7A", x"0100", x"B0E6", x"B0E7", x"011F",
   x"B0E8", x"0100", x"B0E1", x"B0E2", x"B0E3", x"011B", x"B0E4", x"6C5B",
   x"6C7A", x"1F00", x"6C7A", x"0100", x"B0E6", x"B0E7", x"011F", x"B0E8",
   x"6C6F", x"6C7A", x"1F00", x"C0C1", x"0200", x"C0C1", x"0200", x"C0C1",
   x"0200", x"C0C1", x"0200", x"C0C1", x"0200", x"C0C1", x"0200", x"1F00",
   x"C0C1", x"0300", x"C0C1", x"0300", x"1F00", x"6159", x"7400", x"B0C9",
   x"01C0", x"A400", x"B0CA", x"0C01", x"3BE8", x"0140", x"E0CA", x"2A10",
   x"0104", x"A0C9", x"3A10", x"7400", x"B098", x"7401", x"B099", x"0C02",
   x"01C0", x"E0CA", x"3ACA", x"0180", x"E0CA", x"3B18", x"0103", x"A0C9",
   x"B0CB", x"01EE", x"E08C", x"B0CC", x"0120", x"A0C9", x"3A7B", x"70CC",
   x"3A67", x"0101", x"E099", x"4BE3", x"0107", x"E099", x"5BE3", x"7098",
   x"0A00", x"7099", x"0A80", x"0103", x"E0CB", x"3A53", x"0102", x"E0CB",
   x"3A42", x"0101", x"E0CB", x"3A3A", x"7400", x"B600", x"7001", x"B09A",
   x"0C01", x"1BC8", x"7400", x"B600", x"7401", x"B601", x"7002", x"B09A",
   x"0C02", x"1BC8", x"7400", x"B600", x"7401", x"B601", x"7402", x"B602",
   x"7403", x"B603", x"7004", x"B09A", x"0C04", x"0101", x"E08C", x"3B24",
   x"0000", x"0000", x"1BC8", x"7400", x"B600", x"7401", x"B601", x"7402",
   x"B602", x"7403", x"B603", x"7404", x"B604", x"7405", x"B605", x"7406",
   x"B606", x"7407", x"B607", x"0108", x"B09A", x"0C08", x"1BC8", x"0102",
   x"E0CB", x"2BE8", x"7098", x"B068", x"7099", x"B069", x"7400", x"B060",
   x"7401", x"B061", x"7402", x"B062", x"7403", x"B063", x"B06D", x"7004",
   x"B09A", x"0C04", x"1BC9", x"70CC", x"3ABE", x"0101", x"E099", x"4BE3",
   x"0107", x"E099", x"5BE3", x"7098", x"0A00", x"7099", x"0A80", x"0103",
   x"E0CB", x"3AAA", x"0102", x"E0CB", x"3A9E", x"0101", x"E0CB", x"3A96",
   x"7600", x"B580", x"0101", x"B09A", x"0D01", x"1BC9", x"7600", x"B580",
   x"7601", x"B581", x"0102", x"B09A", x"0D02", x"1BC9", x"7600", x"B580",
   x"7601", x"B581", x"7602", x"B582", x"7603", x"B583", x"0104", x"B09A",
   x"0D04", x"1BC9", x"7600", x"B580", x"7601", x"B581", x"7602", x"B582",
   x"7603", x"B583", x"7604", x"B584", x"7605", x"B585", x"7606", x"B586",
   x"7607", x"B587", x"0108", x"B09A", x"0D08", x"1BC9", x"7098", x"B068",
   x"7099", x"B069", x"B06C", x"0102", x"E0CB", x"2BE8", x"0104", x"B09A",
   x"0D04", x"1BC9", x"011F", x"A0C9", x"C0CF", x"0A00", x"0100", x"0A80",
   x"0120", x"A0C9", x"3B14", x"0110", x"A0C9", x"2AE2", x"7400", x"B600",
   x"0C01", x"01EB", x"E0C9", x"3ADF", x"0000", x"0000", x"1BD2", x"708B",
   x"B02E", x"1BD2", x"01F7", x"E0C9", x"3AF6", x"01F8", x"E0C9", x"3AFA",
   x"01F9", x"E0C9", x"3AFE", x"01FA", x"E0C9", x"3B02", x"01FE", x"E0C9",
   x"3B09", x"01FF", x"E0C9", x"3B11", x"0C01", x"1BD2", x"7400", x"B097",
   x"0C01", x"1BD2", x"7400", x"B098", x"0C01", x"1BD2", x"7400", x"B099",
   x"0C01", x"1BD2", x"C0C1", x"7400", x"C898", x"0100", x"D899", x"0C01",
   x"1BD2", x"7400", x"E09F", x"2B0F", x"0000", x"0000", x"1000", x"0C01",
   x"1BD2", x"6159", x"0100", x"1F00", x"7600", x"B580", x"0D01", x"1BD2",
   x"01BD", x"E0C9", x"3B38", x"01BC", x"E0C9", x"3BAF", x"01BB", x"E0C9",
   x"3BB9", x"0000", x"0000", x"1BD2", x"01FF", x"E0D9", x"2B37", x"6C7A",
   x"0100", x"B0E6", x"B0E7", x"011F", x"B0E8", x"72FC", x"B0E1", x"72FD",
   x"B0E2", x"72FE", x"B0E3", x"72FF", x"B0E4", x"6C5B", x"6C7A", x"1BC8",
   x"0100", x"B068", x"0182", x"B069", x"B06C", x"0000", x"0000", x"7097",
   x"B580", x"7060", x"B581", x"7061", x"B582", x"7062", x"B583", x"0104",
   x"B068", x"0182", x"B069", x"B06C", x"0000", x"0000", x"0000", x"0000",
   x"7060", x"B584", x"7061", x"B585", x"7062", x"B586", x"0100", x"B068",
   x"0184", x"B069", x"B06C", x"0000", x"0000", x"0000", x"0000", x"010F",
   x"A060", x"B0C6", x"7061", x"0280", x"0000", x"80C6", x"B587", x"010F",
   x"A062", x"B0C6", x"7063", x"0280", x"0000", x"80C6", x"B588", x"0100",
   x"B068", x"0190", x"B069", x"B06C", x"0000", x"0000", x"0000", x"0000",
   x"7061", x"B589", x"0104", x"B068", x"0190", x"B069", x"B06C", x"0000",
   x"0000", x"0000", x"0000", x"7061", x"B58A", x"0108", x"B068", x"0190",
   x"B069", x"B06C", x"0000", x"0000", x"0000", x"0000", x"7061", x"B58B",
   x"010C", x"B068", x"0190", x"B069", x"B06C", x"0000", x"0000", x"0000",
   x"0000", x"7061", x"B58C", x"0D0D", x"7097", x"2BAD", x"0100", x"B068",
   x"017D", x"B069", x"7400", x"B060", x"7401", x"B061", x"7402", x"B062",
   x"B06D", x"0000", x"0000", x"0000", x"0000", x"0C03", x"1BD2", x"70D6",
   x"B580", x"70D7", x"B581", x"70D8", x"B582", x"70D9", x"B583", x"0D04",
   x"1BD2", x"68D0", x"70D0", x"B580", x"70D1", x"B581", x"70D4", x"B582",
   x"70D5", x"B583", x"70D2", x"B584", x"70D3", x"B585", x"0D06", x"1BD2",
   x"6BEF", x"0108", x"A0C9", x"3BD2", x"C0C1", x"709A", x"C898", x"0100",
   x"D899", x"1BD2", x"0500", x"A0CD", x"B0C8", x"0580", x"E0C2", x"2BE6",
   x"0140", x"C0C1", x"E0C8", x"5BE6", x"0400", x"E0C7", x"59FE", x"0000",
   x"6BEA", x"0100", x"1F00", x"0120", x"8881", x"1BE8", x"0110", x"8881",
   x"01FF", x"1F00", x"7020", x"B0DA", x"7021", x"B0DB", x"1F00", x"6929",
   x"01B8", x"0B00", x"0107", x"0B80", x"0100", x"B060", x"B061", x"B062",
   x"B063", x"B068", x"0184", x"B069", x"7700", x"3C00", x"0101", x"B060",
   x"7701", x"3C04", x"0101", x"B061", x"7702", x"3C08", x"0101", x"B062",
   x"7703", x"3C0C", x"0101", x"B063", x"B06D", x"1F00", x"0100", x"B068",
   x"0111", x"B069", x"01FF", x"B060", x"B061", x"B062", x"B063", x"0000",
   x"0000", x"B06D", x"B0C6", x"0100", x"B068", x"0110", x"B069", x"70C6",
   x"B060", x"0100", x"B061", x"B062", x"B063", x"B06D", x"70C6", x"1F00",
   x"0B00", x"0100", x"0B80", x"0100", x"B068", x"0110", x"B069", x"7700",
   x"B060", x"7701", x"B061", x"7702", x"B062", x"0100", x"B063", x"B06D",
   x"1F00", x"0102", x"E0E0", x"3C43", x"0102", x"B0E0", x"0100", x"B07D",
   x"0103", x"6CA4", x"6CAC", x"0100", x"6CA4", x"B0E1", x"0100", x"6CA4",
   x"B0E2", x"0100", x"6CA4", x"B0E3", x"0100", x"6CA4", x"B0E4", x"1F00",
   x"0100", x"B07D", x"01AB", x"6CA4", x"6CAC", x"0100", x"6CA4", x"B0E1",
   x"01FF", x"B07D", x"1F00", x"0103", x"E0E0", x"3C66", x"0103", x"B0E0",
   x"6CBD", x"0100", x"B07D", x"0102", x"6CA4", x"6CAC", x"70E1", x"6CA4",
   x"70E2", x"6CA4", x"70E3", x"6CA4", x"70E4", x"6CA4", x"1F00", x"6CBD",
   x"0100", x"B07D", x"01D8", x"6CA4", x"6CAC", x"01FF", x"6C87", x"0101",
   x"B0E0", x"1F00", x"0103", x"E0E0", x"3C82", x"01FF", x"B07D", x"0101",
   x"B0E0", x"1F00", x"0101", x"6C87", x"0101", x"B0E0", x"1F00", x"B0EA",
   x"010A", x"B0EB", x"01FF", x"B07D", x"6CE8", x"6CB3", x"A0C2", x"3C9E",
   x"0000", x"0101", x"6CCD", x"01FF", x"C8EB", x"2C8D", x"0000", x"0000",
   x"01FF", x"C8EA", x"2C8D", x"0000", x"0000", x"1CA1", x"6CC5", x"0000",
   x"1F00", x"0104", x"8881", x"1F00", x"B07E", x"0000", x"0102", x"A07D",
   x"2CA5", x"707E", x"B0E5", x"1F00", x"70E8", x"6CA4", x"70E7", x"6CA4",
   x"70E6", x"6CA4", x"1F00", x"0100", x"B07D", x"0105", x"6CA4", x"0100",
   x"6CA4", x"01FF", x"B07D", x"70E5", x"1F00", x"0100", x"B07D", x"0106",
   x"6CA4", x"0101", x"B07D", x"6CE8", x"1F00", x"0100", x"B07D", x"0104",
   x"6CA4", x"0101", x"B07D", x"6CE8", x"1F00", x"B0EC", x"0132", x"B0ED",
   x"01C8", x"B0EE", x"0000", x"0000", x"0000", x"01FF", x"C8EE", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"2CD5", x"01FF",
   x"C8ED", x"2CD0", x"01FF", x"C8EC", x"2CCE", x"0000", x"0000", x"1F00",
   x"010C", x"B0ED", x"0000", x"0000", x"01FF", x"C8ED", x"0000", x"0000",
   x"0000", x"2CEC", x"0000", x"0000", x"1F00", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"CDAB"
);

signal daddr: std_logic_vector(11 downto 0);

begin
   assremote: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (we = '1') then
            RAM(conv_integer(addr)) <= din;
         end if;
         daddr <= addr;
      end if; -- clk 
   end process;

   dout <= RAM(conv_integer(daddr));
end;
