library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

-- Created from ssremote.bin
-- On 8/ 1/2019

entity ssremote_7i90 is
	port (
	addr: in std_logic_vector(10 downto 0);
	clk: in std_logic;
	din: in std_logic_vector(15 downto 0);
	dout: out std_logic_vector(15 downto 0);
	we: in std_logic);
end ssremote_7i90;

architecture syn of ssremote_7i90 is
   type ram_type is array (0 to 2047) of std_logic_vector(15 downto 0);
   signal RAM : ram_type := 
   (
   x"0000", x"0000", x"0000", x"60A2", x"01FF", x"B07B", x"7020", x"7021",
   x"E0DB", x"C0C1", x"E0DE", x"500F", x"0000", x"0000", x"607A", x"7097",
   x"3016", x"01FF", x"B079", x"0100", x"B07A", x"101B", x"0100", x"B079",
   x"70DD", x"0300", x"B07A", x"7087", x"3020", x"0000", x"0000", x"6076",
   x"011F", x"A02F", x"3006", x"0000", x"0000", x"602F", x"2006", x"0000",
   x"0000", x"6492", x"2006", x"0000", x"0000", x"605A", x"1006", x"B03C",
   x"610B", x"013F", x"A029", x"B0C5", x"B0C7", x"304E", x"B023", x"0000",
   x"7028", x"B022", x"B400", x"01FF", x"C8C5", x"0C01", x"2038", x"0000",
   x"0000", x"0101", x"B02F", x"7082", x"3050", x"70C7", x"C0C4", x"B0C7",
   x"7022", x"3050", x"0101", x"8881", x"0101", x"C883", x"01FF", x"1800",
   x"0101", x"C8CE", x"C0C1", x"0101", x"C8DC", x"0100", x"D8DD", x"0100",
   x"B03D", x"1800", x"6110", x"B023", x"70C8", x"306B", x"0101", x"B037",
   x"70C8", x"B0C5", x"7580", x"B022", x"B030", x"0D01", x"01FF", x"C8C5",
   x"2062", x"0000", x"0000", x"7082", x"3072", x"7022", x"B030", x"0101",
   x"C0C8", x"1073", x"70C8", x"3075", x"B031", x"1800", x"0100", x"B087",
   x"B097", x"1800", x"0101", x"8897", x"6080", x"6486", x"665F", x"1800",
   x"0100", x"B060", x"B061", x"B062", x"B063", x"0100", x"B068", x"0111",
   x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000", x"0104", x"B068",
   x"0111", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000", x"0108",
   x"B068", x"0111", x"B069", x"0000", x"B06D", x"0000", x"0000", x"0000",
   x"0000", x"1800", x"60AA", x"60BD", x"6108", x"612A", x"644A", x"6115",
   x"645E", x"1800", x"0100", x"B0C1", x"0101", x"B0C2", x"0102", x"B0C3",
   x"01FF", x"B0C4", x"0100", x"B0CE", x"01FF", x"B07B", x"0100", x"B079",
   x"0180", x"B0CF", x"01C1", x"B0DE", x"1800", x"0100", x"B080", x"B081",
   x"01FF", x"B082", x"0100", x"B083", x"B084", x"B085", x"B086", x"B087",
   x"B088", x"B089", x"0100", x"B08A", x"0114", x"B08B", x"0100", x"B08C",
   x"B08D", x"B08E", x"B08F", x"0137", x"B090", x"0169", x"B091", x"0139",
   x"B092", x"0130", x"B093", x"0101", x"B094", x"010E", x"B095", x"0100",
   x"B096", x"B097", x"B098", x"B099", x"B09A", x"0101", x"B09A", x"0100",
   x"B09B", x"B09C", x"B09D", x"B09E", x"015A", x"B09F", x"017F", x"B0CD",
   x"0178", x"B0D6", x"0156", x"B0D7", x"0134", x"B0D8", x"0112", x"B0D9",
   x"01A2", x"0B00", x"0107", x"0B80", x"0000", x"0000", x"0000", x"010F",
   x"B700", x"0100", x"B701", x"0101", x"B702", x"0100", x"B703", x"1800",
   x"610B", x"6110", x"1800", x"0100", x"0800", x"0101", x"0880", x"1800",
   x"0180", x"0900", x"0101", x"0980", x"1800", x"7040", x"B02A", x"B032",
   x"7041", x"B02B", x"B033", x"7042", x"B02C", x"B034", x"0100", x"B036",
   x"0101", x"B02F", x"B037", x"0140", x"B035", x"0108", x"B02D", x"708B",
   x"B02E", x"1800", x"0180", x"B220", x"0102", x"B221", x"01A0", x"B222",
   x"0102", x"B223", x"0140", x"B224", x"0105", x"B225", x"0160", x"B226",
   x"0105", x"B227", x"0180", x"B228", x"0105", x"B229", x"01A0", x"B22A",
   x"0105", x"B22B", x"01C0", x"B22C", x"0105", x"B22D", x"0100", x"B22E",
   x"B22F", x"0140", x"0B00", x"0105", x"0B80", x"0000", x"0000", x"0000",
   x"01A0", x"B700", x"0108", x"B701", x"0102", x"B702", x"0180", x"B703",
   x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A",
   x"B70B", x"018A", x"B70C", x"0107", x"B70D", x"0162", x"B70E", x"0169",
   x"B70F", x"0174", x"B710", x"0100", x"B711", x"0145", x"B712", x"016E",
   x"B713", x"0163", x"B714", x"0130", x"B715", x"016D", x"B716", x"016F",
   x"B717", x"0164", x"B718", x"0165", x"B719", x"0100", x"B71A", x"0100",
   x"B71B", x"0160", x"0B00", x"0105", x"0B80", x"0000", x"0000", x"0000",
   x"01A0", x"B700", x"0108", x"B701", x"0102", x"B702", x"0180", x"B703",
   x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A",
   x"B70B", x"018B", x"B70C", x"0107", x"B70D", x"0162", x"B70E", x"0169",
   x"B70F", x"0174", x"B710", x"0100", x"B711", x"0145", x"B712", x"016E",
   x"B713", x"0163", x"B714", x"0131", x"B715", x"016D", x"B716", x"016F",
   x"B717", x"0164", x"B718", x"0165", x"B719", x"0100", x"B71A", x"0100",
   x"B71B", x"0180", x"0B00", x"0105", x"0B80", x"0000", x"0000", x"0000",
   x"01A0", x"B700", x"0108", x"B701", x"0102", x"B702", x"0180", x"B703",
   x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A",
   x"B70B", x"018C", x"B70C", x"0107", x"B70D", x"0162", x"B70E", x"0169",
   x"B70F", x"0174", x"B710", x"0100", x"B711", x"0145", x"B712", x"016E",
   x"B713", x"0163", x"B714", x"0132", x"B715", x"016D", x"B716", x"016F",
   x"B717", x"0164", x"B718", x"0165", x"B719", x"0100", x"B71A", x"0100",
   x"B71B", x"01A0", x"0B00", x"0105", x"0B80", x"0000", x"0000", x"0000",
   x"01A0", x"B700", x"0110", x"B701", x"0102", x"B702", x"0180", x"B703",
   x"0100", x"B704", x"B705", x"B706", x"B707", x"B708", x"B709", x"B70A",
   x"B70B", x"01A2", x"B70C", x"0107", x"B70D", x"0162", x"B70E", x"0169",
   x"B70F", x"0174", x"B710", x"0100", x"B711", x"0173", x"B712", x"0177",
   x"B713", x"0172", x"B714", x"0165", x"B715", x"0176", x"B716", x"0169",
   x"B717", x"0173", x"B718", x"0169", x"B719", x"016F", x"B71A", x"016E",
   x"B71B", x"0100", x"B71C", x"0100", x"B71D", x"01C0", x"0B00", x"0105",
   x"0B80", x"0000", x"0000", x"0000", x"01A0", x"B700", x"0110", x"B701",
   x"0102", x"B702", x"0180", x"B703", x"0100", x"B704", x"B705", x"B706",
   x"B707", x"B708", x"B709", x"B70A", x"B70B", x"01A3", x"B70C", x"0107",
   x"B70D", x"0162", x"B70E", x"0169", x"B70F", x"0174", x"B710", x"0100",
   x"B711", x"0168", x"B712", x"0177", x"B713", x"0172", x"B714", x"0165",
   x"B715", x"0176", x"B716", x"0169", x"B717", x"0173", x"B718", x"0169",
   x"B719", x"016F", x"B71A", x"016E", x"B71B", x"0100", x"B71C", x"0100",
   x"B71D", x"0180", x"B200", x"0102", x"B201", x"01A0", x"B202", x"0102",
   x"B203", x"01C0", x"B204", x"0102", x"B205", x"01E0", x"B206", x"0102",
   x"B207", x"0100", x"B208", x"0103", x"B209", x"0120", x"B20A", x"0103",
   x"B20B", x"0140", x"B20C", x"0103", x"B20D", x"0160", x"B20E", x"0103",
   x"B20F", x"0180", x"B210", x"0103", x"B211", x"01A0", x"B212", x"0103",
   x"B213", x"01C0", x"B214", x"0103", x"B215", x"0100", x"B216", x"B217",
   x"01B0", x"B280", x"0100", x"B281", x"0100", x"B282", x"0100", x"B283",
   x"0173", x"B284", x"0174", x"B285", x"0161", x"B286", x"016E", x"B287",
   x"0164", x"B288", x"0161", x"B289", x"0172", x"B28A", x"0164", x"B28B",
   x"0100", x"B28C", x"01B0", x"B2A0", x"0100", x"B2A1", x"0101", x"B2A2",
   x"0100", x"B2A3", x"0173", x"B2A4", x"0174", x"B2A5", x"0161", x"B2A6",
   x"016E", x"B2A7", x"0164", x"B2A8", x"0161", x"B2A9", x"0172", x"B2AA",
   x"0164", x"B2AB", x"0100", x"B2AC", x"01A0", x"B2C0", x"0118", x"B2C1",
   x"0101", x"B2C2", x"0100", x"B2C3", x"0100", x"B2C4", x"B2C5", x"B2C6",
   x"B2C7", x"B2C8", x"B2C9", x"B2CA", x"B2CB", x"018F", x"B2CC", x"0107",
   x"B2CD", x"0162", x"B2CE", x"0169", x"B2CF", x"0174", x"B2D0", x"0100",
   x"B2D1", x"0150", x"B2D2", x"0131", x"B2D3", x"012D", x"B2D4", x"0149",
   x"B2D5", x"016E", x"B2D6", x"0100", x"B2D7", x"01A0", x"B2E0", x"0118",
   x"B2E1", x"0101", x"B2E2", x"0100", x"B2E3", x"0100", x"B2E4", x"B2E5",
   x"B2E6", x"B2E7", x"B2E8", x"B2E9", x"B2EA", x"B2EB", x"0192", x"B2EC",
   x"0107", x"B2ED", x"0162", x"B2EE", x"0169", x"B2EF", x"0174", x"B2F0",
   x"0100", x"B2F1", x"0150", x"B2F2", x"0132", x"B2F3", x"012D", x"B2F4",
   x"0149", x"B2F5", x"016E", x"B2F6", x"0100", x"B2F7", x"01A0", x"B300",
   x"0118", x"B301", x"0101", x"B302", x"0100", x"B303", x"0100", x"B304",
   x"B305", x"B306", x"B307", x"B308", x"B309", x"B30A", x"B30B", x"0196",
   x"B30C", x"0107", x"B30D", x"0162", x"B30E", x"0169", x"B30F", x"0174",
   x"B310", x"0100", x"B311", x"0150", x"B312", x"0133", x"B313", x"012D",
   x"B314", x"0149", x"B315", x"016E", x"B316", x"0100", x"B317", x"01A0",
   x"B320", x"0118", x"B321", x"0101", x"B322", x"0180", x"B323", x"0100",
   x"B324", x"B325", x"B326", x"B327", x"B328", x"B329", x"B32A", x"B32B",
   x"0199", x"B32C", x"0107", x"B32D", x"0162", x"B32E", x"0169", x"B32F",
   x"0174", x"B330", x"0100", x"B331", x"0150", x"B332", x"0131", x"B333",
   x"012D", x"B334", x"014F", x"B335", x"0175", x"B336", x"0174", x"B337",
   x"0100", x"B338", x"01A0", x"B340", x"0118", x"B341", x"0101", x"B342",
   x"0180", x"B343", x"0100", x"B344", x"B345", x"B346", x"B347", x"B348",
   x"B349", x"B34A", x"B34B", x"019C", x"B34C", x"0107", x"B34D", x"0162",
   x"B34E", x"0169", x"B34F", x"0174", x"B350", x"0100", x"B351", x"0150",
   x"B352", x"0132", x"B353", x"012D", x"B354", x"014F", x"B355", x"0175",
   x"B356", x"0174", x"B357", x"0100", x"B358", x"01A0", x"B360", x"0118",
   x"B361", x"0101", x"B362", x"0180", x"B363", x"0100", x"B364", x"B365",
   x"B366", x"B367", x"B368", x"B369", x"B36A", x"B36B", x"019F", x"B36C",
   x"0107", x"B36D", x"0162", x"B36E", x"0169", x"B36F", x"0174", x"B370",
   x"0100", x"B371", x"0150", x"B372", x"0133", x"B373", x"012D", x"B374",
   x"014F", x"B375", x"0175", x"B376", x"0174", x"B377", x"0100", x"B378",
   x"01A0", x"B380", x"0108", x"B381", x"0108", x"B382", x"0100", x"B383",
   x"0100", x"B384", x"B385", x"B386", x"B387", x"B388", x"B389", x"B38A",
   x"B38B", x"0186", x"B38C", x"0107", x"B38D", x"0163", x"B38E", x"016F",
   x"B38F", x"0175", x"B390", x"016E", x"B391", x"0174", x"B392", x"0100",
   x"B393", x"0165", x"B394", x"016E", x"B395", x"0163", x"B396", x"0130",
   x"B397", x"0100", x"B398", x"01A0", x"B3A0", x"0108", x"B3A1", x"0108",
   x"B3A2", x"0100", x"B3A3", x"0100", x"B3A4", x"B3A5", x"B306", x"B3A7",
   x"B3A8", x"B3A9", x"B3AA", x"B3AB", x"0187", x"B3AC", x"0107", x"B3AD",
   x"0163", x"B3AE", x"016F", x"B3AF", x"0175", x"B3B0", x"016E", x"B3B1",
   x"0174", x"B3B2", x"0100", x"B3B3", x"0145", x"B3B4", x"016E", x"B3B5",
   x"0163", x"B3B6", x"0131", x"B3B7", x"0100", x"B3B8", x"01A0", x"B3C0",
   x"0108", x"B3C1", x"0108", x"B3C2", x"0100", x"B3C3", x"0100", x"B3C4",
   x"B3C5", x"B3C6", x"B3C7", x"B3C8", x"B3C9", x"B3CA", x"B3CB", x"0188",
   x"B3CC", x"0107", x"B3CD", x"0163", x"B3CE", x"016F", x"B3CF", x"0175",
   x"B3D0", x"016E", x"B3D1", x"0174", x"B3D2", x"0100", x"B3D3", x"0145",
   x"B3D4", x"016E", x"B3D5", x"0163", x"B3D6", x"0132", x"B3D7", x"0100",
   x"B3D8", x"1800", x"0100", x"E086", x"3450", x"0101", x"E086", x"345D",
   x"0100", x"B0D4", x"0102", x"B0D5", x"0120", x"B0D2", x"0102", x"B0D3",
   x"010D", x"B0D0", x"0109", x"B0D1", x"1800", x"1800", x"6080", x"6461",
   x"1800", x"0120", x"B060", x"0186", x"B061", x"0100", x"B062", x"0105",
   x"B063", x"0100", x"B068", x"0185", x"B069", x"0000", x"B06D", x"0000",
   x"0000", x"0000", x"0000", x"0100", x"B060", x"01FF", x"B061", x"0100",
   x"B062", x"0100", x"B063", x"0100", x"B068", x"0186", x"B069", x"0000",
   x"B06D", x"0000", x"0000", x"0000", x"0000", x"1800", x"018A", x"0B00",
   x"0107", x"0B80", x"0100", x"0000", x"0000", x"B700", x"B701", x"B702",
   x"B703", x"1800", x"6108", x"7400", x"B0C9", x"01C0", x"A400", x"B0CA",
   x"0C01", x"3658", x"0140", x"E0CA", x"24A5", x"0104", x"A0C9", x"34A5",
   x"7400", x"B098", x"7401", x"B099", x"0C02", x"01C0", x"E0CA", x"355A",
   x"0180", x"E0CA", x"35A8", x"0103", x"A0C9", x"B0CB", x"01EE", x"E08C",
   x"B0CC", x"0120", x"A0C9", x"350B", x"70CC", x"34F7", x"0101", x"E099",
   x"4653", x"0107", x"E099", x"5653", x"7098", x"0A00", x"7099", x"0A80",
   x"0103", x"E0CB", x"34E3", x"0102", x"E0CB", x"34D7", x"0101", x"E0CB",
   x"34CF", x"7400", x"B600", x"7001", x"B09A", x"0C01", x"1638", x"7400",
   x"B600", x"7401", x"B601", x"7002", x"B09A", x"0C02", x"1638", x"7400",
   x"B600", x"7401", x"B601", x"7402", x"B602", x"7403", x"B603", x"7004",
   x"B09A", x"0C04", x"1638", x"7400", x"B600", x"7401", x"B601", x"7402",
   x"B602", x"7403", x"B603", x"7404", x"B604", x"7405", x"B605", x"7406",
   x"B606", x"7407", x"B607", x"0108", x"B09A", x"0C08", x"1638", x"0102",
   x"E0CB", x"2658", x"7098", x"B068", x"7099", x"B069", x"7400", x"B060",
   x"7401", x"B061", x"7402", x"B062", x"7403", x"B063", x"B06D", x"7004",
   x"B09A", x"0C04", x"1639", x"70CC", x"354E", x"0101", x"E099", x"4653",
   x"0107", x"E099", x"5653", x"7098", x"0A00", x"7099", x"0A80", x"0103",
   x"E0CB", x"353A", x"0102", x"E0CB", x"352E", x"0101", x"E0CB", x"3526",
   x"7600", x"B580", x"0101", x"B09A", x"0D01", x"1639", x"7600", x"B580",
   x"7601", x"B581", x"0102", x"B09A", x"0D02", x"1639", x"7600", x"B580",
   x"7601", x"B581", x"7602", x"B582", x"7603", x"B583", x"0104", x"B09A",
   x"0D04", x"1639", x"7600", x"B580", x"7601", x"B581", x"7602", x"B582",
   x"7603", x"B583", x"7604", x"B584", x"7605", x"B585", x"7606", x"B586",
   x"7607", x"B587", x"0108", x"B09A", x"0D08", x"1639", x"7098", x"B068",
   x"7099", x"B069", x"B06C", x"0102", x"E0CB", x"2658", x"0104", x"B09A",
   x"0D04", x"1639", x"011F", x"A0C9", x"C0CF", x"0A00", x"0100", x"0A80",
   x"0120", x"A0C9", x"35A4", x"0110", x"A0C9", x"2572", x"7400", x"B600",
   x"0C01", x"01EB", x"E0C9", x"356F", x"0000", x"0000", x"1642", x"708B",
   x"B02E", x"1642", x"01F7", x"E0C9", x"3586", x"01F8", x"E0C9", x"358A",
   x"01F9", x"E0C9", x"358E", x"01FA", x"E0C9", x"3592", x"01FE", x"E0C9",
   x"3599", x"01FF", x"E0C9", x"35A1", x"0C01", x"1642", x"7400", x"B097",
   x"0C01", x"1642", x"7400", x"B098", x"0C01", x"1642", x"7400", x"B099",
   x"0C01", x"1642", x"C0C1", x"7400", x"C898", x"0100", x"D899", x"0C01",
   x"1642", x"7400", x"E09F", x"259F", x"0000", x"0000", x"1000", x"0C01",
   x"1642", x"6108", x"0100", x"1800", x"7600", x"B580", x"0D01", x"1642",
   x"01BD", x"E0C9", x"35B4", x"01BC", x"E0C9", x"361F", x"01BB", x"E0C9",
   x"3629", x"0000", x"0000", x"1642", x"0100", x"B068", x"0110", x"B069",
   x"B06C", x"0000", x"0000", x"7097", x"B580", x"7060", x"90C4", x"B581",
   x"7061", x"90C4", x"B582", x"7062", x"90C4", x"B583", x"0104", x"B068",
   x"0110", x"B069", x"B06C", x"0000", x"0000", x"0000", x"0000", x"7060",
   x"90C4", x"B584", x"7061", x"90C4", x"B585", x"7062", x"90C4", x"B586",
   x"0108", x"B068", x"0110", x"B069", x"B06C", x"0000", x"0000", x"0000",
   x"0000", x"7060", x"90C4", x"B587", x"7061", x"90C4", x"B588", x"7062",
   x"90C4", x"B589", x"0100", x"B068", x"0189", x"B069", x"B06C", x"0000",
   x"0000", x"0000", x"0000", x"7060", x"B58A", x"7061", x"B58B", x"7062",
   x"B58C", x"0D0D", x"7097", x"261D", x"0100", x"B068", x"0111", x"B069",
   x"7400", x"B060", x"7401", x"B061", x"7402", x"B062", x"B06D", x"0104",
   x"B068", x"0111", x"B069", x"7403", x"B060", x"7404", x"B061", x"7405",
   x"B062", x"B06D", x"0108", x"B068", x"0111", x"B069", x"7406", x"B060",
   x"7407", x"B061", x"7408", x"B062", x"B06D", x"0C09", x"1642", x"70D6",
   x"B580", x"70D7", x"B581", x"70D8", x"B582", x"70D9", x"B583", x"0D04",
   x"1642", x"644A", x"70D0", x"B580", x"70D1", x"B581", x"70D4", x"B582",
   x"70D5", x"B583", x"70D2", x"B584", x"70D3", x"B585", x"0D06", x"1642",
   x"665F", x"0108", x"A0C9", x"3642", x"C0C1", x"709A", x"C898", x"0100",
   x"D899", x"1642", x"0500", x"A0CD", x"B0C8", x"0580", x"E0C2", x"2656",
   x"0140", x"C0C1", x"E0C8", x"5656", x"0400", x"E0C7", x"5493", x"0000",
   x"665A", x"0100", x"1800", x"0120", x"8881", x"1658", x"0110", x"8881",
   x"01FF", x"1800", x"7020", x"B0DA", x"7021", x"B0DB", x"1800", x"018A",
   x"0B00", x"0107", x"0B80", x"0100", x"B068", x"0189", x"B069", x"7700",
   x"B060", x"7701", x"B061", x"7702", x"B062", x"7703", x"B063", x"B06D",
   x"1800", x"0100", x"B068", x"0111", x"B069", x"01FF", x"B060", x"B061",
   x"B062", x"B063", x"0000", x"0000", x"B06D", x"B0C6", x"0100", x"B068",
   x"0110", x"B069", x"70C6", x"B060", x"0100", x"B061", x"B062", x"B063",
   x"B06D", x"70C6", x"1800", x"0B00", x"0100", x"0B80", x"0100", x"B068",
   x"0110", x"B069", x"7700", x"B060", x"7701", x"B061", x"7702", x"B062",
   x"0100", x"B063", x"B06D", x"1800", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"CDAB"
);

signal daddr: std_logic_vector(10 downto 0);

begin
   assremote: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (we = '1') then
            RAM(conv_integer(addr)) <= din;
         end if;
         daddr <= addr;
      end if; -- clk 
   end process;

   dout <= RAM(conv_integer(daddr));
end;
