library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

-- Created from ssremote.bin
-- On 7/11/2014

entity ssremote is
	port (
	addr: in std_logic_vector(10 downto 0);
	clk: in std_logic;
	din: in std_logic_vector(15 downto 0);
	dout: out std_logic_vector(15 downto 0);
	we: in std_logic);
end ssremote;

architecture syn of ssremote is
   type ram_type is array (0 to 2047) of std_logic_vector(15 downto 0);
   signal RAM : ram_type := 
   (
   x"0000", x"0000", x"0000", x"609C", x"01FF", x"B07B", x"7020", x"7021",
   x"E0DB", x"C0C1", x"E0DE", x"500F", x"0000", x"0000", x"6079", x"7097",
   x"3016", x"01FF", x"B079", x"0100", x"B07A", x"101B", x"0100", x"B079",
   x"70DD", x"0300", x"B07A", x"7087", x"3020", x"0000", x"0000", x"6075",
   x"011F", x"A02F", x"3006", x"0000", x"0000", x"602F", x"2006", x"0000",
   x"0000", x"627C", x"2006", x"0000", x"0000", x"6059", x"1006", x"60F5",
   x"013F", x"A029", x"B0C5", x"B0C7", x"304E", x"B023", x"0000", x"60F5",
   x"7028", x"B022", x"B400", x"01FF", x"C8C5", x"0C01", x"2038", x"0000",
   x"0000", x"0101", x"B02F", x"7082", x"3050", x"70C7", x"C0C4", x"B0C7",
   x"7022", x"3050", x"0101", x"8881", x"0101", x"C883", x"01FF", x"1800",
   x"0101", x"C8CE", x"C0C1", x"0101", x"C8DC", x"0100", x"D8DD", x"0100",
   x"1800", x"60FA", x"B023", x"70C8", x"306A", x"0101", x"B037", x"70C8",
   x"B0C5", x"7580", x"B022", x"B030", x"0D01", x"01FF", x"C8C5", x"2061",
   x"0000", x"0000", x"7082", x"3071", x"7022", x"B030", x"0101", x"C0C8",
   x"1072", x"70C8", x"3074", x"B031", x"1800", x"0100", x"B087", x"B097",
   x"1800", x"0101", x"8897", x"0100", x"607E", x"1800", x"B060", x"B061",
   x"B062", x"B063", x"0100", x"B068", x"0111", x"B069", x"0000", x"B06D",
   x"0000", x"0000", x"0000", x"0104", x"B068", x"0111", x"B069", x"0000",
   x"B06D", x"0000", x"0000", x"0000", x"0000", x"0108", x"B068", x"0111",
   x"B069", x"0000", x"B06D", x"1800", x"60A3", x"60B6", x"60F2", x"6114",
   x"6268", x"60FF", x"1800", x"0100", x"B0C1", x"0101", x"B0C2", x"0102",
   x"B0C3", x"01FF", x"B0C4", x"0100", x"B0CE", x"01FF", x"B07B", x"0100",
   x"B079", x"0180", x"B0CF", x"01C1", x"B0DE", x"1800", x"0100", x"B080",
   x"B081", x"01FF", x"B082", x"0100", x"B083", x"B084", x"B085", x"B086",
   x"B087", x"B088", x"B089", x"0100", x"B08A", x"0114", x"B08B", x"0100",
   x"B08C", x"B08D", x"B08E", x"B08F", x"0137", x"B090", x"0149", x"B091",
   x"0139", x"B092", x"0130", x"B093", x"0101", x"B094", x"010E", x"B095",
   x"0100", x"B096", x"B097", x"B098", x"B099", x"B09A", x"0101", x"B09A",
   x"0100", x"B09B", x"B09C", x"B09D", x"B09E", x"015A", x"B09F", x"017F",
   x"B0CD", x"0178", x"B0D6", x"0156", x"B0D7", x"0134", x"B0D8", x"0112",
   x"B0D9", x"1800", x"60F5", x"60FA", x"1800", x"0100", x"0800", x"0101",
   x"0880", x"1800", x"0180", x"0900", x"0101", x"0980", x"1800", x"7040",
   x"B02A", x"B032", x"7041", x"B02B", x"B033", x"7042", x"B02C", x"B034",
   x"0100", x"B036", x"0101", x"B02F", x"B037", x"0140", x"B035", x"0108",
   x"B02D", x"708B", x"B02E", x"1800", x"0180", x"B200", x"0102", x"B201",
   x"01C0", x"B202", x"0102", x"B203", x"0100", x"B204", x"0103", x"B205",
   x"0120", x"B206", x"0103", x"B207", x"0140", x"B208", x"0103", x"B209",
   x"0160", x"B20A", x"0103", x"B20B", x"0180", x"B20C", x"0103", x"B20D",
   x"01A0", x"B20E", x"0103", x"B20F", x"0100", x"B210", x"B211", x"01B0",
   x"B280", x"0100", x"B281", x"0100", x"B282", x"0100", x"B283", x"0173",
   x"B284", x"0174", x"B285", x"0161", x"B286", x"016E", x"B287", x"0164",
   x"B288", x"0161", x"B289", x"0172", x"B28A", x"0164", x"B28B", x"0100",
   x"B28C", x"01B0", x"B2C0", x"0100", x"B2C1", x"0101", x"B2C2", x"0100",
   x"B2C3", x"0173", x"B2C4", x"0174", x"B2C5", x"0161", x"B2C6", x"016E",
   x"B2C7", x"0164", x"B2C8", x"0161", x"B2C9", x"0172", x"B2CA", x"0164",
   x"B2CB", x"0100", x"B2CC", x"01A0", x"B300", x"0118", x"B301", x"0101",
   x"B302", x"0100", x"B303", x"0100", x"B304", x"B305", x"B306", x"B307",
   x"B308", x"B309", x"B30A", x"B30B", x"0100", x"B30C", x"0106", x"B30D",
   x"0162", x"B30E", x"0169", x"B30F", x"0174", x"B310", x"0100", x"B311",
   x"0150", x"B312", x"0131", x"B313", x"012D", x"B314", x"0149", x"B315",
   x"016E", x"B316", x"0100", x"B317", x"01A0", x"B320", x"0118", x"B321",
   x"0101", x"B322", x"0100", x"B323", x"0100", x"B324", x"B325", x"B326",
   x"B327", x"B328", x"B329", x"B32A", x"B32B", x"0103", x"B32C", x"0106",
   x"B32D", x"0162", x"B32E", x"0169", x"B32F", x"0174", x"B330", x"0100",
   x"B331", x"0150", x"B332", x"0132", x"B333", x"012D", x"B334", x"0149",
   x"B335", x"016E", x"B336", x"0100", x"B337", x"01A0", x"B340", x"0118",
   x"B341", x"0101", x"B342", x"0100", x"B343", x"0100", x"B344", x"B345",
   x"B346", x"B347", x"B348", x"B349", x"B34A", x"B34B", x"0106", x"B34C",
   x"0106", x"B34D", x"0162", x"B34E", x"0169", x"B34F", x"0174", x"B350",
   x"0100", x"B351", x"0150", x"B352", x"0133", x"B353", x"012D", x"B354",
   x"0149", x"B355", x"016E", x"B356", x"0100", x"B357", x"01A0", x"B360",
   x"0118", x"B361", x"0101", x"B362", x"0180", x"B363", x"0100", x"B364",
   x"B365", x"B366", x"B367", x"B368", x"B369", x"B36A", x"B36B", x"0110",
   x"B36C", x"0106", x"B36D", x"0162", x"B36E", x"0169", x"B36F", x"0174",
   x"B370", x"0100", x"B371", x"0150", x"B372", x"0131", x"B373", x"012D",
   x"B374", x"014F", x"B375", x"0175", x"B376", x"0174", x"B377", x"0100",
   x"B378", x"01A0", x"B380", x"0118", x"B381", x"0101", x"B382", x"0180",
   x"B383", x"0100", x"B384", x"B385", x"B386", x"B387", x"B388", x"B389",
   x"B38A", x"B38B", x"0113", x"B38C", x"0106", x"B38D", x"0162", x"B38E",
   x"0169", x"B38F", x"0174", x"B390", x"0100", x"B391", x"0150", x"B392",
   x"0132", x"B393", x"012D", x"B394", x"014F", x"B395", x"0175", x"B396",
   x"0174", x"B397", x"0100", x"B398", x"01A0", x"B3A0", x"0118", x"B3A1",
   x"0101", x"B3A2", x"0180", x"B3A3", x"0100", x"B3A4", x"B3A5", x"B3A6",
   x"B3A7", x"B3A8", x"B3A9", x"B3AA", x"B3AB", x"0116", x"B3AC", x"0106",
   x"B3AD", x"0162", x"B3AE", x"0169", x"B3AF", x"0174", x"B3B0", x"0100",
   x"B3B1", x"0150", x"B3B2", x"0133", x"B3B3", x"012D", x"B3B4", x"014F",
   x"B3B5", x"0175", x"B3B6", x"0174", x"B3B7", x"0100", x"B3B8", x"1800",
   x"0100", x"E086", x"326E", x"0101", x"E086", x"327B", x"0100", x"B0D4",
   x"0102", x"B0D5", x"0120", x"B0D2", x"0102", x"B0D3", x"010A", x"B0D0",
   x"0109", x"B0D1", x"1800", x"1800", x"60F2", x"7400", x"B0C9", x"01C0",
   x"A400", x"B0CA", x"0C01", x"3431", x"0140", x"E0CA", x"228F", x"0104",
   x"A0C9", x"328F", x"7400", x"B098", x"7401", x"B099", x"0C02", x"01C0",
   x"E0CA", x"3344", x"0180", x"E0CA", x"3392", x"0103", x"A0C9", x"B0CB",
   x"01EE", x"E08C", x"B0CC", x"0120", x"A0C9", x"32F5", x"70CC", x"32E1",
   x"0101", x"E099", x"442C", x"0107", x"E099", x"542C", x"7098", x"0A00",
   x"7099", x"0A80", x"0103", x"E0CB", x"32CD", x"0102", x"E0CB", x"32C1",
   x"0101", x"E0CB", x"32B9", x"7400", x"B600", x"7001", x"B09A", x"0C01",
   x"1412", x"7400", x"B600", x"7401", x"B601", x"7002", x"B09A", x"0C02",
   x"1412", x"7400", x"B600", x"7401", x"B601", x"7402", x"B602", x"7403",
   x"B603", x"7004", x"B09A", x"0C04", x"1412", x"7400", x"B600", x"7401",
   x"B601", x"7402", x"B602", x"7403", x"B603", x"7404", x"B604", x"7405",
   x"B605", x"7406", x"B606", x"7407", x"B607", x"0108", x"B09A", x"0C08",
   x"1412", x"0102", x"E0CB", x"2431", x"7098", x"B068", x"7099", x"B069",
   x"7400", x"B060", x"7401", x"B061", x"7402", x"B062", x"7403", x"B063",
   x"B06D", x"7004", x"B09A", x"0C04", x"1412", x"70CC", x"3338", x"0101",
   x"E099", x"442C", x"0107", x"E099", x"542C", x"7098", x"0A00", x"7099",
   x"0A80", x"0103", x"E0CB", x"3324", x"0102", x"E0CB", x"3318", x"0101",
   x"E0CB", x"3310", x"7600", x"B580", x"0101", x"B09A", x"0D01", x"1412",
   x"7600", x"B580", x"7601", x"B581", x"0102", x"B09A", x"0D02", x"1412",
   x"7600", x"B580", x"7601", x"B581", x"7602", x"B582", x"7603", x"B583",
   x"0104", x"B09A", x"0D04", x"1412", x"7600", x"B580", x"7601", x"B581",
   x"7602", x"B582", x"7603", x"B583", x"7604", x"B584", x"7605", x"B585",
   x"7606", x"B586", x"7607", x"B587", x"0108", x"B09A", x"0D08", x"1412",
   x"7098", x"B068", x"7099", x"B069", x"B06C", x"0102", x"E0CB", x"2431",
   x"0104", x"B09A", x"0D04", x"1412", x"011F", x"A0C9", x"C0CF", x"0A00",
   x"0100", x"0A80", x"0120", x"A0C9", x"338E", x"0110", x"A0C9", x"235C",
   x"7400", x"B600", x"0C01", x"01EB", x"E0C9", x"3359", x"0000", x"0000",
   x"141B", x"708B", x"B02E", x"141B", x"01F7", x"E0C9", x"3370", x"01F8",
   x"E0C9", x"3374", x"01F9", x"E0C9", x"3378", x"01FA", x"E0C9", x"337C",
   x"01FE", x"E0C9", x"3383", x"01FF", x"E0C9", x"338B", x"0C01", x"141B",
   x"7400", x"B097", x"0C01", x"141B", x"7400", x"B098", x"0C01", x"141B",
   x"7400", x"B099", x"0C01", x"141B", x"C0C1", x"7400", x"C898", x"0100",
   x"D899", x"0C01", x"141B", x"7400", x"E09F", x"2389", x"0000", x"0000",
   x"1000", x"0C01", x"141B", x"60F2", x"0100", x"1800", x"7600", x"B580",
   x"0D01", x"141B", x"01BD", x"E0C9", x"339E", x"01BC", x"E0C9", x"33FA",
   x"01BB", x"E0C9", x"3404", x"0000", x"0000", x"141B", x"0100", x"B068",
   x"0110", x"B069", x"B06C", x"0000", x"0000", x"7097", x"B580", x"7060",
   x"90C4", x"B581", x"7061", x"90C4", x"B582", x"7062", x"90C4", x"B583",
   x"0104", x"B068", x"0110", x"B069", x"B06C", x"0000", x"0000", x"0000",
   x"0000", x"7060", x"90C4", x"B584", x"7061", x"90C4", x"B585", x"7062",
   x"90C4", x"B586", x"0108", x"B068", x"0110", x"B069", x"B06C", x"0000",
   x"0000", x"0000", x"0000", x"7060", x"90C4", x"B587", x"7061", x"90C4",
   x"B588", x"7062", x"90C4", x"B589", x"0D0A", x"7097", x"23F8", x"0100",
   x"B068", x"0111", x"B069", x"7400", x"B060", x"7401", x"B061", x"7402",
   x"B062", x"B06D", x"0104", x"B068", x"0111", x"B069", x"7403", x"B060",
   x"7404", x"B061", x"7405", x"B062", x"B06D", x"0108", x"B068", x"0111",
   x"B069", x"7406", x"B060", x"7407", x"B061", x"7408", x"B062", x"B06D",
   x"0C09", x"141B", x"70D6", x"B580", x"70D7", x"B581", x"70D8", x"B582",
   x"70D9", x"B583", x"0D04", x"141B", x"70D0", x"B580", x"70D1", x"B581",
   x"70D4", x"B582", x"70D5", x"B583", x"70D2", x"B584", x"70D3", x"B585",
   x"0D06", x"141B", x"0108", x"A0C9", x"341B", x"C0C1", x"709A", x"C898",
   x"0100", x"D899", x"141B", x"0500", x"A0CD", x"B0C8", x"0580", x"E0C2",
   x"242F", x"0140", x"C0C1", x"E0C8", x"542F", x"0400", x"E0C7", x"527D",
   x"0000", x"6433", x"0100", x"1800", x"0120", x"8881", x"1431", x"0110",
   x"8881", x"01FF", x"1800", x"7020", x"B0DA", x"7021", x"B0DB", x"1800",
   x"0100", x"B068", x"0111", x"B069", x"01FF", x"B060", x"B061", x"B062",
   x"B063", x"0000", x"0000", x"B06D", x"B0C6", x"0100", x"B068", x"0110",
   x"B069", x"70C6", x"B060", x"0100", x"B061", x"B062", x"B063", x"B06D",
   x"70C6", x"1800", x"0B00", x"0100", x"0B80", x"0100", x"B068", x"0110",
   x"B069", x"7700", x"B060", x"7701", x"B061", x"7702", x"B062", x"0100",
   x"B063", x"B06D", x"1800", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"CDAB"
);

signal daddr: std_logic_vector(10 downto 0);

begin
   assremote: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (we = '1') then
            RAM(conv_integer(addr)) <= din;
         end if;
         daddr <= addr;
      end if; -- clk 
   end process;

   dout <= RAM(conv_integer(daddr));
end;
