library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

-- Created from sslbp.bin
-- On 12/23/2019

entity sslbpb is
	port (
	addra: in std_logic_vector(11 downto 0);
	addrb: in std_logic_vector(11 downto 0);
	clk: in std_logic;
	dina: in std_logic_vector(15 downto 0);
	douta: out std_logic_vector(15 downto 0);
	doutb: out std_logic_vector(15 downto 0);
	wea: in std_logic);
end sslbpb;

architecture syn of sslbpb is
   type ram_type is array (0 to 4095) of std_logic_vector(15 downto 0);
   signal RAM : ram_type := 
   (
   x"0000", x"0000", x"0000", x"0100", x"0800", x"0880", x"0100", x"B400",
   x"0C01", x"0480", x"0300", x"4006", x"B203", x"0101", x"B02A", x"01FF",
   x"B02C", x"7234", x"B008", x"0138", x"B009", x"0149", x"B00A", x"0132",
   x"B00B", x"0130", x"B00C", x"0137", x"B00D", x"0149", x"B00E", x"0136",
   x"B00F", x"0134", x"B010", x"0112", x"B000", x"0101", x"B002", x"012E",
   x"B003", x"0108", x"B001", x"0100", x"B004", x"0104", x"B005", x"0140",
   x"B006", x"01D8", x"B007", x"0100", x"0800", x"0104", x"0880", x"0002",
   x"7008", x"B045", x"01A0", x"B438", x"0125", x"B439", x"0126", x"B43A",
   x"0100", x"B43B", x"0C40", x"0002", x"0002", x"01FF", x"C845", x"203A",
   x"0100", x"B04F", x"B200", x"7049", x"3699", x"704F", x"8053", x"8059",
   x"3698", x"7222", x"E05D", x"B066", x"7222", x"B05D", x"0100", x"0800",
   x"0104", x"0880", x"0180", x"0A00", x"0102", x"0A80", x"0100", x"0B00",
   x"0103", x"0B80", x"0101", x"B050", x"01FE", x"B051", x"7008", x"B044",
   x"7053", x"A050", x"308D", x"01FF", x"01C1", x"B421", x"675B", x"0100",
   x"B41E", x"B41F", x"B420", x"B42B", x"B432", x"B720", x"B721", x"B722",
   x"B723", x"B740", x"B741", x"B742", x"B743", x"B760", x"B761", x"B762",
   x"B763", x"B640", x"B650", x"7051", x"A853", x"7051", x"A852", x"7050",
   x"8855", x"7050", x"8854", x"7051", x"A856", x"7052", x"A050", x"3646",
   x"0197", x"C41E", x"0D80", x"0000", x"0000", x"0000", x"1F00", x"11A3",
   x"11AC", x"11B0", x"11BC", x"11C2", x"1528", x"1530", x"11DD", x"11E5",
   x"11EC", x"11F2", x"11FA", x"120C", x"1212", x"1228", x"122E", x"1236",
   x"123E", x"1246", x"124E", x"1256", x"125E", x"1266", x"129C", x"12CE",
   x"12D9", x"12E1", x"12EB", x"12F2", x"12F8", x"132C", x"133E", x"1349",
   x"1351", x"1358", x"135E", x"1371", x"1377", x"137F", x"1394", x"13A1",
   x"13A8", x"13B2", x"13C0", x"13CA", x"13D2", x"13E4", x"13F1", x"13F8",
   x"1405", x"140C", x"1416", x"141E", x"1427", x"1431", x"1439", x"144C",
   x"145A", x"1119", x"1131", x"10DB", x"10F0", x"1164", x"1179", x"1461",
   x"14D5", x"1537", x"15E0", x"7056", x"A050", x"30EF", x"741F", x"8C20",
   x"0100", x"B41F", x"681A", x"01BD", x"683B", x"7720", x"683B", x"7721",
   x"683B", x"7722", x"683B", x"7723", x"683E", x"013D", x"B41E", x"1646",
   x"743C", x"67AA", x"3112", x"7051", x"A856", x"7400", x"B740", x"7401",
   x"B741", x"7402", x"B742", x"7403", x"B743", x"8402", x"3101", x"0101",
   x"8C21", x"7406", x"B720", x"7407", x"B721", x"7404", x"B722", x"7405",
   x"B723", x"741F", x"210D", x"7051", x"A857", x"7051", x"A858", x"013C",
   x"B41E", x"1118", x"67F7", x"5118", x"7051", x"A856", x"013C", x"B41E",
   x"1646", x"741F", x"8C20", x"0100", x"B41F", x"7050", x"8859", x"681A",
   x"01BD", x"683B", x"743D", x"B04E", x"312D", x"0003", x"0100", x"683B",
   x"01FF", x"C84E", x"2126", x"0003", x"0003", x"6840", x"013B", x"B41E",
   x"1646", x"743C", x"67AA", x"3157", x"7222", x"E42F", x"B43E", x"017F",
   x"AC21", x"7051", x"A854", x"7051", x"A855", x"7056", x"A050", x"3154",
   x"0114", x"C43E", x"B431", x"7432", x"3148", x"0142", x"B41E", x"1153",
   x"0180", x"E42B", x"214E", x"013C", x"B41E", x"1153", x"0174", x"E42B",
   x"2153", x"013E", x"B41E", x"1156", x"013A", x"B41E", x"1163", x"67F7",
   x"5163", x"7056", x"A050", x"315E", x"7051", x"A856", x"0180", x"A420",
   x"2163", x"013A", x"B41E", x"1646", x"7056", x"A050", x"3178", x"741F",
   x"8C20", x"0100", x"B41F", x"681A", x"01BD", x"683B", x"7720", x"683B",
   x"7721", x"683B", x"7722", x"683B", x"683A", x"6840", x"013F", x"B41E",
   x"1646", x"743C", x"67AA", x"319C", x"7051", x"A856", x"7400", x"B720",
   x"7401", x"B721", x"7402", x"B722", x"0108", x"A403", x"3189", x"0101",
   x"8C21", x"0100", x"B723", x"7404", x"B740", x"7405", x"B741", x"7406",
   x"B742", x"7407", x"B743", x"741F", x"2197", x"7051", x"A857", x"7051",
   x"A858", x"013E", x"B41E", x"11A2", x"67F7", x"51A2", x"7051", x"A856",
   x"013E", x"B41E", x"1646", x"675B", x"0100", x"B650", x"B640", x"0101",
   x"B41E", x"7064", x"B431", x"1646", x"6845", x"0102", x"B41E", x"1646",
   x"7222", x"E42F", x"B031", x"7223", x"F430", x"B032", x"7431", x"E031",
   x"41BB", x"0103", x"B41E", x"1646", x"681A", x"01DF", x"683E", x"0104",
   x"B41E", x"1646", x"67F7", x"51C7", x"0101", x"B41E", x"11DC", x"0101",
   x"67AA", x"31DC", x"015A", x"E400", x"21D0", x"0105", x"B41E", x"11DC",
   x"7423", x"E429", x"41D6", x"0101", x"CC23", x"11D8", x"0180", x"6869",
   x"0102", x"6869", x"0101", x"B41E", x"1646", x"681A", x"01E1", x"683B",
   x"683A", x"6840", x"0108", x"B41E", x"1646", x"67A9", x"31EA", x"0109",
   x"B41E", x"11EB", x"6806", x"1646", x"681A", x"01C1", x"683E", x"010A",
   x"B41E", x"1646", x"0101", x"67AA", x"31F8", x"010B", x"B41E", x"11F9",
   x"6806", x"1646", x"7400", x"21FF", x"010C", x"B41E", x"120B", x"0140",
   x"6869", x"7428", x"E429", x"4207", x"0101", x"CC28", x"1209", x"0180",
   x"6869", x"0101", x"B41E", x"1646", x"681A", x"01BC", x"683E", x"010D",
   x"B41E", x"1646", x"0104", x"67AA", x"3220", x"7400", x"B720", x"7401",
   x"B721", x"7402", x"B722", x"7403", x"B723", x"010E", x"B41E", x"1227",
   x"67F7", x"5227", x"010F", x"E048", x"2227", x"010E", x"B41E", x"1646",
   x"681A", x"01D0", x"683E", x"010F", x"B41E", x"1646", x"0101", x"67AA",
   x"3234", x"0110", x"B41E", x"1235", x"6806", x"1646", x"7400", x"B434",
   x"681A", x"01D1", x"683E", x"0111", x"B41E", x"1646", x"0101", x"67AA",
   x"3244", x"0112", x"B41E", x"1245", x"6806", x"1646", x"7400", x"B435",
   x"681A", x"01D2", x"683E", x"0113", x"B41E", x"1646", x"0101", x"67AA",
   x"3254", x"0114", x"B41E", x"1255", x"6806", x"1646", x"7400", x"B436",
   x"681A", x"01D3", x"683E", x"0115", x"B41E", x"1646", x"0101", x"67AA",
   x"3264", x"0116", x"B41E", x"1265", x"6806", x"1646", x"0117", x"B41E",
   x"7434", x"B740", x"7435", x"B741", x"7436", x"B742", x"7400", x"B437",
   x"B743", x"7009", x"E434", x"B030", x"0001", x"700A", x"F435", x"8830",
   x"0001", x"700B", x"F436", x"8830", x"0001", x"700C", x"F437", x"8030",
   x"229B", x"0180", x"B42B", x"0108", x"B43C", x"0104", x"B43D", x"0109",
   x"E048", x"228E", x"01BF", x"AC21", x"0127", x"B41E", x"010F", x"E048",
   x"229B", x"013E", x"AC21", x"7051", x"A854", x"7051", x"A855", x"7065",
   x"B431", x"0140", x"B41E", x"1646", x"7400", x"B437", x"700D", x"E434",
   x"B030", x"0001", x"700E", x"F435", x"8830", x"0001", x"700F", x"F436",
   x"8830", x"0001", x"7010", x"F437", x"8030", x"22C9", x"0174", x"B42B",
   x"0108", x"B43C", x"0104", x"B43D", x"0109", x"E048", x"22BB", x"01BE",
   x"AC21", x"0118", x"B41E", x"010F", x"E048", x"22C8", x"013E", x"AC21",
   x"7051", x"A854", x"7051", x"A855", x"7065", x"B431", x"0140", x"B41E",
   x"12CD", x"01FF", x"B432", x"011A", x"B41E", x"1646", x"681A", x"01BD",
   x"683B", x"683A", x"683A", x"683A", x"0108", x"683E", x"0119", x"B41E",
   x"1646", x"743C", x"67AA", x"32DF", x"013A", x"B41E", x"12E0", x"6806",
   x"1646", x"681A", x"01E6", x"683B", x"7700", x"7703", x"683B", x"6840",
   x"011B", x"B41E", x"1646", x"67A9", x"32F0", x"011C", x"B41E", x"12F1",
   x"6806", x"1646", x"681A", x"01BB", x"683E", x"011D", x"B41E", x"1646",
   x"0106", x"67AA", x"331C", x"7400", x"B43C", x"7401", x"B43D", x"7402",
   x"B760", x"7403", x"B761", x"7404", x"B762", x"7405", x"B763", x"0109",
   x"E048", x"230E", x"01BF", x"AC21", x"011E", x"B41E", x"010F", x"E048",
   x"231B", x"013E", x"AC21", x"7051", x"A854", x"7051", x"A855", x"7065",
   x"B431", x"0140", x"B41E", x"132B", x"67F7", x"532B", x"010F", x"E048",
   x"232B", x"013E", x"AC21", x"7051", x"A854", x"7051", x"A855", x"7065",
   x"B431", x"0140", x"B41E", x"1646", x"681A", x"01BD", x"683B", x"743D",
   x"B04E", x"333A", x"0003", x"0100", x"683B", x"01FF", x"C84E", x"2333",
   x"0003", x"0003", x"6840", x"011F", x"B41E", x"1646", x"743C", x"67AA",
   x"3344", x"0120", x"B41E", x"1348", x"67F7", x"5348", x"011E", x"B41E",
   x"1646", x"681A", x"01E7", x"683B", x"6838", x"6840", x"0121", x"B41E",
   x"1646", x"67A9", x"3356", x"0122", x"B41E", x"1357", x"6806", x"1646",
   x"681A", x"01C7", x"683E", x"0123", x"B41E", x"1646", x"0101", x"67AA",
   x"336F", x"7400", x"2366", x"0124", x"B41E", x"136E", x"0101", x"CC2D",
   x"236C", x"7051", x"A855", x"136E", x"0122", x"B41E", x"1370", x"6806",
   x"1646", x"681A", x"01D7", x"683E", x"0125", x"B41E", x"1646", x"0101",
   x"67AA", x"337D", x"0126", x"B41E", x"137E", x"6806", x"1646", x"7400",
   x"2386", x"01FE", x"AC21", x"013A", x"B41E", x"1393", x"B433", x"7428",
   x"E429", x"438D", x"0101", x"CC28", x"138F", x"0180", x"6869", x"0140",
   x"6869", x"0124", x"B41E", x"1646", x"681A", x"0165", x"683B", x"0154",
   x"683B", x"0108", x"683B", x"6838", x"6838", x"6840", x"0128", x"B41E",
   x"1646", x"67A9", x"33A6", x"0129", x"B41E", x"13A7", x"6806", x"1646",
   x"681A", x"0145", x"683B", x"0154", x"683B", x"0108", x"683E", x"012A",
   x"B41E", x"1646", x"0102", x"67AA", x"33BE", x"7400", x"8401", x"23BB",
   x"012B", x"B41E", x"13BD", x"0129", x"B41E", x"13BF", x"6806", x"1646",
   x"681A", x"0145", x"683B", x"0152", x"683B", x"0108", x"683E", x"012C",
   x"B41E", x"1646", x"0102", x"67AA", x"33D0", x"012D", x"B41E", x"13D1",
   x"6806", x"1646", x"7400", x"8401", x"B433", x"23D9", x"012E", x"B41E",
   x"13E3", x"7428", x"E429", x"43DF", x"0101", x"CC28", x"13E1", x"0180",
   x"6869", x"0140", x"6869", x"1646", x"681A", x"0165", x"683B", x"0160",
   x"683B", x"0108", x"683B", x"683A", x"683A", x"6840", x"012F", x"B41E",
   x"1646", x"67A9", x"33F6", x"0130", x"B41E", x"13F7", x"6806", x"1646",
   x"681A", x"0165", x"683B", x"0104", x"683B", x"0108", x"683B", x"6838",
   x"6838", x"6840", x"0131", x"B41E", x"1646", x"67A9", x"340A", x"0132",
   x"B41E", x"140B", x"6806", x"1646", x"681A", x"0145", x"683B", x"01FE",
   x"683B", x"0108", x"683E", x"0133", x"B41E", x"1646", x"0102", x"67AA",
   x"341C", x"0134", x"B41E", x"141D", x"6806", x"1646", x"7400", x"8401",
   x"2424", x"0132", x"B41E", x"1426", x"0135", x"B41E", x"1646", x"681A",
   x"0145", x"683B", x"0152", x"683B", x"0108", x"683E", x"0136", x"B41E",
   x"1646", x"0102", x"67AA", x"3437", x"0137", x"B41E", x"1438", x"6806",
   x"1646", x"7400", x"8401", x"2441", x"01FE", x"AC21", x"0138", x"B41E",
   x"144B", x"7428", x"E429", x"4447", x"0101", x"CC28", x"1449", x"0180",
   x"6869", x"0140", x"6869", x"1646", x"681A", x"0165", x"683B", x"015C",
   x"683B", x"0108", x"683B", x"01F4", x"683B", x"0101", x"683E", x"0139",
   x"B41E", x"1646", x"67A9", x"345F", x"013A", x"B41E", x"1460", x"6806",
   x"1646", x"7056", x"A050", x"34D4", x"741F", x"8C20", x"0100", x"B41F",
   x"7700", x"B04C", x"7703", x"B04B", x"7701", x"B04D", x"0140", x"A04B",
   x"2474", x"7051", x"A856", x"1646", x"681A", x"704B", x"683B", x"0103",
   x"A04B", x"B046", x"0001", x"0101", x"B047", x"7046", x"3484", x"01FF",
   x"C846", x"7047", x"C847", x"147D", x"01BF", x"E04B", x"54C6", x"0104",
   x"A04B", x"348F", x"0003", x"704C", x"683B", x"704D", x"683B", x"0120",
   x"A04B", x"34C3", x"0100", x"B42A", x"0108", x"E047", x"24A8", x"0003",
   x"7720", x"683B", x"7721", x"683B", x"7722", x"683B", x"7723", x"683B",
   x"7740", x"683B", x"7741", x"683B", x"7742", x"683B", x"7743", x"683B",
   x"0104", x"E047", x"24B4", x"0003", x"7720", x"683B", x"7721", x"683B",
   x"7722", x"683B", x"7723", x"683B", x"0102", x"E047", x"24BC", x"0003",
   x"7720", x"683B", x"7721", x"683B", x"0101", x"E047", x"24C2", x"0003",
   x"7720", x"683B", x"14C5", x"7047", x"B42A", x"14D1", x"0120", x"A04B",
   x"34CF", x"0003", x"7720", x"683B", x"0100", x"B42A", x"14D1", x"0101",
   x"B42A", x"6840", x"0141", x"B41E", x"1646", x"742A", x"67AA", x"3521",
   x"7051", x"A856", x"0108", x"E42A", x"24ED", x"7400", x"B720", x"7401",
   x"B721", x"7402", x"B722", x"7403", x"B723", x"7404", x"B740", x"7405",
   x"B741", x"7406", x"B742", x"7407", x"B743", x"0104", x"E42A", x"24FD",
   x"7400", x"B720", x"7401", x"B721", x"7402", x"B722", x"7403", x"B723",
   x"0100", x"B740", x"B741", x"B742", x"B743", x"0102", x"E42A", x"250B",
   x"7400", x"B720", x"7401", x"B721", x"0100", x"B722", x"B723", x"B740",
   x"B741", x"B742", x"B743", x"0101", x"E42A", x"2518", x"7400", x"B720",
   x"0100", x"B721", x"B722", x"B723", x"B740", x"B741", x"B742", x"B743",
   x"741F", x"251C", x"7051", x"A857", x"7051", x"A858", x"0140", x"B41E",
   x"1527", x"67F7", x"5527", x"7051", x"A856", x"0140", x"B41E", x"1646",
   x"681A", x"01EB", x"683B", x"0128", x"683E", x"0106", x"B41E", x"1646",
   x"67A9", x"3535", x"0107", x"B41E", x"1536", x"6806", x"1646", x"7056",
   x"A050", x"35DF", x"741F", x"8C20", x"0100", x"B41F", x"743D", x"902C",
   x"0900", x"681A", x"01BD", x"683B", x"743D", x"35DC", x"0D02", x"7720",
   x"683B", x"0500", x"35DC", x"0D01", x"7721", x"683B", x"0500", x"35DC",
   x"0D01", x"7722", x"683B", x"0500", x"35DC", x"0D01", x"7723", x"683B",
   x"0500", x"35DC", x"0D01", x"7740", x"683B", x"0500", x"35DC", x"0D01",
   x"7741", x"683B", x"0500", x"35DC", x"0D01", x"7742", x"683B", x"0500",
   x"35DC", x"0D01", x"7743", x"683B", x"0500", x"35DC", x"0D01", x"7760",
   x"683B", x"0500", x"35DC", x"0D01", x"7761", x"683B", x"0500", x"35DC",
   x"0D01", x"7762", x"683B", x"0500", x"35DC", x"0D01", x"7763", x"683B",
   x"0500", x"35DC", x"0700", x"B067", x"0780", x"B068", x"0000", x"0000",
   x"0F40", x"0F40", x"0D01", x"7700", x"683B", x"0500", x"35DC", x"0D01",
   x"7701", x"683B", x"0500", x"35DC", x"0D01", x"7702", x"683B", x"0500",
   x"35DC", x"0D01", x"7703", x"683B", x"0500", x"35DC", x"0D01", x"7720",
   x"683B", x"0500", x"35DC", x"0D01", x"7721", x"683B", x"0500", x"35DC",
   x"0D01", x"7722", x"683B", x"0500", x"35DC", x"0D01", x"7723", x"683B",
   x"0500", x"35DC", x"0D01", x"7740", x"683B", x"0500", x"35DC", x"0D01",
   x"7741", x"683B", x"0500", x"35DC", x"0D01", x"7742", x"683B", x"0500",
   x"35DC", x"0D01", x"7743", x"683B", x"0500", x"35DC", x"0D01", x"7760",
   x"683B", x"0500", x"35DC", x"0D01", x"7761", x"683B", x"0500", x"35DC",
   x"0D01", x"7762", x"683B", x"0500", x"35DC", x"0003", x"7763", x"683B",
   x"7067", x"0B00", x"7068", x"0B80", x"6840", x"0143", x"B41E", x"1646",
   x"743C", x"67AA", x"363F", x"7051", x"A856", x"7400", x"B433", x"35ED",
   x"0101", x"8C21", x"0140", x"6869", x"15EF", x"01BF", x"AC21", x"7401",
   x"B720", x"7402", x"B721", x"7403", x"B722", x"7404", x"B723", x"7405",
   x"B740", x"7406", x"B741", x"7407", x"B742", x"7408", x"B743", x"7409",
   x"B760", x"740A", x"B761", x"740B", x"B762", x"740C", x"B763", x"010D",
   x"E43C", x"4636", x"0700", x"B067", x"0780", x"B068", x"0000", x"0000",
   x"0F40", x"0F40", x"740D", x"B700", x"740E", x"B701", x"740F", x"B702",
   x"7410", x"B703", x"7411", x"B720", x"7412", x"B721", x"7413", x"B722",
   x"7414", x"B723", x"7415", x"B740", x"7416", x"B741", x"7417", x"B742",
   x"7418", x"B743", x"7419", x"B760", x"741A", x"B761", x"741B", x"B762",
   x"741C", x"B763", x"7067", x"0B00", x"7068", x"0B80", x"741F", x"263A",
   x"7051", x"A857", x"7051", x"A858", x"0142", x"B41E", x"1645", x"67F7",
   x"5645", x"7051", x"A856", x"0142", x"B41E", x"1646", x"7420", x"B700",
   x"7421", x"B701", x"741E", x"B702", x"7433", x"B703", x"0C40", x"0E01",
   x"0F04", x"7050", x"C850", x"902C", x"B051", x"01FF", x"C844", x"2068",
   x"0110", x"E04F", x"266C", x"7054", x"902C", x"A052", x"A04A", x"A056",
   x"A058", x"266C", x"7050", x"885A", x"7051", x"A859", x"7057", x"B202",
   x"0100", x"B04F", x"B200", x"0001", x"0109", x"E04F", x"267C", x"7055",
   x"A054", x"A04A", x"267C", x"7054", x"902C", x"A852", x"7054", x"B202",
   x"0100", x"B04F", x"B200", x"0001", x"010F", x"E04F", x"268C", x"7055",
   x"A054", x"A04A", x"268C", x"7054", x"902C", x"A852", x"7054", x"B202",
   x"0100", x"B04F", x"B200", x"0001", x"0108", x"E04F", x"2698", x"7200",
   x"3698", x"7053", x"B202", x"A04A", x"2698", x"0100", x"B04F", x"B200",
   x"16ED", x"0100", x"B203", x"B048", x"01AA", x"B202", x"01FF", x"B053",
   x"0101", x"B050", x"01FE", x"B051", x"0100", x"0800", x"0104", x"0880",
   x"0180", x"0A00", x"0102", x"0A80", x"0100", x"B04A", x"7008", x"B045",
   x"01FF", x"C02C", x"704A", x"0200", x"B04A", x"7050", x"C850", x"902C",
   x"B051", x"7438", x"B035", x"7439", x"B036", x"743A", x"B037", x"743B",
   x"B038", x"6766", x"6766", x"6766", x"6766", x"0100", x"B033", x"B034",
   x"B039", x"B03A", x"7230", x"B03B", x"7231", x"B03C", x"7232", x"B03D",
   x"7233", x"B03E", x"676F", x"7033", x"B610", x"7034", x"B620", x"7035",
   x"B630", x"B640", x"0100", x"B650", x"0120", x"B670", x"0C40", x"0E01",
   x"01FF", x"C845", x"26B0", x"01FF", x"B049", x"0108", x"E04F", x"26ED",
   x"7200", x"26ED", x"0100", x"B04F", x"B200", x"0101", x"A203", x"375A",
   x"704F", x"2754", x"7201", x"0980", x"B04F", x"7200", x"0900", x"B203",
   x"0110", x"A201", x"3704", x"7054", x"902C", x"A200", x"B056", x"B057",
   x"B058", x"01DE", x"AC21", x"1753", x"0109", x"E201", x"271C", x"0120",
   x"B03B", x"01A1", x"B03C", x"0107", x"B03D", x"0100", x"B03E", x"684A",
   x"01C8", x"B064", x"7201", x"B048", x"7052", x"902C", x"A200", x"B054",
   x"B055", x"7200", x"8852", x"1753", x"0108", x"E201", x"2725", x"7200",
   x"B053", x"2724", x"0100", x"B049", x"1753", x"010F", x"E201", x"273F",
   x"0188", x"B03B", x"0113", x"B03C", x"0100", x"B03D", x"0100", x"B03E",
   x"684A", x"0106", x"B064", x"01FA", x"B065", x"7201", x"B048", x"7052",
   x"902C", x"A200", x"B054", x"B055", x"7200", x"8852", x"1753", x"0120",
   x"A201", x"374E", x"0180", x"A201", x"3748", x"7202", x"B580", x"174A",
   x"7580", x"B202", x"0100", x"B04F", x"B200", x"1753", x"01FF", x"B202",
   x"0100", x"B04F", x"B200", x"175A", x"0108", x"E201", x"275A", x"7201",
   x"B04F", x"B203", x"104B", x"0100", x"B422", x"B423", x"B424", x"B425",
   x"B426", x"B427", x"B428", x"0114", x"B429", x"1F00", x"7035", x"C835",
   x"7036", x"D836", x"7037", x"D837", x"7038", x"D838", x"1F00", x"0120",
   x"B03F", x"7033", x"C833", x"7034", x"D834", x"7035", x"D835", x"7036",
   x"D836", x"7037", x"D837", x"7038", x"D838", x"7039", x"D839", x"703A",
   x"D83A", x"579B", x"7037", x"E03B", x"B037", x"7038", x"F03C", x"B038",
   x"7039", x"F03D", x"B039", x"703A", x"F03E", x"B03A", x"4798", x"703B",
   x"C837", x"703C", x"D838", x"703D", x"D839", x"703E", x"D83A", x"179A",
   x"0101", x"C833", x"17A3", x"7037", x"E03B", x"B037", x"7038", x"F03C",
   x"B038", x"0101", x"C833", x"01FF", x"C83F", x"2771", x"0003", x"0003",
   x"1F00", x"0100", x"B02E", x"0D80", x"742C", x"27B3", x"0C80", x"C02A",
   x"B02F", x"B225", x"17BA", x"0C80", x"37B8", x"B02F", x"0001", x"17BA",
   x"01FF", x"1F00", x"7640", x"E02F", x"57F5", x"0102", x"A650", x"37CC",
   x"7427", x"E429", x"47C6", x"0101", x"CC27", x"17C8", x"0180", x"6869",
   x"0120", x"6869", x"0100", x"1F00", x"702E", x"37E0", x"0400", x"B05B",
   x"0480", x"B05C", x"0003", x"0003", x"7600", x"B400", x"B224", x"0C01",
   x"01FF", x"C82E", x"27D2", x"705B", x"0800", x"705C", x"0880", x"0003",
   x"742C", x"27F2", x"7600", x"E224", x"37F1", x"7422", x"E429", x"47EB",
   x"0101", x"CC22", x"17ED", x"0180", x"6869", x"0101", x"6869", x"0100",
   x"1F00", x"17F3", x"C029", x"01FF", x"17F6", x"0100", x"1F00", x"7222",
   x"E42F", x"E431", x"5F00", x"7425", x"E429", x"4801", x"0101", x"CC25",
   x"1803", x"0180", x"6869", x"0108", x"6869", x"1F00", x"7222", x"E42F",
   x"E431", x"5F00", x"7425", x"E429", x"4810", x"0101", x"CC25", x"1812",
   x"0180", x"6869", x"0108", x"6869", x"0180", x"A420", x"2819", x"0101",
   x"B41E", x"1F00", x"0003", x"7660", x"281A", x"B225", x"7640", x"382A",
   x"7426", x"E429", x"4826", x"0101", x"CC26", x"1828", x"0180", x"6869",
   x"0110", x"6869", x"0101", x"A640", x"3837", x"7424", x"E429", x"4833",
   x"0101", x"CC24", x"1835", x"0180", x"6869", x"0104", x"6869", x"1F00",
   x"01FF", x"183B", x"0100", x"B224", x"B600", x"1F00", x"B224", x"B600",
   x"742C", x"2845", x"0003", x"7224", x"B600", x"7222", x"B42F", x"7223",
   x"B430", x"1F00", x"7230", x"B033", x"7231", x"B034", x"7232", x"B035",
   x"7233", x"B036", x"0100", x"B037", x"B038", x"B039", x"B03A", x"676F",
   x"7033", x"B062", x"7034", x"B063", x"01FF", x"C862", x"01FF", x"D863",
   x"01FF", x"C862", x"01FF", x"D863", x"7062", x"B222", x"7063", x"B223",
   x"1F00", x"8C20", x"7051", x"A858", x"0180", x"A420", x"3871", x"7051",
   x"A855", x"0120", x"8C21", x"B640", x"0100", x"B650", x"1F00", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"ABCD"
);

signal daddra: std_logic_vector(11 downto 0);
signal daddrb: std_logic_vector(11 downto 0);

begin
   asslbpb: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (wea = '1') then
            RAM(conv_integer(addra)) <= dina;
         end if;
         daddra <= addra;
         daddrb <= addrb;
      end if; -- clk 
   end process;

   douta <= RAM(conv_integer(daddra));
   doutb <= RAM(conv_integer(daddrb));
end;
