library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use IEEE.STD_LOGIC_UNSIGNED.all;

-- Created from sslbp.bin
-- On  9/ 6/2024

entity sslbp is
	port (
	addra: in std_logic_vector(10 downto 0);
	addrb: in std_logic_vector(10 downto 0);
	clk: in std_logic;
	dina: in std_logic_vector(15 downto 0);
	douta: out std_logic_vector(15 downto 0);
	doutb: out std_logic_vector(15 downto 0);
	wea: in std_logic);
end sslbp;

architecture syn of sslbp is
   type ram_type is array (0 to 2047) of std_logic_vector(15 downto 0);
   signal RAM : ram_type := 
   (
   x"0000", x"0000", x"0000", x"0100", x"0800", x"0880", x"0100", x"B400",
   x"0C01", x"0480", x"0300", x"4006", x"B203", x"0101", x"B029", x"01FF",
   x"B02B", x"7234", x"B007", x"0138", x"B008", x"0149", x"B009", x"0132",
   x"B00A", x"0130", x"B00B", x"0137", x"B00C", x"0149", x"B00D", x"0136",
   x"B00E", x"0134", x"B00F", x"0112", x"B000", x"0101", x"B002", x"012C",
   x"B003", x"0108", x"B001", x"0170", x"B004", x"0132", x"B005", x"01D8",
   x"B006", x"0170", x"0800", x"0100", x"0880", x"0002", x"7007", x"B044",
   x"01A0", x"B42A", x"0125", x"B42B", x"0126", x"B42C", x"0100", x"B42D",
   x"0C32", x"0002", x"0002", x"01FF", x"C844", x"2038", x"0100", x"B04E",
   x"B200", x"7048", x"360C", x"704E", x"8052", x"8058", x"360B", x"7222",
   x"E05C", x"B065", x"7222", x"B05C", x"0170", x"0800", x"0100", x"0880",
   x"0180", x"0A00", x"0102", x"0A80", x"0100", x"0B00", x"0103", x"0B80",
   x"0101", x"B04F", x"01FE", x"B050", x"7007", x"B043", x"7052", x"A04F",
   x"308B", x"01FF", x"01C1", x"B413", x"66CE", x"0100", x"B410", x"B411",
   x"B412", x"B41D", x"B424", x"B720", x"B721", x"B722", x"B723", x"B740",
   x"B741", x"B742", x"B743", x"B760", x"B761", x"B762", x"B763", x"B640",
   x"B650", x"7050", x"A852", x"7050", x"A851", x"704F", x"8854", x"704F",
   x"8853", x"7050", x"A855", x"7051", x"A04F", x"35B9", x"0195", x"C410",
   x"0D80", x"0000", x"0000", x"0000", x"1800", x"11A1", x"11AA", x"11AE",
   x"11BA", x"11C0", x"1526", x"152E", x"11DB", x"11E3", x"11EA", x"11F0",
   x"11F8", x"120A", x"1210", x"1226", x"122C", x"1234", x"123C", x"1244",
   x"124C", x"1254", x"125C", x"1264", x"129A", x"12CC", x"12D7", x"12DF",
   x"12E9", x"12F0", x"12F6", x"132A", x"133C", x"1347", x"134F", x"1356",
   x"135C", x"136F", x"1375", x"137D", x"1392", x"139F", x"13A6", x"13B0",
   x"13BE", x"13C8", x"13D0", x"13E2", x"13EF", x"13F6", x"1403", x"140A",
   x"1414", x"141C", x"1425", x"142F", x"1437", x"144A", x"1458", x"1117",
   x"112F", x"10D9", x"10EE", x"1162", x"1177", x"145F", x"14D3", x"1535",
   x"1582", x"7055", x"A04F", x"30ED", x"7411", x"8C12", x"0100", x"B411",
   x"678D", x"01BD", x"67AE", x"7720", x"67AE", x"7721", x"67AE", x"7722",
   x"67AE", x"7723", x"67B1", x"013D", x"B410", x"15B9", x"742E", x"671D",
   x"3110", x"7050", x"A855", x"7400", x"B740", x"7401", x"B741", x"7402",
   x"B742", x"7403", x"B743", x"8402", x"30FF", x"0101", x"8C13", x"7406",
   x"B720", x"7407", x"B721", x"7404", x"B722", x"7405", x"B723", x"7411",
   x"210B", x"7050", x"A856", x"7050", x"A857", x"013C", x"B410", x"1116",
   x"676A", x"5116", x"7050", x"A855", x"013C", x"B410", x"15B9", x"7411",
   x"8C12", x"0100", x"B411", x"704F", x"8858", x"678D", x"01BD", x"67AE",
   x"742F", x"B04D", x"312B", x"0003", x"0100", x"67AE", x"01FF", x"C84D",
   x"2124", x"0003", x"0003", x"67B3", x"013B", x"B410", x"15B9", x"742E",
   x"671D", x"3155", x"7222", x"E421", x"B430", x"017F", x"AC13", x"7050",
   x"A853", x"7050", x"A854", x"7055", x"A04F", x"3152", x"0114", x"C430",
   x"B423", x"7424", x"3146", x"0142", x"B410", x"1151", x"0180", x"E41D",
   x"214C", x"013C", x"B410", x"1151", x"0174", x"E41D", x"2151", x"013E",
   x"B410", x"1154", x"013A", x"B410", x"1161", x"676A", x"5161", x"7055",
   x"A04F", x"315C", x"7050", x"A855", x"0180", x"A412", x"2161", x"013A",
   x"B410", x"15B9", x"7055", x"A04F", x"3176", x"7411", x"8C12", x"0100",
   x"B411", x"678D", x"01BD", x"67AE", x"7720", x"67AE", x"7721", x"67AE",
   x"7722", x"67AE", x"67AD", x"67B3", x"013F", x"B410", x"15B9", x"742E",
   x"671D", x"319A", x"7050", x"A855", x"7400", x"B720", x"7401", x"B721",
   x"7402", x"B722", x"0108", x"A403", x"3187", x"0101", x"8C13", x"0100",
   x"B723", x"7404", x"B740", x"7405", x"B741", x"7406", x"B742", x"7407",
   x"B743", x"7411", x"2195", x"7050", x"A856", x"7050", x"A857", x"013E",
   x"B410", x"11A0", x"676A", x"51A0", x"7050", x"A855", x"013E", x"B410",
   x"15B9", x"66CE", x"0100", x"B650", x"B640", x"0101", x"B410", x"7063",
   x"B423", x"15B9", x"67B8", x"0102", x"B410", x"15B9", x"7222", x"E421",
   x"B030", x"7223", x"F422", x"B031", x"7423", x"E030", x"41B9", x"0103",
   x"B410", x"15B9", x"678D", x"01DF", x"67B1", x"0104", x"B410", x"15B9",
   x"676A", x"51C5", x"0101", x"B410", x"11DA", x"0101", x"671D", x"31DA",
   x"015A", x"E400", x"21CE", x"0105", x"B410", x"11DA", x"7415", x"E41B",
   x"41D4", x"0101", x"CC15", x"11D6", x"0180", x"67DC", x"0102", x"67DC",
   x"0101", x"B410", x"15B9", x"678D", x"01E1", x"67AE", x"67AD", x"67B3",
   x"0108", x"B410", x"15B9", x"671C", x"31E8", x"0109", x"B410", x"11E9",
   x"6779", x"15B9", x"678D", x"01C1", x"67B1", x"010A", x"B410", x"15B9",
   x"0101", x"671D", x"31F6", x"010B", x"B410", x"11F7", x"6779", x"15B9",
   x"7400", x"21FD", x"010C", x"B410", x"1209", x"0140", x"67DC", x"741A",
   x"E41B", x"4205", x"0101", x"CC1A", x"1207", x"0180", x"67DC", x"0101",
   x"B410", x"15B9", x"678D", x"01BC", x"67B1", x"010D", x"B410", x"15B9",
   x"0104", x"671D", x"321E", x"7400", x"B720", x"7401", x"B721", x"7402",
   x"B722", x"7403", x"B723", x"010E", x"B410", x"1225", x"676A", x"5225",
   x"010F", x"E047", x"2225", x"010E", x"B410", x"15B9", x"678D", x"01D0",
   x"67B1", x"010F", x"B410", x"15B9", x"0101", x"671D", x"3232", x"0110",
   x"B410", x"1233", x"6779", x"15B9", x"7400", x"B426", x"678D", x"01D1",
   x"67B1", x"0111", x"B410", x"15B9", x"0101", x"671D", x"3242", x"0112",
   x"B410", x"1243", x"6779", x"15B9", x"7400", x"B427", x"678D", x"01D2",
   x"67B1", x"0113", x"B410", x"15B9", x"0101", x"671D", x"3252", x"0114",
   x"B410", x"1253", x"6779", x"15B9", x"7400", x"B428", x"678D", x"01D3",
   x"67B1", x"0115", x"B410", x"15B9", x"0101", x"671D", x"3262", x"0116",
   x"B410", x"1263", x"6779", x"15B9", x"0117", x"B410", x"7426", x"B740",
   x"7427", x"B741", x"7428", x"B742", x"7400", x"B429", x"B743", x"7008",
   x"E426", x"B02F", x"0001", x"7009", x"F427", x"882F", x"0001", x"700A",
   x"F428", x"882F", x"0001", x"700B", x"F429", x"802F", x"2299", x"0180",
   x"B41D", x"0108", x"B42E", x"0104", x"B42F", x"0109", x"E047", x"228C",
   x"01BF", x"AC13", x"0127", x"B410", x"010F", x"E047", x"2299", x"013E",
   x"AC13", x"7050", x"A853", x"7050", x"A854", x"7064", x"B423", x"0140",
   x"B410", x"15B9", x"7400", x"B429", x"700C", x"E426", x"B02F", x"0001",
   x"700D", x"F427", x"882F", x"0001", x"700E", x"F428", x"882F", x"0001",
   x"700F", x"F429", x"802F", x"22C7", x"0174", x"B41D", x"0108", x"B42E",
   x"0104", x"B42F", x"0109", x"E047", x"22B9", x"01BE", x"AC13", x"0118",
   x"B410", x"010F", x"E047", x"22C6", x"013E", x"AC13", x"7050", x"A853",
   x"7050", x"A854", x"7064", x"B423", x"0140", x"B410", x"12CB", x"01FF",
   x"B424", x"011A", x"B410", x"15B9", x"678D", x"01BD", x"67AE", x"67AD",
   x"67AD", x"67AD", x"0108", x"67B1", x"0119", x"B410", x"15B9", x"742E",
   x"671D", x"32DD", x"013A", x"B410", x"12DE", x"6779", x"15B9", x"678D",
   x"01E6", x"67AE", x"7700", x"7703", x"67AE", x"67B3", x"011B", x"B410",
   x"15B9", x"671C", x"32EE", x"011C", x"B410", x"12EF", x"6779", x"15B9",
   x"678D", x"01BB", x"67B1", x"011D", x"B410", x"15B9", x"0106", x"671D",
   x"331A", x"7400", x"B42E", x"7401", x"B42F", x"7402", x"B760", x"7403",
   x"B761", x"7404", x"B762", x"7405", x"B763", x"0109", x"E047", x"230C",
   x"01BF", x"AC13", x"011E", x"B410", x"010F", x"E047", x"2319", x"013E",
   x"AC13", x"7050", x"A853", x"7050", x"A854", x"7064", x"B423", x"0140",
   x"B410", x"1329", x"676A", x"5329", x"010F", x"E047", x"2329", x"013E",
   x"AC13", x"7050", x"A853", x"7050", x"A854", x"7064", x"B423", x"0140",
   x"B410", x"15B9", x"678D", x"01BD", x"67AE", x"742F", x"B04D", x"3338",
   x"0003", x"0100", x"67AE", x"01FF", x"C84D", x"2331", x"0003", x"0003",
   x"67B3", x"011F", x"B410", x"15B9", x"742E", x"671D", x"3342", x"0120",
   x"B410", x"1346", x"676A", x"5346", x"011E", x"B410", x"15B9", x"678D",
   x"01E7", x"67AE", x"67AB", x"67B3", x"0121", x"B410", x"15B9", x"671C",
   x"3354", x"0122", x"B410", x"1355", x"6779", x"15B9", x"678D", x"01C7",
   x"67B1", x"0123", x"B410", x"15B9", x"0101", x"671D", x"336D", x"7400",
   x"2364", x"0124", x"B410", x"136C", x"0101", x"CC1F", x"236A", x"7050",
   x"A854", x"136C", x"0122", x"B410", x"136E", x"6779", x"15B9", x"678D",
   x"01D7", x"67B1", x"0125", x"B410", x"15B9", x"0101", x"671D", x"337B",
   x"0126", x"B410", x"137C", x"6779", x"15B9", x"7400", x"2384", x"01FE",
   x"AC13", x"013A", x"B410", x"1391", x"B425", x"741A", x"E41B", x"438B",
   x"0101", x"CC1A", x"138D", x"0180", x"67DC", x"0140", x"67DC", x"0124",
   x"B410", x"15B9", x"678D", x"0165", x"67AE", x"0154", x"67AE", x"0108",
   x"67AE", x"67AB", x"67AB", x"67B3", x"0128", x"B410", x"15B9", x"671C",
   x"33A4", x"0129", x"B410", x"13A5", x"6779", x"15B9", x"678D", x"0145",
   x"67AE", x"0154", x"67AE", x"0108", x"67B1", x"012A", x"B410", x"15B9",
   x"0102", x"671D", x"33BC", x"7400", x"8401", x"23B9", x"012B", x"B410",
   x"13BB", x"0129", x"B410", x"13BD", x"6779", x"15B9", x"678D", x"0145",
   x"67AE", x"0152", x"67AE", x"0108", x"67B1", x"012C", x"B410", x"15B9",
   x"0102", x"671D", x"33CE", x"012D", x"B410", x"13CF", x"6779", x"15B9",
   x"7400", x"8401", x"B425", x"23D7", x"012E", x"B410", x"13E1", x"741A",
   x"E41B", x"43DD", x"0101", x"CC1A", x"13DF", x"0180", x"67DC", x"0140",
   x"67DC", x"15B9", x"678D", x"0165", x"67AE", x"0160", x"67AE", x"0108",
   x"67AE", x"67AD", x"67AD", x"67B3", x"012F", x"B410", x"15B9", x"671C",
   x"33F4", x"0130", x"B410", x"13F5", x"6779", x"15B9", x"678D", x"0165",
   x"67AE", x"0104", x"67AE", x"0108", x"67AE", x"67AB", x"67AB", x"67B3",
   x"0131", x"B410", x"15B9", x"671C", x"3408", x"0132", x"B410", x"1409",
   x"6779", x"15B9", x"678D", x"0145", x"67AE", x"01FE", x"67AE", x"0108",
   x"67B1", x"0133", x"B410", x"15B9", x"0102", x"671D", x"341A", x"0134",
   x"B410", x"141B", x"6779", x"15B9", x"7400", x"8401", x"2422", x"0132",
   x"B410", x"1424", x"0135", x"B410", x"15B9", x"678D", x"0145", x"67AE",
   x"0152", x"67AE", x"0108", x"67B1", x"0136", x"B410", x"15B9", x"0102",
   x"671D", x"3435", x"0137", x"B410", x"1436", x"6779", x"15B9", x"7400",
   x"8401", x"243F", x"01FE", x"AC13", x"0138", x"B410", x"1449", x"741A",
   x"E41B", x"4445", x"0101", x"CC1A", x"1447", x"0180", x"67DC", x"0140",
   x"67DC", x"15B9", x"678D", x"0165", x"67AE", x"015C", x"67AE", x"0108",
   x"67AE", x"01F4", x"67AE", x"0101", x"67B1", x"0139", x"B410", x"15B9",
   x"671C", x"345D", x"013A", x"B410", x"145E", x"6779", x"15B9", x"7055",
   x"A04F", x"34D2", x"7411", x"8C12", x"0100", x"B411", x"7700", x"B04B",
   x"7703", x"B04A", x"7701", x"B04C", x"0140", x"A04A", x"2472", x"7050",
   x"A855", x"15B9", x"678D", x"704A", x"67AE", x"0103", x"A04A", x"B045",
   x"0001", x"0101", x"B046", x"7045", x"3482", x"01FF", x"C845", x"7046",
   x"C846", x"147B", x"01BF", x"E04A", x"54C4", x"0104", x"A04A", x"348D",
   x"0003", x"704B", x"67AE", x"704C", x"67AE", x"0120", x"A04A", x"34C1",
   x"0100", x"B41C", x"0108", x"E046", x"24A6", x"0003", x"7720", x"67AE",
   x"7721", x"67AE", x"7722", x"67AE", x"7723", x"67AE", x"7740", x"67AE",
   x"7741", x"67AE", x"7742", x"67AE", x"7743", x"67AE", x"0104", x"E046",
   x"24B2", x"0003", x"7720", x"67AE", x"7721", x"67AE", x"7722", x"67AE",
   x"7723", x"67AE", x"0102", x"E046", x"24BA", x"0003", x"7720", x"67AE",
   x"7721", x"67AE", x"0101", x"E046", x"24C0", x"0003", x"7720", x"67AE",
   x"14C3", x"7046", x"B41C", x"14CF", x"0120", x"A04A", x"34CD", x"0003",
   x"7720", x"67AE", x"0100", x"B41C", x"14CF", x"0101", x"B41C", x"67B3",
   x"0141", x"B410", x"15B9", x"741C", x"671D", x"351F", x"7050", x"A855",
   x"0108", x"E41C", x"24EB", x"7400", x"B720", x"7401", x"B721", x"7402",
   x"B722", x"7403", x"B723", x"7404", x"B740", x"7405", x"B741", x"7406",
   x"B742", x"7407", x"B743", x"0104", x"E41C", x"24FB", x"7400", x"B720",
   x"7401", x"B721", x"7402", x"B722", x"7403", x"B723", x"0100", x"B740",
   x"B741", x"B742", x"B743", x"0102", x"E41C", x"2509", x"7400", x"B720",
   x"7401", x"B721", x"0100", x"B722", x"B723", x"B740", x"B741", x"B742",
   x"B743", x"0101", x"E41C", x"2516", x"7400", x"B720", x"0100", x"B721",
   x"B722", x"B723", x"B740", x"B741", x"B742", x"B743", x"7411", x"251A",
   x"7050", x"A856", x"7050", x"A857", x"0140", x"B410", x"1525", x"676A",
   x"5525", x"7050", x"A855", x"0140", x"B410", x"15B9", x"678D", x"01EB",
   x"67AE", x"0128", x"67B1", x"0106", x"B410", x"15B9", x"671C", x"3533",
   x"0107", x"B410", x"1534", x"6779", x"15B9", x"7055", x"A04F", x"3581",
   x"7411", x"8C12", x"0100", x"B411", x"742F", x"902B", x"0900", x"678D",
   x"01BD", x"67AE", x"742F", x"357E", x"0D02", x"7720", x"67AE", x"0500",
   x"357E", x"0D01", x"7721", x"67AE", x"0500", x"357E", x"0D01", x"7722",
   x"67AE", x"0500", x"357E", x"0D01", x"7723", x"67AE", x"0500", x"357E",
   x"0D01", x"7740", x"67AE", x"0500", x"357E", x"0D01", x"7741", x"67AE",
   x"0500", x"357E", x"0D01", x"7742", x"67AE", x"0500", x"357E", x"0D01",
   x"7743", x"67AE", x"0500", x"357E", x"0D01", x"7760", x"67AE", x"0500",
   x"357E", x"0D01", x"7761", x"67AE", x"0500", x"357E", x"0D01", x"7762",
   x"67AE", x"0500", x"357E", x"0003", x"7763", x"67AE", x"67B3", x"0143",
   x"B410", x"15B9", x"742E", x"671D", x"35B2", x"7050", x"A855", x"7400",
   x"B425", x"358F", x"0101", x"8C13", x"0140", x"67DC", x"1591", x"01BF",
   x"AC13", x"7401", x"B720", x"7402", x"B721", x"7403", x"B722", x"7404",
   x"B723", x"7405", x"B740", x"7406", x"B741", x"7407", x"B742", x"7408",
   x"B743", x"7409", x"B760", x"740A", x"B761", x"740B", x"B762", x"740C",
   x"B763", x"7411", x"25AD", x"7050", x"A856", x"7050", x"A857", x"0142",
   x"B410", x"15B8", x"676A", x"55B8", x"7050", x"A855", x"0142", x"B410",
   x"15B9", x"7412", x"B700", x"7413", x"B701", x"7410", x"B702", x"7425",
   x"B703", x"0C32", x"0E01", x"0F04", x"704F", x"C84F", x"902B", x"B050",
   x"01FF", x"C843", x"2066", x"0110", x"E04E", x"25DF", x"7053", x"902B",
   x"A051", x"A049", x"A055", x"A057", x"25DF", x"704F", x"8859", x"7050",
   x"A858", x"7056", x"B202", x"0100", x"B04E", x"B200", x"0001", x"0109",
   x"E04E", x"25EF", x"7054", x"A053", x"A049", x"25EF", x"7053", x"902B",
   x"A851", x"7053", x"B202", x"0100", x"B04E", x"B200", x"0001", x"010F",
   x"E04E", x"25FF", x"7054", x"A053", x"A049", x"25FF", x"7053", x"902B",
   x"A851", x"7053", x"B202", x"0100", x"B04E", x"B200", x"0001", x"0108",
   x"E04E", x"260B", x"7200", x"360B", x"7052", x"B202", x"A049", x"260B",
   x"0100", x"B04E", x"B200", x"1660", x"0100", x"B203", x"B047", x"01AA",
   x"B202", x"01FF", x"B052", x"0101", x"B04F", x"01FE", x"B050", x"0170",
   x"0800", x"0100", x"0880", x"0180", x"0A00", x"0102", x"0A80", x"0100",
   x"B049", x"7007", x"B044", x"01FF", x"C02B", x"7049", x"0200", x"B049",
   x"704F", x"C84F", x"902B", x"B050", x"742A", x"B034", x"742B", x"B035",
   x"742C", x"B036", x"742D", x"B037", x"66D9", x"66D9", x"66D9", x"66D9",
   x"0100", x"B032", x"B033", x"B038", x"B039", x"7230", x"B03A", x"7231",
   x"B03B", x"7232", x"B03C", x"7233", x"B03D", x"66E2", x"7032", x"B610",
   x"7033", x"B620", x"7034", x"B630", x"B640", x"0100", x"B650", x"0120",
   x"B670", x"0C32", x"0E01", x"01FF", x"C844", x"2623", x"01FF", x"B048",
   x"0108", x"E04E", x"2660", x"7200", x"2660", x"0100", x"B04E", x"B200",
   x"0101", x"A203", x"36CD", x"704E", x"26C7", x"7201", x"0980", x"B04E",
   x"7200", x"0900", x"B203", x"0110", x"A201", x"3677", x"7053", x"902B",
   x"A200", x"B055", x"B056", x"B057", x"01DE", x"AC13", x"16C6", x"0109",
   x"E201", x"268F", x"0120", x"B03A", x"01A1", x"B03B", x"0107", x"B03C",
   x"0100", x"B03D", x"67BD", x"01FA", x"B063", x"7201", x"B047", x"7051",
   x"902B", x"A200", x"B053", x"B054", x"7200", x"8851", x"16C6", x"0108",
   x"E201", x"2698", x"7200", x"B052", x"2697", x"0100", x"B048", x"16C6",
   x"010F", x"E201", x"26B2", x"0188", x"B03A", x"0113", x"B03B", x"0100",
   x"B03C", x"0100", x"B03D", x"67BD", x"0106", x"B063", x"01FA", x"B064",
   x"7201", x"B047", x"7051", x"902B", x"A200", x"B053", x"B054", x"7200",
   x"8851", x"16C6", x"0120", x"A201", x"36C1", x"0180", x"A201", x"36BB",
   x"7202", x"B580", x"16BD", x"7580", x"B202", x"0100", x"B04E", x"B200",
   x"16C6", x"01FF", x"B202", x"0100", x"B04E", x"B200", x"16CD", x"0108",
   x"E201", x"26CD", x"7201", x"B04E", x"B203", x"1049", x"0100", x"B414",
   x"B415", x"B416", x"B417", x"B418", x"B419", x"B41A", x"0114", x"B41B",
   x"1800", x"7034", x"C834", x"7035", x"D835", x"7036", x"D836", x"7037",
   x"D837", x"1800", x"0120", x"B03E", x"7032", x"C832", x"7033", x"D833",
   x"7034", x"D834", x"7035", x"D835", x"7036", x"D836", x"7037", x"D837",
   x"7038", x"D838", x"7039", x"D839", x"570E", x"7036", x"E03A", x"B036",
   x"7037", x"F03B", x"B037", x"7038", x"F03C", x"B038", x"7039", x"F03D",
   x"B039", x"470B", x"703A", x"C836", x"703B", x"D837", x"703C", x"D838",
   x"703D", x"D839", x"170D", x"0101", x"C832", x"1716", x"7036", x"E03A",
   x"B036", x"7037", x"F03B", x"B037", x"0101", x"C832", x"01FF", x"C83E",
   x"26E4", x"0003", x"0003", x"1800", x"0100", x"B02D", x"0D80", x"741E",
   x"2726", x"0C80", x"C029", x"B02E", x"B225", x"172D", x"0C80", x"372B",
   x"B02E", x"0001", x"172D", x"01FF", x"1800", x"7640", x"E02E", x"5768",
   x"0102", x"A650", x"373F", x"7419", x"E41B", x"4739", x"0101", x"CC19",
   x"173B", x"0180", x"67DC", x"0120", x"67DC", x"0100", x"1800", x"702D",
   x"3753", x"0400", x"B05A", x"0480", x"B05B", x"0003", x"0003", x"7600",
   x"B400", x"B224", x"0C01", x"01FF", x"C82D", x"2745", x"705A", x"0800",
   x"705B", x"0880", x"0003", x"741E", x"2765", x"7600", x"E224", x"3764",
   x"7414", x"E41B", x"475E", x"0101", x"CC14", x"1760", x"0180", x"67DC",
   x"0101", x"67DC", x"0100", x"1800", x"1766", x"C028", x"01FF", x"1769",
   x"0100", x"1800", x"7222", x"E421", x"E423", x"5800", x"7417", x"E41B",
   x"4774", x"0101", x"CC17", x"1776", x"0180", x"67DC", x"0108", x"67DC",
   x"1800", x"7222", x"E421", x"E423", x"5800", x"7417", x"E41B", x"4783",
   x"0101", x"CC17", x"1785", x"0180", x"67DC", x"0108", x"67DC", x"0180",
   x"A412", x"278C", x"0101", x"B410", x"1800", x"0003", x"7660", x"278D",
   x"B225", x"7640", x"379D", x"7418", x"E41B", x"4799", x"0101", x"CC18",
   x"179B", x"0180", x"67DC", x"0110", x"67DC", x"0101", x"A640", x"37AA",
   x"7416", x"E41B", x"47A6", x"0101", x"CC16", x"17A8", x"0180", x"67DC",
   x"0104", x"67DC", x"1800", x"01FF", x"17AE", x"0100", x"B224", x"B600",
   x"1800", x"B224", x"B600", x"741E", x"27B8", x"0003", x"7224", x"B600",
   x"7222", x"B421", x"7223", x"B422", x"1800", x"7230", x"B032", x"7231",
   x"B033", x"7232", x"B034", x"7233", x"B035", x"0100", x"B036", x"B037",
   x"B038", x"B039", x"66E2", x"7032", x"B061", x"7033", x"B062", x"01FF",
   x"C861", x"01FF", x"D862", x"01FF", x"C861", x"01FF", x"D862", x"7061",
   x"B222", x"7062", x"B223", x"1800", x"8C12", x"7050", x"A857", x"0180",
   x"A412", x"37E4", x"7050", x"A854", x"0120", x"8C13", x"B640", x"0100",
   x"B650", x"1800", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000",
   x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"0000", x"ABCD"
);

signal daddra: std_logic_vector(10 downto 0);
signal daddrb: std_logic_vector(10 downto 0);

begin
   asslbp: process (clk)
   begin
      if (clk'event and clk = '1') then
         if (wea = '1') then
            RAM(conv_integer(addra)) <= dina;
         end if;
         daddra <= addra;
         daddrb <= addrb;
      end if; -- clk 
   end process;

   douta <= RAM(conv_integer(daddra));
   doutb <= RAM(conv_integer(daddrb));
end;
