@echo off
chcp 65001 > nul
echo ================================================
echo IndexTTS WebUI - 综合启动器
echo ================================================
echo.

REM 尝试激活虚拟环境
if exist "venv\Scripts\activate.bat" (
    echo 正在激活虚拟环境...
    call venv\Scripts\activate.bat
    echo ✅ 虚拟环境已激活
) else (
    echo ⚠️ 未找到虚拟环境，将使用系统默认 Python
)
echo.

REM 尝试自动添加防火墙规则
netsh advfirewall firewall show rule name="IndexTTS WebUI" >nul
if %errorlevel% neq 0 (
    echo 正在尝试添加防火墙规则（需要管理员权限）...
    netsh advfirewall firewall add rule name="IndexTTS WebUI" dir=in action=allow protocol=TCP localport=7860 >nul 2>&1
    if %errorlevel% neq 0 (
        echo ⚠️  自动添加防火墙规则失败。如果局域网其他设备无法访问，建议右键本程序选择"以管理员身份运行"。
    ) else (
        echo ✅ 已添加防火墙规则
    )
)
echo.

echo 请选择启动模式：
echo 1. 局域网访问模式 [默认]
echo    ✅ 同一WiFi下的所有设备都可以访问
echo.
echo 2. 局域网 + 外网分享模式
echo    🌍 除了局域网访问外，还会生成一个公共链接，任何人都可以通过互联网访问
echo    ⚠️  链接会在72小时后失效
echo.
set /p choice="请输入选项 (1 或 2，直接回车默认为 1): "

if "%choice%"=="2" (
    echo.
    echo 正在启动 [局域网 + 外网分享模式]...
    echo ⚠️  请注意保护生成的公共链接
    echo.
    python webui.py --host 0.0.0.0 --share
) else (
    echo.
    echo 正在启动 [局域网访问模式]...
    echo.
    python webui.py --host 0.0.0.0
)

pause
