"""
IndexTTS2 批量生成工具 - 无窗口启动器（带错误日志）
如果启动失败，会在当前目录生成 startup_error.log
"""
import subprocess
import sys
import os
import traceback
from datetime import datetime

try:
    # 切换到脚本所在目录
    script_dir = os.path.dirname(os.path.abspath(__file__))
    os.chdir(script_dir)
    
    # 查找 Python 可执行文件
    venv_python = os.path.join("venv", "Scripts", "python.exe")  # 改用 python.exe 而不是 pythonw.exe，这样可以看到错误
    
    if os.path.exists(venv_python):
        python_exe = venv_python
    else:
        python_exe = "python.exe"
    
    # 记录启动信息
    log_file = os.path.join(script_dir, "startup_log.txt")
    with open(log_file, "w", encoding="utf-8") as f:
        f.write(f"启动时间: {datetime.now()}\n")
        f.write(f"工作目录: {os.getcwd()}\n")
        f.write(f"Python路径: {python_exe}\n")
        f.write(f"Python存在: {os.path.exists(python_exe)}\n")
    
    # 启动 GUI
    process = subprocess.Popen(
        [python_exe, "tts_batch_gui.py"],
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE,
        creationflags=subprocess.CREATE_NO_WINDOW if sys.platform == "win32" else 0
    )
    
    # 记录进程ID
    with open(log_file, "a", encoding="utf-8") as f:
        f.write(f"进程ID: {process.pid}\n")
        f.write("启动成功！\n")

except Exception as e:
    # 记录错误
    error_log = os.path.join(os.path.dirname(os.path.abspath(__file__)), "startup_error.log")
    with open(error_log, "w", encoding="utf-8") as f:
        f.write(f"启动失败时间: {datetime.now()}\n")
        f.write(f"错误信息:\n{str(e)}\n\n")
        f.write(f"详细traceback:\n{traceback.format_exc()}\n")

