"""
IndexTTS2 批量生成工具 - 无窗口启动器
双击此文件直接启动GUI，不会显示黑色CMD窗口
"""
import subprocess
import sys
import os

try:
    # 切换到脚本所在目录
    script_dir = os.path.dirname(os.path.abspath(__file__))
    os.chdir(script_dir)

    # 查找 Python 可执行文件
    venv_python = os.path.join(script_dir, "venv", "Scripts", "pythonw.exe")

    if os.path.exists(venv_python):
        # 使用虚拟环境的 pythonw
        python_exe = venv_python
    else:
        # 使用系统的 pythonw
        python_exe = "pythonw.exe"

    # GUI 脚本路径
    gui_script = os.path.join(script_dir, "tts_batch_gui.py")

    # 启动 GUI（无窗口模式）
    subprocess.Popen([python_exe, gui_script])
    
except Exception as e:
    # 如果出错，显示错误消息框
    import tkinter
    from tkinter import messagebox
    root = tkinter.Tk()
    root.withdraw()
    messagebox.showerror("启动错误 / Startup Error", f"无法启动GUI:\n{str(e)}")
    root.destroy()

