@echo off
chcp 65001 > nul
echo ===============================================
echo IndexTTS2 GUI - Setup Script
echo 新位置部署脚本 ^| セットアップスクリプト ^| Script de Configuracion
echo ===============================================
echo.

echo This script will set up the project environment
echo 此脚本将帮助您在新位置设置项目环境
echo このスクリプトはプロジェクト環境をセットアップします
echo Este script configurara el entorno del proyecto
echo.
echo For detailed guide in your language, see: SETUP_GUIDE.txt
echo 详细指南请查看：SETUP_GUIDE.txt
echo 詳細ガイド：SETUP_GUIDE.txt を参照
echo Para guia detallada: SETUP_GUIDE.txt
echo.
echo Current directory ^| 当前目录 ^| 現在のディレクトリ ^| Directorio actual:
echo %CD%
echo.
pause

echo.
echo [步骤 1/5] 检查Python环境...
python --version >nul 2>&1
if errorlevel 1 (
    echo ❌ 错误: 未找到Python，请先安装Python 3.10+
    pause
    exit /b 1
)
python --version
echo ✓ Python已安装

echo.
echo [步骤 2/5] 清理旧的虚拟环境...
if exist venv (
    echo 发现旧的venv目录，正在删除...
    rmdir /s /q venv
    echo ✓ 已删除旧虚拟环境
) else (
    echo ✓ 无需清理
)

echo.
echo [步骤 3/5] 创建新的虚拟环境...
python -m venv venv
if errorlevel 1 (
    echo ❌ 错误: 创建虚拟环境失败
    pause
    exit /b 1
)
echo ✓ 虚拟环境创建成功

echo.
echo [步骤 4/5] 激活虚拟环境并安装依赖...
call venv\Scripts\activate
if errorlevel 1 (
    echo ❌ 错误: 激活虚拟环境失败
    pause
    exit /b 1
)
echo ✓ 虚拟环境已激活

echo.
echo 正在安装依赖包（这可能需要几分钟）...
echo.

REM 检查是否有requirements.txt
if exist requirements.txt (
    echo 使用 requirements.txt 安装依赖...
    pip install -r requirements.txt
) else (
    echo 使用最小化安装脚本...
    call install_dependencies_minimal.bat
)

if errorlevel 1 (
    echo.
    echo ⚠️  警告: 部分依赖安装失败，但可能不影响基本功能
    echo 可以稍后手动运行: install_dependencies_minimal.bat
    echo.
) else (
    echo ✓ 依赖安装成功
)

echo.
echo [步骤 5/5] 验证必需文件...
set MISSING=0

if not exist "checkpoints\config.yaml" (
    echo ❌ 缺少: checkpoints\config.yaml
    set MISSING=1
)
if not exist "tts_batch_gui.py" (
    echo ❌ 缺少: tts_batch_gui.py
    set MISSING=1
)
if not exist "batch_generate.py" (
    echo ❌ 缺少: batch_generate.py
    set MISSING=1
)
if not exist "i18n.json" (
    echo ❌ 缺少: i18n.json
    set MISSING=1
)

if %MISSING%==1 (
    echo.
    echo ⚠️  警告: 缺少必需文件，项目可能无法运行
    echo 请确保从原项目复制完整文件
    echo.
) else (
    echo ✓ 所有必需文件完整
)

echo.
echo ===============================================
echo 部署完成！
echo ===============================================
echo.
echo 现在您可以：
echo   1. 运行 run_tts_gui.bat 启动GUI
echo   2. 双击 start_gui.pyw 隐藏启动
echo.
echo 如有问题，请查看 移植说明.txt
echo ===============================================
echo.
pause

