@echo off
chcp 65001 > nul
setlocal enabledelayedexpansion

REM ===============================================
REM IndexTTS2 Model Download Script
REM 模型自动下载脚本
REM ===============================================

echo.
echo ===============================================
echo IndexTTS2 Model Download Script
echo 模型自动下载脚本
echo モデルダウンロードスクリプト
echo Script de Descarga de Modelos
echo ===============================================
echo.

REM 检查 Python
python --version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] Python not found! / Python 未找到！
    echo Please install Python 3.8 or higher.
    echo 请安装 Python 3.8 或更高版本。
    pause
    exit /b 1
)

REM 检查并安装 huggingface_hub
echo [1/5] Checking dependencies... / 检查依赖项...
python -c "import huggingface_hub" >nul 2>&1
if errorlevel 1 (
    echo Installing huggingface_hub... / 安装 huggingface_hub...
    pip install huggingface_hub -i https://pypi.org/simple
)

REM 检查并安装 requests
python -c "import requests" >nul 2>&1
if errorlevel 1 (
    echo Installing requests... / 安装 requests...
    pip install requests -i https://pypi.org/simple
)

REM 创建必要的目录
echo.
echo [2/5] Creating directories... / 创建目录...
if not exist "checkpoints" mkdir checkpoints
if not exist "checkpoints\hf_cache" mkdir checkpoints\hf_cache

REM 切换到项目目录
cd /d "%~dp0"

REM 下载 HuggingFace 模型
echo.
echo [3/5] Downloading HuggingFace models... / 下载 HuggingFace 模型...
echo This may take 30-60 minutes depending on your connection.
echo 根据您的网络连接，这可能需要 30-60 分钟。
echo.

REM 设置 HuggingFace 缓存目录
set HF_HOME=%CD%\checkpoints\hf_cache
set HF_ENDPOINT=https://huggingface.co

REM 尝试国际源
echo [INFO] Trying international source... / 尝试国际源...
set USE_MIRROR=0

REM 测试连接
python -c "import requests; requests.get('https://huggingface.co', timeout=5)" >nul 2>&1
if errorlevel 1 (
    echo [WARN] International source unreachable. / 无法访问国际源。
    echo [INFO] Switching to China mirror... / 切换到国内镜像...
    set HF_ENDPOINT=https://hf-mirror.com
    set USE_MIRROR=1
) else (
    echo [OK] International source accessible. / 国际源可访问。
)

echo.
echo Using endpoint: !HF_ENDPOINT!
echo 使用端点：!HF_ENDPOINT!
echo.

REM 下载模型
echo -----------------------------------------------
echo Downloading Model 1/4: amphion/MaskGCT
echo 下载模型 1/4: amphion/MaskGCT
echo -----------------------------------------------
python -c "from huggingface_hub import snapshot_download; import os; os.environ['HF_ENDPOINT']='!HF_ENDPOINT!'; snapshot_download(repo_id='amphion/MaskGCT', cache_dir='%HF_HOME%', allow_patterns=['semantic_codec/*'])"
if errorlevel 1 (
    echo [ERROR] Failed to download amphion/MaskGCT
    echo 下载 amphion/MaskGCT 失败
    if !USE_MIRROR!==0 (
        echo [INFO] Retrying with China mirror... / 使用国内镜像重试...
        set HF_ENDPOINT=https://hf-mirror.com
        python -c "from huggingface_hub import snapshot_download; import os; os.environ['HF_ENDPOINT']='!HF_ENDPOINT!'; snapshot_download(repo_id='amphion/MaskGCT', cache_dir='%HF_HOME%', allow_patterns=['semantic_codec/*'])"
    )
)

echo.
echo -----------------------------------------------
echo Downloading Model 2/4: facebook/w2v-bert-2.0
echo 下载模型 2/4: facebook/w2v-bert-2.0
echo -----------------------------------------------
python -c "from huggingface_hub import snapshot_download; import os; os.environ['HF_ENDPOINT']='!HF_ENDPOINT!'; snapshot_download(repo_id='facebook/w2v-bert-2.0', cache_dir='%HF_HOME%')"
if errorlevel 1 (
    echo [ERROR] Failed to download facebook/w2v-bert-2.0
    echo 下载 facebook/w2v-bert-2.0 失败
)

echo.
echo -----------------------------------------------
echo Downloading Model 3/4: funasr/campplus
echo 下载模型 3/4: funasr/campplus
echo -----------------------------------------------
python -c "from huggingface_hub import snapshot_download; import os; os.environ['HF_ENDPOINT']='!HF_ENDPOINT!'; snapshot_download(repo_id='funasr/campplus', cache_dir='%HF_HOME%')"
if errorlevel 1 (
    echo [ERROR] Failed to download funasr/campplus
    echo 下载 funasr/campplus 失败
)

echo.
echo -----------------------------------------------
echo Downloading Model 4/4: nvidia/bigvgan_v2_22khz_80band_256x
echo 下载模型 4/4: nvidia/bigvgan_v2_22khz_80band_256x
echo -----------------------------------------------
python -c "from huggingface_hub import snapshot_download; import os; os.environ['HF_ENDPOINT']='!HF_ENDPOINT!'; snapshot_download(repo_id='nvidia/bigvgan_v2_22khz_80band_256x', cache_dir='%HF_HOME%')"
if errorlevel 1 (
    echo [ERROR] Failed to download nvidia/bigvgan_v2_22khz_80band_256x
    echo 下载 nvidia/bigvgan_v2_22khz_80band_256x 失败
)

echo.
echo [4/5] Verifying downloads... / 验证下载...
echo.

REM 检查关键文件是否存在
set ALL_OK=1

if not exist "checkpoints\hf_cache\models--amphion--MaskGCT" (
    echo [!] Missing: amphion/MaskGCT
    set ALL_OK=0
)

if not exist "checkpoints\hf_cache\models--facebook--w2v-bert-2.0" (
    echo [!] Missing: facebook/w2v-bert-2.0
    set ALL_OK=0
)

if not exist "checkpoints\hf_cache\models--funasr--campplus" (
    echo [!] Missing: funasr/campplus
    set ALL_OK=0
)

if not exist "checkpoints\hf_cache\models--nvidia--bigvgan_v2_22khz_80band_256x" (
    echo [!] Missing: nvidia/bigvgan_v2_22khz_80band_256x
    set ALL_OK=0
)

if !ALL_OK!==1 (
    echo [OK] HuggingFace models downloaded successfully!
    echo [OK] HuggingFace 模型下载成功！
) else (
    echo [WARN] Some models may be incomplete.
    echo [WARN] 部分模型可能不完整。
    echo Please check MODEL_DOWNLOAD_GUIDE.txt for manual download.
    echo 请查看 MODEL_DOWNLOAD_GUIDE.txt 进行手动下载。
)

echo.
echo [5/5] Checking custom model files... / 检查定制模型文件...
echo.

REM 检查定制模型文件
set CUSTOM_OK=1

if not exist "checkpoints\gpt.pth" (
    echo [!] Missing: gpt.pth
    set CUSTOM_OK=0
)

if not exist "checkpoints\s2mel.pth" (
    echo [!] Missing: s2mel.pth
    set CUSTOM_OK=0
)

if not exist "checkpoints\bpe.model" (
    echo [!] Missing: bpe.model
    set CUSTOM_OK=0
)

if not exist "checkpoints\qwen0.6bemo4-merge" (
    echo [!] Missing: qwen0.6bemo4-merge folder
    set CUSTOM_OK=0
)

if !CUSTOM_OK!==0 (
    echo.
    echo ===============================================
    echo [IMPORTANT] Custom Model Files Required!
    echo [重要] 需要定制模型文件！
    echo ===============================================
    echo.
    echo The following custom model files are NOT available on HuggingFace:
    echo 以下定制模型文件不在 HuggingFace 上：
    echo.
    echo   - gpt.pth
    echo   - s2mel.pth
    echo   - bpe.model
    echo   - feat1.pt
    echo   - feat2.pt
    echo   - qwen0.6bemo4-merge/ ^(folder^)
    echo   - wav2vec2bert_stats.pt
    echo   - configuration.json
    echo   - pinyin.vocab
    echo.
    echo Please download these files from:
    echo 请从以下位置下载这些文件：
    echo.
    echo 1. Project Release Page / 项目发布页面
    echo    GitHub Releases: [Your GitHub URL]/releases
    echo    File: checkpoints.zip
    echo.
    echo 2. Alternative sources / 其他来源
    echo    Contact project maintainers
    echo    联系项目维护者
    echo.
    echo See MODEL_DOWNLOAD_GUIDE.txt for detailed instructions.
    echo 查看 MODEL_DOWNLOAD_GUIDE.txt 获取详细说明。
    echo.
) else (
    echo [OK] All custom model files found!
    echo [OK] 所有定制模型文件已找到！
)

echo.
echo ===============================================
echo Download Complete! / 下载完成！
echo ===============================================
echo.

if !ALL_OK!==1 (
    if !CUSTOM_OK!==1 (
        echo [SUCCESS] All models are ready!
        echo [成功] 所有模型已就绪！
        echo.
        echo You can now run the application:
        echo 您现在可以运行应用程序：
        echo   - Double-click: start_gui.pyw
        echo   - Or run: python tts_batch_gui.py
        echo.
    ) else (
        echo [PARTIAL] HuggingFace models downloaded, but custom models missing.
        echo [部分完成] HuggingFace 模型已下载，但定制模型缺失。
        echo Please follow instructions above to download custom models.
        echo 请按照上述说明下载定制模型。
    )
) else (
    echo [INCOMPLETE] Some downloads failed.
    echo [不完整] 部分下载失败。
    echo Please check your internet connection and try again.
    echo 请检查您的网络连接并重试。
    echo Or see MODEL_DOWNLOAD_GUIDE.txt for manual download.
    echo 或查看 MODEL_DOWNLOAD_GUIDE.txt 进行手动下载。
)

echo.
echo For more information, see:
echo 更多信息请查看：
echo   - MODEL_DOWNLOAD_GUIDE.txt
echo   - SETUP_GUIDE.txt
echo.
pause

