@echo off
chcp 65001 > nul
echo ===============================================
echo IndexTTS2 GUI - Cleanup Duplicate Files
echo 清理重复文件 ^| 重複ファイルのクリーンアップ
echo ===============================================
echo.
echo This script will delete duplicate model caches and old files
echo 此脚本将删除重复的模型缓存和旧文件
echo このスクリプトは重複モデルキャッシュと古いファイルを削除します
echo.
echo Files to be deleted ^| 将要删除的文件:
echo   1. tmp_hf_home/     (~8.2 GB) - Duplicate HF cache
echo   2. venv_old/        (~4.5 GB) - Old virtual environment
echo   3. temp/*           (~0.2 GB) - Temporary files
echo   4. __pycache__/     (~0.1 GB) - Python cache
echo.
echo Total space to be saved: ~12.7 GB
echo 将节省约 12.7 GB 空间
echo 約12.7GBの空き容量を確保
echo.
echo ⚠️  WARNING: This action cannot be undone!
echo ⚠️  警告：此操作无法撤销！
echo ⚠️  警告：この操作は元に戻せません！
echo.
echo Your project will still work normally after cleanup.
echo 清理后项目仍可正常工作。
echo クリーンアップ後もプロジェクトは正常に動作します。
echo.
pause

echo.
echo ===============================================
echo Starting Cleanup... ^| 开始清理... ^| クリーンアップ開始...
echo ===============================================
echo.

REM Delete tmp_hf_home
if exist "tmp_hf_home" (
    echo [1/4] Deleting tmp_hf_home...
    echo       删除 tmp_hf_home...
    rmdir /s /q "tmp_hf_home" 2>nul
    if not exist "tmp_hf_home" (
        echo       ✓ Deleted tmp_hf_home ^(saved ~8.2 GB^)
        echo       ✓ 已删除 tmp_hf_home（节省约 8.2 GB）
    ) else (
        echo       ✗ Failed to delete tmp_hf_home
        echo       ✗ 删除 tmp_hf_home 失败
    )
) else (
    echo [1/4] tmp_hf_home not found, skipping...
    echo       tmp_hf_home 未找到，跳过...
)

echo.

REM Delete venv_old
if exist "venv_old" (
    echo [2/4] Deleting venv_old...
    echo       删除 venv_old...
    rmdir /s /q "venv_old" 2>nul
    if not exist "venv_old" (
        echo       ✓ Deleted venv_old ^(saved ~4.5 GB^)
        echo       ✓ 已删除 venv_old（节省约 4.5 GB）
    ) else (
        echo       ✗ Failed to delete venv_old
        echo       ✗ 删除 venv_old 失败
    )
) else (
    echo [2/4] venv_old not found, skipping...
    echo       venv_old 未找到，跳过...
)

echo.

REM Clean temp directory
if exist "temp" (
    echo [3/4] Cleaning temp directory...
    echo       清理 temp 目录...
    del /q /s "temp\*" >nul 2>&1
    echo       ✓ Cleaned temp directory ^(saved ~0.2 GB^)
    echo       ✓ 已清理 temp 目录（节省约 0.2 GB）
) else (
    echo [3/4] temp directory not found, skipping...
    echo       temp 目录未找到，跳过...
)

echo.

REM Clean __pycache__
echo [4/4] Cleaning Python cache ^(__pycache__^)...
echo       清理 Python 缓存...
for /d /r %%i in (__pycache__) do (
    if exist "%%i" (
        rmdir /s /q "%%i" 2>nul
    )
)
echo       ✓ Cleaned Python cache ^(saved ~0.1 GB^)
echo       ✓ 已清理 Python 缓存（节省约 0.1 GB）

echo.
echo ===============================================
echo Cleanup Complete! ^| 清理完成！ ^| クリーンアップ完了！
echo ===============================================
echo.
echo Estimated space saved: ~12.7 GB
echo 估计节省空间：约 12.7 GB
echo 節約された容量：約12.7GB
echo.
echo Your project size should now be around 14 GB
echo 项目大小现在应该约为 14 GB
echo プロジェクトサイズは約14GBになるはずです
echo.
echo Project functionality is NOT affected.
echo 项目功能不受影响。
echo プロジェクトの機能には影響ありません。
echo.
echo You can now run: run_tts_gui.bat
echo 现在可以运行：run_tts_gui.bat
echo 実行可能：run_tts_gui.bat
echo.
echo For detailed analysis, see: PROJECT_SIZE_ANALYSIS.txt
echo 详细分析请查看：PROJECT_SIZE_ANALYSIS.txt
echo 詳細分析：PROJECT_SIZE_ANALYSIS.txt
echo.
pause

