# IndexTTS2 Batch Generation GUI

<div align="center">

![IndexTTS2 Banner](assets/IndexTTS2_banner.png)

**A powerful Text-to-Speech batch generation tool with advanced emotion control**

[![License](https://img.shields.io/badge/License-Custom%20Open%20Source-blue.svg)](LICENSE_EN.txt)
[![Python](https://img.shields.io/badge/Python-3.10%2B-brightgreen.svg)](https://www.python.org/)
[![Platform](https://img.shields.io/badge/Platform-Windows-lightgrey.svg)]()

[English](#english) | [中文](#中文) | [日本語](#日本語) | [Español](#español)

</div>

---

## English

### 📖 About This Project

IndexTTS2 Batch Generation GUI is a user-friendly desktop application built on top of the powerful IndexTTS2 model. It provides an intuitive interface for generating high-quality, emotionally expressive speech from text with advanced batch processing capabilities.

### ✨ Key Features

#### 🎭 **Advanced Emotion Control**
- **8 Emotion Dimensions**: Happy, Sad, Angry, Fear, Disgust, Surprise, Calm, Neutral
- **Fine-grained Control**: Adjust each emotion from 0.0 to 1.0 with precision sliders
- **Emotion Intensity Levels**: Low, Mid, High presets for quick adjustments
- **Voice Preservation Mode**: Balance between emotion expression and speaker characteristics
- **Emotion Vector Persistence**: Save and reuse emotion settings across multiple tasks

#### 🎯 **Flexible Text Input Formats**
- **Plain Text**: Simple dialogue lines
- **Emotion-Tagged Text**: English emotion descriptions in parentheses
  ```
  (cheerful and excited) Hello, how are you today?
  (calm and gentle) I'm doing great, thank you!
  ```
- **Automatic Emotion Detection**: AI-powered emotion analysis from text

#### ⚡ **High-Performance Batch Processing**
- **Single Sentence Mode**: Quick testing and preview
- **Batch Mode**: Process entire text files with hundreds of lines
- **Multi-GPU Support**: Distribute tasks across multiple GPUs for faster processing
- **Sequential Task Queue**: Set up and run multiple tasks automatically
- **Progress Tracking**: Real-time progress bars and status updates

#### 🌍 **Multi-language Interface**
- **4 Languages**: Chinese, English, Japanese, Spanish
- **Complete Localization**: All UI elements, logs, and help texts
- **One-Click Switching**: Change language instantly without restart

#### 🖥️ **User-Friendly Interface**
- **Modern Tkinter GUI**: Clean, intuitive design
- **Tabbed Layout**: Separate single and batch modes
- **Real-time Console**: Monitor generation progress
- **Log Export**: Save console output to file
- **Error Handling**: Clear error messages and guidance

#### 🎨 **Additional Features**
- **CPU/GPU Mode Selection**: Works with or without GPU
- **Custom Output Locations**: Choose where to save audio files
- **One-Click Stop**: Cancel running tasks anytime
- **Automatic Resume**: Continue from where you stopped
- **Portable**: Move project to any location easily

### 🛠️ Technology Stack

- **Core Model**: IndexTTS2 (based on bilibili's open-source model)
- **GUI Framework**: Tkinter (Python)
- **Deep Learning**: PyTorch, Transformers
- **Audio Processing**: LibROSA, TorchAudio
- **Models Used**:
  - amphion/MaskGCT
  - facebook/w2v-bert-2.0
  - funasr/campplus
  - nvidia/bigvgan_v2_22khz_80band_256x
  - Custom Qwen-based emotion analyzer

### 📋 Requirements

#### Minimum Requirements
- **OS**: Windows 10/11 (64-bit)
- **Python**: 3.10 or higher
- **RAM**: 8 GB
- **Disk Space**: 20 GB free space
- **Internet**: Required for initial model download

#### Recommended Requirements
- **RAM**: 16 GB or more
- **GPU**: NVIDIA GPU with 8GB+ VRAM (CUDA compatible)
- **Disk Space**: 30 GB free space (for models and outputs)

### 🚀 Quick Start

#### Step 1: Clone the Repository

```bash
git clone https://github.com/your-username/index-tts2-gui.git
cd index-tts2-gui
```

#### Step 2: Download Models (~8-10 GB)

**Option A: Automatic Download (Recommended)**

```bash
download_models.bat
```

The script will:
- Try international sources first (huggingface.co)
- Fallback to China mirror (hf-mirror.com) if needed
- Verify all downloads automatically

**Option B: Manual Download**

See [MODEL_DOWNLOAD_GUIDE.txt](MODEL_DOWNLOAD_GUIDE.txt) for detailed instructions.

#### Step 3: Setup Environment

```bash
setup_new_location.bat
```

This will:
- Check Python installation
- Create virtual environment
- Install all dependencies
- Verify required files

#### Step 4: Launch Application

**GUI Mode (No Console):**
```bash
start_gui.pyw
```

**Debug Mode (With Console):**
```bash
run_tts_gui.bat
```

### 📚 Detailed Installation Guide

For complete step-by-step instructions, please refer to:
- **[START_HERE.txt](START_HERE.txt)** - Welcome and quick overview
- **[SCRIPTS_OVERVIEW.txt](SCRIPTS_OVERVIEW.txt)** - All scripts explained
- **[MODEL_DOWNLOAD_GUIDE.txt](MODEL_DOWNLOAD_GUIDE.txt)** - Model download instructions
- **[SETUP_GUIDE.txt](SETUP_GUIDE.txt)** - Complete setup guide
- **[USER_MANUAL.txt](USER_MANUAL.txt)** - How to use the GUI

### 💡 Usage Examples

#### Single Sentence Generation

1. Launch the GUI
2. Go to "Single Sentence" tab
3. Select reference audio (your target voice)
4. Enter text or use emotion sliders
5. Click "Generate Audio"
6. Choose save location

#### Batch Processing

1. Prepare a text file with dialogue lines:
   ```
   (happy) Good morning everyone!
   (sad and tired) I'm feeling exhausted today.
   (excited) This is amazing news!
   ```

2. Go to "Batch Mode" tab
3. Select text file, reference audio, and output directory
4. Configure emotion settings
5. Click "Add to Task List"
6. Click "Start All Tasks"

#### Multi-GPU Processing

1. Enable "Multi-GPU" mode in GPU settings
2. Add batch tasks as usual
3. System will automatically distribute work across all available GPUs
4. Monitor progress in console

### ⚙️ Configuration

#### Emotion Control

- **Sliders**: Adjust 8 emotion dimensions individually
- **Emotion Level**: Quick presets (Low 0.6, Mid 0.8, High 1.0)
- **Voice Preservation**: Enable to maintain speaker characteristics

#### GPU Settings

- **Auto**: System selects GPU automatically
- **Single GPU**: Choose specific GPU (if you have multiple)
- **Multi-GPU**: Use all available GPUs for batch tasks
- **CPU Mode**: Works without GPU (slower)

#### Text File Format

**Plain Text:**
```
Hello, how are you?
I'm doing great!
```

**With Emotion Tags (English only):**
```
(cheerful and excited) Hello, how are you?
(calm and gentle) I'm doing great!
```

⚠️ **Important**: Emotion descriptions must be in **English** within parentheses.

### ❓ Common Issues & Solutions

#### Issue: "Model files not found"

**Solution:**
1. Run `download_models.bat` to download HuggingFace models
2. Download custom model files from project releases
3. Verify directory structure matches [MODEL_DOWNLOAD_GUIDE.txt](MODEL_DOWNLOAD_GUIDE.txt)

#### Issue: "Cannot access huggingface.co"

**Solution:**
- Run `download_models.bat` - it will automatically try China mirror (hf-mirror.com)
- Or manually download from: https://hf-mirror.com

#### Issue: "GPU not detected"

**Solution:**
1. Update NVIDIA GPU drivers
2. Install CUDA toolkit (11.8 or 12.1)
3. Verify PyTorch can detect GPU:
   ```bash
   python -c "import torch; print(torch.cuda.is_available())"
   ```
4. Use CPU mode as fallback

#### Issue: "Out of memory"

**Solution:**
- Reduce batch size
- Enable Multi-GPU mode
- Lower emotion intensity
- Close other applications
- Use CPU mode (slower but works)

#### Issue: "Emotions not working"

**Solution:**
- Verify emotion description format: `(emotion words) dialogue text`
- Use **English** for emotion descriptions
- Check text file encoding (should be UTF-8)
- Enable "Use text-based emotions" in batch mode

#### Issue: "Application won't start"

**Solution:**
1. Check Python version: `python --version` (should be 3.10+)
2. Reinstall dependencies:
   ```bash
   cd project-folder
   setup_new_location.bat
   ```
3. Check logs in `startup_log.txt`
4. Run with console to see errors: `run_tts_gui.bat`

For more troubleshooting, see [SETUP_GUIDE.txt](SETUP_GUIDE.txt).

### 🗂️ Project Structure

```
index-tts2-gui/
├── tts_batch_gui.py          # Main GUI application
├── batch_generate.py         # Backend TTS engine
├── download_models.bat       # Model download script
├── setup_new_location.bat    # Environment setup script
├── start_gui.pyw             # GUI launcher (no console)
├── run_tts_gui.bat           # GUI launcher (with console)
├── requirements.txt          # Python dependencies
├── checkpoints/              # Model files (download required)
│   ├── gpt.pth
│   ├── s2mel.pth
│   ├── bpe.model
│   ├── qwen0.6bemo4-merge/
│   └── hf_cache/             # HuggingFace models
├── indextts/                 # Core TTS modules
├── assets/                   # Images and icons
├── docs/                     # Additional documentation
└── examples/                 # Example audio files
```

### 🤝 Contributing

Contributions are welcome! Please feel free to:
- Report bugs and issues
- Suggest new features
- Submit pull requests
- Improve documentation

### 📄 License

This project is licensed under a Custom Open Source License. See [LICENSE_EN.txt](LICENSE_EN.txt) for details.

**Key Points:**
- ✅ Free for personal and commercial use
- ✅ Modification and redistribution allowed
- ✅ No warranty provided
- ⚠️ Must retain copyright notice

### 🙏 Acknowledgments

This project would not be possible without:

- **[bilibili](https://www.bilibili.com/)** - For open-sourcing the IndexTTS2 model and making advanced TTS technology accessible to everyone
- **amphion/MaskGCT** - Semantic codec model
- **facebook/w2v-bert-2.0** - Speech representation model
- **funasr/campplus** - Speaker embedding model
- **nvidia/bigvgan** - High-quality vocoder
- **Qwen Team** - Emotion analysis model
- All contributors and users who provide feedback

### 📞 Contact & Support

- **Documentation**: See [USER_MANUAL.txt](USER_MANUAL.txt)
- **Issues**: [GitHub Issues](https://github.com/your-username/index-tts2-gui/issues)
- **Discussions**: [GitHub Discussions](https://github.com/your-username/index-tts2-gui/discussions)

### 🌟 Star History

If you find this project useful, please consider giving it a star ⭐!

---

## 中文

### 📖 关于本项目

IndexTTS2 批量生成 GUI 是一个基于强大的 IndexTTS2 模型构建的用户友好桌面应用程序。它提供了一个直观的界面，用于从文本生成高质量、富有情感表现力的语音，并具有先进的批量处理能力。

### ✨ 核心功能

#### 🎭 **高级情绪控制**
- **8 个情绪维度**：高兴、悲伤、愤怒、恐惧、厌恶、惊讶、平静、中性
- **精细控制**：使用精确滑块将每个情绪从 0.0 调整到 1.0
- **情绪强度档位**：低、中、高预设，快速调整
- **声纹保护模式**：平衡情绪表达和说话人特征
- **情绪向量持久化**：保存并在多个任务中重用情绪设置

#### 🎯 **灵活的文本输入格式**
- **纯文本**：简单的对话行
- **情绪标记文本**：括号内的英文情绪描述
  ```
  (cheerful and excited) 你好，今天过得怎么样？
  (calm and gentle) 我很好，谢谢！
  ```
- **自动情绪检测**：AI 驱动的文本情绪分析

#### ⚡ **高性能批量处理**
- **单句模式**：快速测试和预览
- **批量模式**：处理包含数百行的整个文本文件
- **多 GPU 支持**：在多个 GPU 上分配任务以加快处理速度
- **顺序任务队列**：自动设置和运行多个任务
- **进度跟踪**：实时进度条和状态更新

#### 🌍 **多语言界面**
- **4 种语言**：中文、英文、日文、西班牙文
- **完全本地化**：所有 UI 元素、日志和帮助文本
- **一键切换**：无需重启即可更改语言

#### 🖥️ **用户友好界面**
- **现代 Tkinter GUI**：简洁、直观的设计
- **选项卡布局**：分离单句和批量模式
- **实时控制台**：监控生成进度
- **日志导出**：将控制台输出保存到文件
- **错误处理**：清晰的错误消息和指导

#### 🎨 **附加功能**
- **CPU/GPU 模式选择**：支持有无 GPU 运行
- **自定义输出位置**：选择音频文件保存位置
- **一键停止**：随时取消正在运行的任务
- **自动恢复**：从停止的地方继续
- **可移植**：轻松将项目移动到任何位置

### 🛠️ 技术栈

- **核心模型**：IndexTTS2（基于 bilibili 的开源模型）
- **GUI 框架**：Tkinter（Python）
- **深度学习**：PyTorch、Transformers
- **音频处理**：LibROSA、TorchAudio
- **使用的模型**：
  - amphion/MaskGCT
  - facebook/w2v-bert-2.0
  - funasr/campplus
  - nvidia/bigvgan_v2_22khz_80band_256x
  - 基于 Qwen 的定制情绪分析器

### 📋 系统要求

#### 最低要求
- **操作系统**：Windows 10/11（64 位）
- **Python**：3.10 或更高
- **内存**：8 GB
- **磁盘空间**：20 GB 可用空间
- **网络**：初始模型下载需要

#### 推荐配置
- **内存**：16 GB 或更多
- **GPU**：NVIDIA GPU，8GB+ 显存（CUDA 兼容）
- **磁盘空间**：30 GB 可用空间（用于模型和输出）

### 🚀 快速开始

#### 步骤 1：克隆仓库

```bash
git clone https://github.com/your-username/index-tts2-gui.git
cd index-tts2-gui
```

#### 步骤 2：下载模型（约 8-10 GB）

**方式 A：自动下载（推荐）**

```bash
download_models.bat
```

脚本将：
- 优先尝试国际源（huggingface.co）
- 如需要则回退到国内镜像（hf-mirror.com）
- 自动验证所有下载

**方式 B：手动下载**

查看 [MODEL_DOWNLOAD_GUIDE.txt](MODEL_DOWNLOAD_GUIDE.txt) 获取详细说明。

#### 步骤 3：设置环境

```bash
setup_new_location.bat
```

这将：
- 检查 Python 安装
- 创建虚拟环境
- 安装所有依赖
- 验证必需文件

#### 步骤 4：启动应用程序

**GUI 模式（无控制台）：**
```bash
start_gui.pyw
```

**调试模式（带控制台）：**
```bash
run_tts_gui.bat
```

### 📚 详细安装指南

有关完整的分步说明，请参阅：
- **[START_HERE.txt](START_HERE.txt)** - 欢迎和快速概览
- **[SCRIPTS_OVERVIEW.txt](SCRIPTS_OVERVIEW.txt)** - 所有脚本说明
- **[MODEL_DOWNLOAD_GUIDE.txt](MODEL_DOWNLOAD_GUIDE.txt)** - 模型下载说明
- **[SETUP_GUIDE.txt](SETUP_GUIDE.txt)** - 完整设置指南
- **[USER_MANUAL.txt](USER_MANUAL.txt)** - GUI 使用手册

### 💡 使用示例

#### 单句生成

1. 启动 GUI
2. 转到"单句模式"选项卡
3. 选择参考音频（您的目标声音）
4. 输入文本或使用情绪滑块
5. 点击"生成音频"
6. 选择保存位置

#### 批量处理

1. 准备包含对话行的文本文件：
   ```
   (happy) 大家早上好！
   (sad and tired) 我今天感觉很累。
   (excited) 这真是个好消息！
   ```

2. 转到"批量模式"选项卡
3. 选择文本文件、参考音频和输出目录
4. 配置情绪设置
5. 点击"添加到任务列表"
6. 点击"开始所有任务"

#### 多 GPU 处理

1. 在 GPU 设置中启用"多 GPU"模式
2. 像往常一样添加批量任务
3. 系统将自动在所有可用 GPU 上分配工作
4. 在控制台中监控进度

### ⚙️ 配置

#### 情绪控制

- **滑块**：单独调整 8 个情绪维度
- **情绪档位**：快速预设（低 0.6，中 0.8，高 1.0）
- **声纹保护**：启用以保持说话人特征

#### GPU 设置

- **自动**：系统自动选择 GPU
- **单 GPU**：选择特定 GPU（如果您有多个）
- **多 GPU**：为批量任务使用所有可用 GPU
- **CPU 模式**：无 GPU 也可工作（较慢）

#### 文本文件格式

**纯文本：**
```
你好，你好吗？
我很好！
```

**带情绪标签（仅限英文）：**
```
(cheerful and excited) 你好，你好吗？
(calm and gentle) 我很好！
```

⚠️ **重要**：情绪描述必须使用**英文**并在括号内。

### ❓ 常见问题和解决方案

#### 问题："找不到模型文件"

**解决方案：**
1. 运行 `download_models.bat` 下载 HuggingFace 模型
2. 从项目发布页面下载定制模型文件
3. 验证目录结构与 [MODEL_DOWNLOAD_GUIDE.txt](MODEL_DOWNLOAD_GUIDE.txt) 匹配

#### 问题："无法访问 huggingface.co"

**解决方案：**
- 运行 `download_models.bat` - 它会自动尝试国内镜像（hf-mirror.com）
- 或手动从以下地址下载：https://hf-mirror.com

#### 问题："未检测到 GPU"

**解决方案：**
1. 更新 NVIDIA GPU 驱动程序
2. 安装 CUDA 工具包（11.8 或 12.1）
3. 验证 PyTorch 可以检测 GPU：
   ```bash
   python -c "import torch; print(torch.cuda.is_available())"
   ```
4. 使用 CPU 模式作为备用

#### 问题："内存不足"

**解决方案：**
- 减少批量大小
- 启用多 GPU 模式
- 降低情绪强度
- 关闭其他应用程序
- 使用 CPU 模式（较慢但有效）

#### 问题："情绪不起作用"

**解决方案：**
- 验证情绪描述格式：`(emotion words) dialogue text`
- 情绪描述使用**英文**
- 检查文本文件编码（应为 UTF-8）
- 在批量模式中启用"使用基于文本的情绪"

#### 问题："应用程序无法启动"

**解决方案：**
1. 检查 Python 版本：`python --version`（应为 3.10+）
2. 重新安装依赖：
   ```bash
   cd project-folder
   setup_new_location.bat
   ```
3. 检查 `startup_log.txt` 中的日志
4. 使用控制台运行以查看错误：`run_tts_gui.bat`

更多故障排除，请参阅 [SETUP_GUIDE.txt](SETUP_GUIDE.txt)。

### 🗂️ 项目结构

```
index-tts2-gui/
├── tts_batch_gui.py          # 主 GUI 应用程序
├── batch_generate.py         # 后端 TTS 引擎
├── download_models.bat       # 模型下载脚本
├── setup_new_location.bat    # 环境设置脚本
├── start_gui.pyw             # GUI 启动器（无控制台）
├── run_tts_gui.bat           # GUI 启动器（带控制台）
├── requirements.txt          # Python 依赖
├── checkpoints/              # 模型文件（需要下载）
│   ├── gpt.pth
│   ├── s2mel.pth
│   ├── bpe.model
│   ├── qwen0.6bemo4-merge/
│   └── hf_cache/             # HuggingFace 模型
├── indextts/                 # 核心 TTS 模块
├── assets/                   # 图片和图标
├── docs/                     # 附加文档
└── examples/                 # 示例音频文件
```

### 🤝 贡献

欢迎贡献！请随时：
- 报告错误和问题
- 建议新功能
- 提交拉取请求
- 改进文档

### 📄 许可证

本项目采用自定义开源许可证。详情请参阅 [LICENSE_ZH.txt](LICENSE_ZH.txt)。

**要点：**
- ✅ 个人和商业使用免费
- ✅ 允许修改和重新分发
- ✅ 不提供保证
- ⚠️ 必须保留版权声明

### 🙏 致谢

本项目离不开以下支持：

- **[bilibili](https://www.bilibili.com/)** - 开源 IndexTTS2 模型，使先进的 TTS 技术对所有人开放
- **amphion/MaskGCT** - 语义编解码器模型
- **facebook/w2v-bert-2.0** - 语音表示模型
- **funasr/campplus** - 说话人嵌入模型
- **nvidia/bigvgan** - 高质量声码器
- **Qwen 团队** - 情绪分析模型
- 所有提供反馈的贡献者和用户

### 📞 联系和支持

- **文档**：查看 [USER_MANUAL.txt](USER_MANUAL.txt)
- **问题**：[GitHub Issues](https://github.com/your-username/index-tts2-gui/issues)
- **讨论**：[GitHub Discussions](https://github.com/your-username/index-tts2-gui/discussions)

### 🌟 Star 历史

如果您觉得这个项目有用，请考虑给它一个 star ⭐！

---

## 日本語

### 📖 このプロジェクトについて

IndexTTS2 バッチ生成 GUI は、強力な IndexTTS2 モデル上に構築されたユーザーフレンドリーなデスクトップアプリケーションです。高品質で感情表現豊かな音声をテキストから生成するための直感的なインターフェースと、高度なバッチ処理機能を提供します。

### ✨ 主な機能

#### 🎭 **高度な感情制御**
- **8つの感情次元**：Happy、Sad、Angry、Fear、Disgust、Surprise、Calm、Neutral
- **細かい制御**：各感情を0.0から1.0まで精密スライダーで調整
- **感情強度レベル**：Low、Mid、Highプリセットで素早く調整
- **声紋保護モード**：感情表現と話者特性のバランス
- **感情ベクトル永続化**：感情設定を保存し、複数のタスクで再利用

#### 🎯 **柔軟なテキスト入力形式**
- **プレーンテキスト**：シンプルな対話行
- **感情タグ付きテキスト**：括弧内の英語の感情説明
  ```
  (cheerful and excited) こんにちは、お元気ですか？
  (calm and gentle) 元気です、ありがとう！
  ```
- **自動感情検出**：AIによるテキストからの感情分析

#### ⚡ **高性能バッチ処理**
- **単一文モード**：迅速なテストとプレビュー
- **バッチモード**：数百行のテキストファイル全体を処理
- **マルチGPUサポート**：複数のGPUにタスクを分散して高速処理
- **順次タスクキュー**：複数のタスクを自動的に設定および実行
- **進行状況追跡**：リアルタイムの進行状況バーとステータス更新

#### 🌍 **多言語インターフェース**
- **4言語**：中国語、英語、日本語、スペイン語
- **完全なローカライゼーション**：すべてのUI要素、ログ、ヘルプテキスト
- **ワンクリック切り替え**：再起動なしで言語を即座に変更

#### 🖥️ **ユーザーフレンドリーなインターフェース**
- **モダンなTkinter GUI**：クリーンで直感的なデザイン
- **タブレイアウト**：単一モードとバッチモードを分離
- **リアルタイムコンソール**：生成進行状況を監視
- **ログエクスポート**：コンソール出力をファイルに保存
- **エラー処理**：明確なエラーメッセージとガイダンス

#### 🎨 **追加機能**
- **CPU/GPUモード選択**：GPUの有無にかかわらず動作
- **カスタム出力場所**：オーディオファイルの保存場所を選択
- **ワンクリック停止**：実行中のタスクをいつでもキャンセル
- **自動再開**：停止した場所から続行
- **ポータブル**：プロジェクトを任意の場所に簡単に移動

### 🛠️ 技術スタック

- **コアモデル**：IndexTTS2（bilibiliのオープンソースモデルに基づく）
- **GUIフレームワーク**：Tkinter（Python）
- **深層学習**：PyTorch、Transformers
- **オーディオ処理**：LibROSA、TorchAudio
- **使用モデル**：
  - amphion/MaskGCT
  - facebook/w2v-bert-2.0
  - funasr/campplus
  - nvidia/bigvgan_v2_22khz_80band_256x
  - カスタムQwenベースの感情アナライザー

### 📋 要件

#### 最小要件
- **OS**：Windows 10/11（64ビット）
- **Python**：3.10以上
- **RAM**：8 GB
- **ディスク容量**：20 GB の空き容量
- **インターネット**：初期モデルダウンロードに必要

#### 推奨要件
- **RAM**：16 GB以上
- **GPU**：8GB以上のVRAMを持つNVIDIA GPU（CUDA互換）
- **ディスク容量**：30 GB の空き容量（モデルと出力用）

### 🚀 クイックスタート

#### ステップ 1：リポジトリをクローン

```bash
git clone https://github.com/your-username/index-tts2-gui.git
cd index-tts2-gui
```

#### ステップ 2：モデルをダウンロード（約8-10 GB）

**オプション A：自動ダウンロード（推奨）**

```bash
download_models.bat
```

スクリプトは：
- まず国際ソースを試行（huggingface.co）
- 必要に応じて中国ミラーにフォールバック（hf-mirror.com）
- すべてのダウンロードを自動的に検証

**オプション B：手動ダウンロード**

詳細な手順については、[MODEL_DOWNLOAD_GUIDE.txt](MODEL_DOWNLOAD_GUIDE.txt) を参照してください。

#### ステップ 3：環境をセットアップ

```bash
setup_new_location.bat
```

これにより：
- Python のインストールを確認
- 仮想環境を作成
- すべての依存関係をインストール
- 必要なファイルを検証

#### ステップ 4：アプリケーションを起動

**GUIモード（コンソールなし）：**
```bash
start_gui.pyw
```

**デバッグモード（コンソール付き）：**
```bash
run_tts_gui.bat
```

### 📚 詳細なインストールガイド

完全なステップバイステップの手順については、以下を参照してください：
- **[START_HERE.txt](START_HERE.txt)** - ようこそとクイック概要
- **[SCRIPTS_OVERVIEW.txt](SCRIPTS_OVERVIEW.txt)** - すべてのスクリプトの説明
- **[MODEL_DOWNLOAD_GUIDE.txt](MODEL_DOWNLOAD_GUIDE.txt)** - モデルダウンロード手順
- **[SETUP_GUIDE.txt](SETUP_GUIDE.txt)** - 完全なセットアップガイド
- **[USER_MANUAL.txt](USER_MANUAL.txt)** - GUIの使用方法

### 🙏 謝辞

このプロジェクトは以下のサポートなしには実現できませんでした：

- **[bilibili](https://www.bilibili.com/)** - IndexTTS2モデルをオープンソース化し、高度なTTS技術を誰でも利用できるようにしてくれたこと
- **amphion/MaskGCT** - セマンティックコーデックモデル
- **facebook/w2v-bert-2.0** - 音声表現モデル
- **funasr/campplus** - 話者埋め込みモデル
- **nvidia/bigvgan** - 高品質ボコーダー
- **Qwen チーム** - 感情分析モデル
- フィードバックを提供してくれたすべての貢献者とユーザー

---

## Español

### 🙏 Agradecimientos

Este proyecto no sería posible sin:

- **[bilibili](https://www.bilibili.com/)** - Por hacer de código abierto el modelo IndexTTS2 y hacer que la tecnología TTS avanzada sea accesible para todos
- **amphion/MaskGCT** - Modelo de códec semántico
- **facebook/w2v-bert-2.0** - Modelo de representación del habla
- **funasr/campplus** - Modelo de incrustación del hablante
- **nvidia/bigvgan** - Vocoder de alta calidad
- **Equipo Qwen** - Modelo de análisis de emociones
- Todos los colaboradores y usuarios que brindan comentarios

---

<div align="center">

**Made with ❤️ by the IndexTTS2 GUI Community**

**基于 bilibili 开源的 IndexTTS2 模型构建**

If you find this project helpful, please give it a ⭐!

如果您觉得这个项目有帮助，请给它一个 ⭐！

このプロジェクトが役に立つと思ったら、⭐ をつけてください！

Si encuentra útil este proyecto, ¡dele una ⭐!

</div>

