package com.tliasweb.controller;

import com.tliasweb.annotation.Log;
import com.tliasweb.pojo.Dept;
import com.tliasweb.pojo.Result;
import com.tliasweb.service.DeptService;
import com.tliasweb.service.impl.DeptServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/*
 * 部门管理Controller
 */

@Slf4j
@RestController
@RequestMapping("/depts")
public class DeptController {

    //private static Logger log = LoggerFactory.getLogger(DeptController.class);

    @Autowired
    private DeptServiceImpl deptService;

    /**
     * 查询部门数据
     * @return
     */
    @GetMapping
    public Result list()  {

        log.info("查询全部部门数据");

        //调用service查询部门数据
        List<Dept> deptList = deptService.list();

        return Result.success(deptList);
    }

    /**
     * 删除部门
     * @param id
     * @return
     */
    @Log
    @DeleteMapping("/{id}")
    public Result delete(@PathVariable Integer id) throws Exception {

        log.info("根据id删除部门:{}", id);

        //调用service删除部门
        deptService.delete(id);

        return Result.success();
    }

    /**
     *  新增部门
     * @return
     */
    @Log
    @PostMapping
    public Result add(@RequestBody Dept dept) {

        log.info("新增部门:{}", dept);

        //调用service新增部门
        deptService.add(dept);

        return Result.success();
    }
}
