#!/bin/sh

DIR=$1

if [ ! -d $DIR ]; then
	echo "$DIR doesn't exist"
	exit 0
fi

cd $DIR

echo Upgrading $DIR

[ -e bl2.img ] && ( echo 0 > /sys/class/block/mmcblk0boot0/force_ro && dd if=bl2.img of=/dev/mmcblk0boot0 bs=512 && echo 1 > /sys/class/block/mmcblk0boot0/force_ro )
[ -e u-boot-mtk-fit.bin ] && dd if=u-boot-mtk-fit.bin of=/dev/mmcblk0p2 bs=512
[ -e boot.img ] && dd if=boot.img of=/dev/mmcblk0p4 bs=512
[ -e tee.img ] && dd if=tee.img of=/dev/mmcblk0p5 bs=512

[ ! -d /data/misc/wifi ] && mkdir -p /data/misc/wifi
[ -e wifi.cfg ] && cp wifi.cfg /data/misc/wifi/

cd ..

sync
sync

exit 1
